/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.ByteUtil;
import us.hebi.quickbuf.JdkMath;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.Schubfach;
import us.hebi.quickbuf.Utf8String;

class JsonEncoding {
    private static final String FLOAT_ENCODING_TYPE = System.getProperty("quickbuf.json.float_encoding", "minimal");
    private static final boolean ENCODE_FLOAT_NO_COMMA = "no_comma".equalsIgnoreCase(FLOAT_ENCODING_TYPE);
    static final boolean ENCODE_FLOAT_FIXED = "fixed".equalsIgnoreCase(FLOAT_ENCODING_TYPE);
    private static final boolean ENCODE_FLOAT_MINIMAL = !ENCODE_FLOAT_NO_COMMA && !ENCODE_FLOAT_FIXED;

    JsonEncoding() {
    }

    static FloatEncoder getFloatEncoder() {
        if (ENCODE_FLOAT_FIXED) {
            return FixedFloatEncoder.INSTANCE;
        }
        if (ENCODE_FLOAT_NO_COMMA) {
            return new NoCommaFloatEncoder();
        }
        return new MinimalFloatEncoder();
    }

    static class BooleanEncoding {
        private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
        private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};

        BooleanEncoding() {
        }

        static void writeBoolean(boolean value, RepeatedByte output) {
            if (value) {
                output.addAll(TRUE);
            } else {
                output.addAll(FALSE);
            }
        }
    }

    static class MinimalFloatEncoder
    extends SchubfachEncoder {
        private static final int MASK_28 = 0xFFFFFFF;

        MinimalFloatEncoder() {
        }

        @Override
        public void encodeFloat(boolean negative, int f, int e) {
            if (negative) {
                this.append(45);
            }
            int len = Schubfach.getDecimalLength(f);
            f = (int)((long)f * Schubfach.getNormalizationScale(9, len));
            int h = (int)((long)f * 1441151881L >>> 57);
            int l = f - 100000000 * h;
            if (0 < (e += len) && e <= 7) {
                this.toChars1(h, l, e);
            } else if (-3 < e && e <= 0) {
                this.toChars2(h, l, e);
            } else {
                this.toChars3(h, l, e);
            }
        }

        private void toChars1(int h, int l, int e) {
            int t;
            int i;
            this.appendDigit(h);
            int y = (int)(JdkMath.multiplyHigh((long)(l + 1) << 28, 193428131138340668L) >>> 20) - 1;
            for (i = 1; i < e; ++i) {
                t = 10 * y;
                this.appendDigit(t >>> 28);
                y = t & 0xFFFFFFF;
            }
            this.append(46);
            while (i <= 8) {
                t = 10 * y;
                this.appendDigit(t >>> 28);
                y = t & 0xFFFFFFF;
                ++i;
            }
            this.removeTrailingZeroes();
        }

        private void toChars2(int h, int l, int e) {
            this.appendDigit(0);
            this.append(46);
            while (e < 0) {
                this.appendDigit(0);
                ++e;
            }
            this.appendDigit(h);
            this.append8Digits(l);
            this.removeTrailingZeroes();
        }

        private void toChars3(int h, int l, int e) {
            this.appendDigit(h);
            this.append(46);
            this.append8Digits(l);
            this.removeTrailingZeroes();
            this.exponent(e - 1);
        }

        @Override
        public void encodeDouble(boolean negative, long f, int e) {
            if (negative) {
                this.append(45);
            }
            this.toChars(f, e);
        }

        private void toChars(long f, int e) {
            int len = Schubfach.getDecimalLength(f);
            long hm = JdkMath.multiplyHigh(f *= Schubfach.getNormalizationScale(17, len), 193428131138340668L) >>> 20;
            int l = (int)(f - 100000000L * hm);
            int h = (int)(hm * 1441151881L >>> 57);
            int m = (int)(hm - (long)(100000000 * h));
            if (0 < (e += len) && e <= 7) {
                this.toChars1(h, m, l, e);
            } else if (-3 < e && e <= 0) {
                this.toChars2(h, m, l, e);
            } else {
                this.toChars3(h, m, l, e);
            }
        }

        private void toChars1(int h, int m, int l, int e) {
            int t;
            int i;
            this.appendDigit(h);
            int y = (int)(JdkMath.multiplyHigh((long)(m + 1) << 28, 193428131138340668L) >>> 20) - 1;
            for (i = 1; i < e; ++i) {
                t = 10 * y;
                this.appendDigit(t >>> 28);
                y = t & 0xFFFFFFF;
            }
            this.append(46);
            while (i <= 8) {
                t = 10 * y;
                this.appendDigit(t >>> 28);
                y = t & 0xFFFFFFF;
                ++i;
            }
            this.lowDigits(l);
        }

        private void toChars2(int h, int m, int l, int e) {
            this.appendDigit(0);
            this.append(46);
            while (e < 0) {
                this.appendDigit(0);
                ++e;
            }
            this.appendDigit(h);
            this.append8Digits(m);
            this.lowDigits(l);
        }

        private void toChars3(int h, int m, int l, int e) {
            this.appendDigit(h);
            this.append(46);
            this.append8Digits(m);
            this.lowDigits(l);
            this.exponent(e - 1);
        }

        private void lowDigits(int l) {
            if (l != 0) {
                this.append8Digits(l);
            }
            this.removeTrailingZeroes();
        }

        private void removeTrailingZeroes() {
            while (this.output.array[this.output.length - 1] == 48) {
                --this.output.length;
            }
            if (this.output.array[this.output.length - 1] == 46) {
                --this.output.length;
            }
        }

        private void exponent(int e) {
            this.output.length = NumberEncoding.writeExponent(this.output.array, this.output.length, e);
        }

        private void append(int c) {
            this.output.array[this.output.length++] = (byte)c;
        }

        private void appendDigit(int d) {
            this.output.array[this.output.length++] = (byte)(48 + d);
        }

        private void append8Digits(int m) {
            this.output.length += NumberEncoding.write8Digits(this.output.array, this.output.length, m);
        }
    }

    static class NoCommaFloatEncoder
    extends SchubfachEncoder {
        static final byte ZERO = 48;
        static final short DOT_ZERO_LE = 12334;
        static final byte E = 69;
        static final byte NEGATIVE_SIGN = 45;

        NoCommaFloatEncoder() {
        }

        @Override
        public void encodeFloat(boolean negative, int significand, int exponent) {
            byte[] buffer = this.output.array;
            if (negative) {
                this.output.add((byte)45);
            }
            int newLength = NumberEncoding.writePositiveInt(significand, buffer, this.output.length);
            int trailingZeros = NoCommaFloatEncoder.getNumTrailingZeros(buffer, this.output.length, newLength - 1);
            this.output.length = newLength -= trailingZeros;
            if ((exponent += trailingZeros) != 0) {
                this.output.length = exponent > 0 && exponent <= 2 && trailingZeros >= exponent ? (this.output.length += exponent) : NumberEncoding.writeExponent(buffer, newLength, exponent);
            }
        }

        @Override
        public void encodeDouble(boolean negative, long significand, int exponent) {
            byte[] buffer = this.output.array;
            if (negative) {
                this.output.add((byte)45);
            }
            int newLength = NumberEncoding.writePositiveLong(significand, buffer, this.output.length);
            int trailingZeros = NoCommaFloatEncoder.getNumTrailingZeros(buffer, this.output.length, newLength - 1);
            this.output.length = newLength -= trailingZeros;
            if ((exponent += trailingZeros) != 0) {
                if (exponent > 0 && exponent <= 2 && trailingZeros >= exponent) {
                    this.output.length += exponent;
                } else {
                    this.output.add((byte)69);
                    NumberEncoding.writeInt(exponent, this.output);
                }
            }
        }

        static int getNumTrailingZeros(byte[] buffer, int startIx, int maxIx) {
            for (int i = maxIx; i > startIx; --i) {
                if (buffer[i] == 48) continue;
                return maxIx - i;
            }
            return maxIx - startIx;
        }
    }

    static abstract class SchubfachEncoder
    implements Schubfach.FloatEncoder,
    Schubfach.DoubleEncoder,
    FloatEncoder {
        protected RepeatedByte output;
        private static final byte[] PLUS_ZERO = "0".getBytes(ProtoUtil.Charsets.ASCII);
        private static final byte[] MINUS_ZERO = PLUS_ZERO;
        private static final byte[] PLUS_INF = "\"Infinity\"".getBytes(ProtoUtil.Charsets.ASCII);
        private static final byte[] MINUS_INF = "\"-Infinity\"".getBytes(ProtoUtil.Charsets.ASCII);
        private static final byte[] NAN = "\"NaN\"".getBytes(ProtoUtil.Charsets.ASCII);
        public static final int MAX_CHARS_FLOAT = 16;
        public static final int MAX_CHARS_DOUBLE = 25;

        SchubfachEncoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeFloat(float value, RepeatedByte output) {
            try {
                this.output = (RepeatedByte)output.reserve(16);
                int type = Schubfach.encodeFloat(value, this);
                if (type != 0) {
                    this.writeSpecial(type, output);
                }
            }
            finally {
                this.output = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeDouble(double value, RepeatedByte output) {
            try {
                this.output = (RepeatedByte)output.reserve(25);
                int type = Schubfach.encodeDouble(value, this);
                if (type != 0) {
                    this.writeSpecial(type, output);
                }
            }
            finally {
                this.output = null;
            }
        }

        private void writeSpecial(int type, RepeatedByte output) {
            switch (type) {
                case 0: {
                    throw new IllegalArgumentException("not a special type");
                }
                case 1: {
                    output.addAll(PLUS_ZERO);
                    break;
                }
                case 2: {
                    output.addAll(MINUS_ZERO);
                    break;
                }
                case 3: {
                    output.addAll(PLUS_INF);
                    break;
                }
                case 4: {
                    output.addAll(MINUS_INF);
                    break;
                }
                default: {
                    output.addAll(NAN);
                }
            }
        }
    }

    static enum FixedFloatEncoder implements FloatEncoder
    {
        INSTANCE;


        @Override
        public void writeFloat(float value, RepeatedByte output) {
            NumberEncoding.writeFloat(value, output);
        }

        @Override
        public void writeDouble(double value, RepeatedByte output) {
            NumberEncoding.writeDouble(value, output);
        }
    }

    static interface FloatEncoder {
        public void writeFloat(float var1, RepeatedByte var2);

        public void writeDouble(double var1, RepeatedByte var3);
    }

    static class NumberEncoding {
        private static final short[] digits = new short[]{12336, 12592, 12848, 13104, 13360, 13616, 13872, 14128, 14384, 14640, 12337, 12593, 12849, 13105, 13361, 13617, 13873, 14129, 14385, 14641, 12338, 12594, 12850, 13106, 13362, 13618, 13874, 14130, 14386, 14642, 12339, 12595, 12851, 13107, 13363, 13619, 13875, 14131, 14387, 14643, 12340, 12596, 12852, 13108, 13364, 13620, 13876, 14132, 14388, 14644, 12341, 12597, 12853, 13109, 13365, 13621, 13877, 14133, 14389, 14645, 12342, 12598, 12854, 13110, 13366, 13622, 13878, 14134, 14390, 14646, 12343, 12599, 12855, 13111, 13367, 13623, 13879, 14135, 14391, 14647, 12344, 12600, 12856, 13112, 13368, 13624, 13880, 14136, 14392, 14648, 12345, 12601, 12857, 13113, 13369, 13625, 13881, 14137, 14393, 14649};
        private static final int[] THREE_DIGITS = new int[1000];
        private static final int DIGIT_00X = 16;
        private static final int DIGIT_0X0 = 8;
        private static final int DIGIT_X00 = 0;
        private static final int NUM_DIGITS = 28;
        private static final int NUM_FINAL_DIGITS = 24;
        private static final int NUM_DIGITS_MASK = 3;
        private static final int pow3 = 1000;
        private static final int pow6 = 1000000;
        private static final int pow9 = 1000000000;
        private static final long pow12 = 1000000000000L;
        private static final long pow15 = 1000000000000000L;
        private static final long pow18 = 1000000000000000000L;
        static final double WHOLE_NUMBER = 4.503599627370496E15;
        static final double max3 = 4.503599627370496E12;
        static final double max6 = 4.503599627370496E9;
        static final double max9 = 4503599.627370496;
        static final double max12 = 4503.599627370496;
        private static final byte[] NEGATIVE_INF;
        private static final byte[] POSITIVE_INF;
        private static final byte[] NAN;
        private static final byte[] MIN_INT;
        private static final byte[] MIN_LONG;
        private static final int MAX_INT_SIZE;
        private static final int MAX_LONG_SIZE;
        private static final int MAX_FIXED_DOUBLE_SIZE;

        NumberEncoding() {
        }

        public static void writeInt(int value, RepeatedByte output) {
            output.reserve(MAX_INT_SIZE);
            if (value < 0) {
                if (value == Integer.MIN_VALUE) {
                    output.addAll(MIN_INT);
                    return;
                }
                output.array[output.length++] = 45;
                output.length = NumberEncoding.writePositiveInt(-value, output.array, output.length);
            } else {
                output.length = NumberEncoding.writePositiveInt(value, output.array, output.length);
            }
        }

        public static void writeLong(long value, RepeatedByte output) {
            output.reserve(MAX_LONG_SIZE);
            if (value < 0L) {
                if (value == Long.MIN_VALUE) {
                    output.addAll(MIN_LONG);
                    return;
                }
                output.array[output.length++] = 45;
                output.length = NumberEncoding.writePositiveLong(-value, output.array, output.length);
            } else {
                output.length = NumberEncoding.writePositiveLong(value, output.array, output.length);
            }
        }

        private static int writePositiveInt(int q10, byte[] buf, int pos) {
            int q7 = q10 / 1000;
            if (q7 == 0) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q10);
                return pos;
            }
            int q4 = q10 / 1000000;
            if (q4 == 0) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q7);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000);
                return pos;
            }
            int q1 = q10 / 1000000000;
            if (q1 == 0) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q4);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000);
                return pos;
            }
            pos += NumberEncoding.writeSingleDigit(buf, pos, q1);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q4 - q1 * 1000);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000);
            return pos;
        }

        private static int writePositiveLong(long q19, byte[] buf, int pos) {
            long q16 = q19 / 1000L;
            if (q16 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q19);
                return pos;
            }
            long q13 = q19 / 1000000L;
            if (q13 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q16);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q10 = q19 / 1000000000L;
            if (q10 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q13);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q7 = q19 / 1000000000000L;
            if (q7 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q10);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q4 = q19 / 1000000000000000L;
            if (q4 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q7);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            long q1 = q19 / 1000000000000000000L;
            if (q1 == 0L) {
                pos += NumberEncoding.writeFirstDigits(buf, pos, q4);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
                pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
                return pos;
            }
            pos += NumberEncoding.writeSingleDigit(buf, pos, q1);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q4 - q1 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q7 - q4 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q10 - q7 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q13 - q10 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q16 - q13 * 1000L);
            pos += NumberEncoding.writeThreeDigits(buf, pos, q19 - q16 * 1000L);
            return pos;
        }

        public static void writeFloat(float val, RepeatedByte output) {
            NumberEncoding.writeDouble6(val, output);
        }

        public static void writeDouble(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE + 1);
            double pval = NumberEncoding.writeSpecialValues(val, 4.503599627370496E12, output);
            if (pval >= 0.0) {
                if (pval < 4503.599627370496) {
                    NumberEncoding.writeDouble12(pval, output);
                } else if (pval < 4503599.627370496) {
                    NumberEncoding.writeDouble9(pval, output);
                } else if (pval < 4.503599627370496E9) {
                    NumberEncoding.writeDouble6(pval, output);
                } else {
                    NumberEncoding.writeDouble3(pval, output);
                }
            }
        }

        static void writeDouble12(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4503.599627370496, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1.0E12 + 0.5);
                long q7 = q19 / 1000000000000L;
                int pos = NumberEncoding.writePositiveInt((int)q7, buffer, output.length);
                long q12 = q19 - q7 * 1000000000000L;
                if (q12 != 0L) {
                    long q9 = q12 / 1000L;
                    long q6 = q12 / 1000000L;
                    long q3 = q12 / 1000000000L;
                    long r6 = q6 - q3 * 1000L;
                    long r9 = q9 - q6 * 1000L;
                    long r12 = q12 - q9 * 1000L;
                    buffer[pos++] = 46;
                    if (r12 != 0L) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r6);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r9);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r12);
                    } else if (r9 != 0L) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, r6);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r9);
                    } else if (r6 != 0L) {
                        pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, r6);
                    } else {
                        pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
                    }
                }
                output.length = pos;
            }
        }

        static void writeDouble9(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4503599.627370496, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1.0E9 + 0.5);
                long q10 = q19 / 1000000000L;
                int pos = NumberEncoding.writePositiveLong(q10, buffer, output.length);
                int q9 = (int)(q19 - q10 * 1000000000L);
                if (q9 != 0) {
                    buffer[pos++] = 46;
                    pos = NumberEncoding.writeFraction9(q9, buffer, pos);
                }
                output.length = pos;
            }
        }

        static int writeFraction9(int q9, byte[] buffer, int pos) {
            int q6 = q9 / 1000;
            int q3 = q9 / 1000000;
            int r6 = q6 - q3 * 1000;
            int r9 = q9 - q6 * 1000;
            if (r9 != 0) {
                pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                pos += NumberEncoding.writeThreeDigits(buffer, pos, r6);
                pos += NumberEncoding.writeFinalDigits(buffer, pos, r9);
            } else if (r6 != 0) {
                pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                pos += NumberEncoding.writeFinalDigits(buffer, pos, r6);
            } else {
                pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
            }
            return pos;
        }

        static void writeDouble6(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4.503599627370496E9, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1000000.0 + 0.5);
                long q13 = q19 / 1000000L;
                int pos = NumberEncoding.writePositiveLong(q13, buffer, output.length);
                int q6 = (int)(q19 - q13 * 1000000L);
                if (q6 != 0) {
                    buffer[pos++] = 46;
                    pos = NumberEncoding.writeFraction6(q6, buffer, pos);
                }
                output.length = pos;
            }
        }

        static int writeFraction6(int q6, byte[] buffer, int pos) {
            int q3 = q6 / 1000;
            int r6 = q6 - q3 * 1000;
            if (r6 != 0) {
                pos += NumberEncoding.writeThreeDigits(buffer, pos, q3);
                pos += NumberEncoding.writeFinalDigits(buffer, pos, r6);
            } else {
                pos += NumberEncoding.writeFinalDigits(buffer, pos, q3);
            }
            return pos;
        }

        static void writeDouble3(double val, RepeatedByte output) {
            output.reserve(MAX_FIXED_DOUBLE_SIZE);
            double pval = NumberEncoding.writeSpecialValues(val, 4.503599627370496E12, output);
            if (pval >= 0.0) {
                byte[] buffer = output.array;
                long q19 = (long)(pval * 1000.0 + 0.5);
                long q16 = q19 / 1000L;
                int pos = NumberEncoding.writePositiveLong(q16, buffer, output.length);
                int q3 = (int)(q19 - q16 * 1000L);
                if (q3 != 0) {
                    buffer[pos++] = 46;
                    pos = NumberEncoding.writeFraction3(q3, buffer, pos);
                }
                output.length = pos;
            }
        }

        static int writeFraction3(int q3, byte[] buffer, int pos) {
            return pos + NumberEncoding.writeFinalDigits(buffer, pos, q3);
        }

        private static double writeSpecialValues(double val, double maxValue, RepeatedByte output) {
            if (val < 0.0) {
                if (val == Double.NEGATIVE_INFINITY) {
                    output.addAll(NEGATIVE_INF);
                    return -1.0;
                }
                output.add((byte)45);
                val = -val;
            }
            if (val > maxValue) {
                if (val == Double.POSITIVE_INFINITY) {
                    output.addAll(POSITIVE_INF);
                } else if (val > 4.503599627370496E15 && val < 9.223372036854776E18) {
                    NumberEncoding.writeLong((long)val, output);
                } else {
                    StringEncoding.writeRawAscii(Double.toString(val), output);
                }
                return -1.0;
            }
            if (Double.isNaN(val)) {
                output.addAll(NAN);
                return -1.0;
            }
            return val;
        }

        private static int writeSingleDigit(byte[] buf, int pos, long number) {
            buf[pos] = (byte)(48L + number);
            return 1;
        }

        private static int writeFirstDigits(byte[] buf, int pos, long number) {
            return NumberEncoding.writeFirstDigits(buf, pos, (int)number);
        }

        private static int writeFinalDigits(byte[] buf, int pos, long number) {
            return NumberEncoding.writeFinalDigits(buf, pos, (int)number);
        }

        private static int writeThreeDigits(byte[] buf, int pos, long number) {
            NumberEncoding.writeThreeDigits(buf, pos, (int)number);
            return 3;
        }

        private static int writeFirstDigits(byte[] buf, int pos, int number) {
            int v = THREE_DIGITS[number];
            switch (v >>> 28) {
                case 1: {
                    buf[pos] = (byte)(v >>> 16);
                    return 1;
                }
                case 2: {
                    ByteUtil.writeLittleEndian16(buf, pos, (short)(v >>> 8));
                    return 2;
                }
                case 3: {
                    ByteUtil.writeLittleEndian32(buf, pos, v);
                    return 3;
                }
            }
            throw new AssertionError((Object)"invalid number");
        }

        private static int writeFinalDigits(byte[] buf, int pos, int number) {
            int v = THREE_DIGITS[number];
            switch (v >>> 24 & 3) {
                case 1: {
                    buf[pos] = (byte)v;
                    return 1;
                }
                case 2: {
                    ByteUtil.writeLittleEndian16(buf, pos, (short)v);
                    return 2;
                }
                case 3: {
                    ByteUtil.writeLittleEndian32(buf, pos, v);
                    return 3;
                }
            }
            throw new AssertionError((Object)"invalid number");
        }

        private static int writeThreeDigits(byte[] buf, int pos, int number) {
            ByteUtil.writeLittleEndian32(buf, pos, THREE_DIGITS[number]);
            return 3;
        }

        static int writeNineDigits(byte[] buf, int pos, int q9) {
            int q6 = q9 / 1000;
            int q3 = q9 / 1000000;
            ByteUtil.writeLittleEndian32(buf, pos, THREE_DIGITS[q3]);
            ByteUtil.writeLittleEndian32(buf, pos + 3, THREE_DIGITS[q6 - q3 * 1000]);
            ByteUtil.writeLittleEndian32(buf, pos + 6, THREE_DIGITS[q9 - q6 * 1000]);
            return 9;
        }

        static int writeExponent(byte[] buf, int pos, int exponent) {
            buf[pos++] = 69;
            if (exponent < 0) {
                buf[pos++] = 45;
                return NumberEncoding.writePositiveInt(-exponent, buf, pos);
            }
            return NumberEncoding.writePositiveInt(exponent, buf, pos);
        }

        static int write8Digits(byte[] buf, int pos, long q8) {
            long y1 = q8 * 140737489L;
            long y2 = (y1 & 0x7FFFFFFFFFFFL) * 100L;
            long y3 = (y2 & 0x7FFFFFFFFFFFL) * 100L;
            long y4 = (y3 & 0x7FFFFFFFFFFFL) * 100L;
            long d1 = digits[(int)(y1 >> 47)];
            long d2 = digits[(int)(y2 >> 47)] << 16;
            long d3 = (long)digits[(int)(y3 >> 47)] << 32;
            long d4 = (long)digits[(int)(y4 >> 47)] << 48;
            ByteUtil.writeLittleEndian64(buf, pos, d1 | d2 | d3 | d4);
            return 8;
        }

        static int write4Digits(byte[] buf, int pos, int q0) {
            int q1 = q0 * 5243 >> 19;
            int d1 = digits[q0 - q1 * 100] << 16;
            short d2 = digits[q1];
            ByteUtil.writeLittleEndian32(buf, pos, d1 | d2);
            return 4;
        }

        static int write3Digits(byte[] buf, int pos, int q3) {
            int q1 = q3 * 1311 >> 17;
            int value = digits[q3 - q1 * 100] << 8 | q1 + 48;
            ByteUtil.writeLittleEndian32(buf, pos, value);
            return 3;
        }

        static int write2Digits(byte[] buf, int pos, int q2) {
            ByteUtil.writeLittleEndian16(buf, pos, digits[q2]);
            return 2;
        }

        static int write1Digit(byte[] buf, int pos, int q1) {
            buf[pos] = (byte)(q1 + 48);
            return 1;
        }

        static {
            for (int i = 0; i < 1000; ++i) {
                int numDigits;
                int digit100 = 48 + i / 100;
                int digit10 = 48 + i % 100 / 10;
                int digit1 = 48 + i % 10;
                int n = digit100 == 48 ? (digit10 == 48 ? 1 : 2) : (numDigits = 3);
                int numFinalDigits = digit1 == 48 ? (digit10 == 48 ? 1 : 2) : 3;
                NumberEncoding.THREE_DIGITS[i] = numDigits << 28 | numFinalDigits << 24 | digit100 << 0 | digit10 << 8 | digit1 << 16;
            }
            NEGATIVE_INF = "\"-Infinity\"".getBytes(ProtoUtil.Charsets.ASCII);
            POSITIVE_INF = "\"Infinity\"".getBytes(ProtoUtil.Charsets.ASCII);
            NAN = "\"NaN\"".getBytes(ProtoUtil.Charsets.ASCII);
            MIN_INT = "-2147483648".getBytes(ProtoUtil.Charsets.ASCII);
            MIN_LONG = "-9223372036854775808".getBytes(ProtoUtil.Charsets.ASCII);
            MAX_INT_SIZE = MIN_INT.length + 1;
            MAX_LONG_SIZE = MIN_LONG.length + 1;
            MAX_FIXED_DOUBLE_SIZE = MAX_LONG_SIZE + 1;
        }
    }

    static class StringEncoding {
        private static final byte[] BASE16 = "0123456789abcdef".getBytes(ProtoUtil.Charsets.ASCII);
        private static final boolean[] CAN_DIRECT_WRITE_ASCII = new boolean[128];
        private static final boolean[] CAN_DIRECT_WRITE_UTF8 = new boolean[256];
        private static final byte[] ESCAPE_CHAR = new byte[128];

        StringEncoding() {
        }

        static void writeRawAscii(CharSequence sequence, RepeatedByte output) {
            int length = sequence.length();
            output.reserve(length);
            for (int i = 0; i < length; ++i) {
                output.array[output.length++] = (byte)sequence.charAt(i);
            }
        }

        static void writeQuotedUtf8(Utf8String sequence, RepeatedByte output) {
            int i;
            int offset;
            byte[] utf8;
            int numBytes;
            block5: {
                numBytes = sequence.size();
                utf8 = sequence.bytes();
                offset = output.addLength(numBytes + 2) + 1;
                byte[] out = output.array;
                out[offset - 1] = 34;
                for (i = 0; i < numBytes; ++i) {
                    byte c = utf8[i];
                    if (!CAN_DIRECT_WRITE_UTF8[c & 0xFF]) {
                        output.length = offset + i;
                        break block5;
                    }
                    out[offset + i] = c;
                }
                out[offset + i] = 34;
                return;
            }
            while (i < numBytes) {
                byte c = utf8[i];
                if (CAN_DIRECT_WRITE_UTF8[c & 0xFF]) {
                    int offset2 = output.addLength(1);
                    output.array[offset2] = c;
                } else {
                    StringEncoding.writeEscapedAscii((char)c, output);
                }
                ++i;
            }
            offset = output.addLength(1);
            output.array[offset] = 34;
        }

        static void writeQuotedUtf8(CharSequence sequence, RepeatedByte output) {
            int i;
            int offset;
            int numChars;
            block12: {
                numChars = sequence.length();
                offset = output.addLength(numChars + 2) + 1;
                byte[] ascii = output.array;
                ascii[offset - 1] = 34;
                for (i = 0; i < numChars; ++i) {
                    char c = sequence.charAt(i);
                    if (c >= '\u0080' || !CAN_DIRECT_WRITE_ASCII[c]) {
                        output.length = offset + i;
                        break block12;
                    }
                    ascii[offset + i] = (byte)c;
                }
                ascii[offset + i] = 34;
                return;
            }
            while (i < numChars) {
                char c = sequence.charAt(i);
                if (c < '\u0080') {
                    if (CAN_DIRECT_WRITE_ASCII[c]) {
                        int offset2 = output.addLength(1);
                        output.array[offset2] = (byte)c;
                    } else {
                        StringEncoding.writeEscapedAscii(c, output);
                    }
                } else if (c < '\u0800') {
                    int offset3 = output.addLength(2);
                    output.array[offset3] = (byte)(0x3C0 | c >>> 6);
                    output.array[offset3 + 1] = (byte)(0x80 | 0x3F & c);
                } else if (c < '\ud800' || '\udfff' < c) {
                    int offset4 = output.addLength(3);
                    output.array[offset4] = (byte)(0x1E0 | c >>> 12);
                    output.array[offset4 + 1] = (byte)(0x80 | 0x3F & c >>> 6);
                    output.array[offset4 + 2] = (byte)(0x80 | 0x3F & c);
                } else {
                    char low;
                    if (i + 1 == numChars || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                        throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    int offset5 = output.addLength(4);
                    output.array[offset5] = (byte)(0xF0 | codePoint >>> 18);
                    output.array[offset5 + 1] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    output.array[offset5 + 2] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    output.array[offset5 + 3] = (byte)(0x80 | 0x3F & codePoint);
                }
                ++i;
            }
            offset = output.addLength(1);
            output.array[offset] = 34;
        }

        private static void writeEscapedAscii(char c, RepeatedByte output) {
            byte escapeChar = ESCAPE_CHAR[c];
            if (escapeChar != 0) {
                int offset = output.addLength(2);
                output.array[offset] = 92;
                output.array[offset + 1] = escapeChar;
            } else {
                int offset = output.addLength(6);
                output.array[offset] = 92;
                output.array[offset + 1] = 117;
                output.array[offset + 2] = BASE16[c >> 12 & 0xF];
                output.array[offset + 3] = BASE16[c >> 8 & 0xF];
                output.array[offset + 4] = BASE16[c >> 4 & 0xF];
                output.array[offset + 5] = BASE16[c & 0xF];
            }
        }

        static {
            Arrays.fill(CAN_DIRECT_WRITE_UTF8, true);
            for (int i = 0; i < CAN_DIRECT_WRITE_ASCII.length; ++i) {
                if (i > 31 && i < 126 && i != 34 && i != 92) {
                    StringEncoding.CAN_DIRECT_WRITE_ASCII[i] = true;
                }
                StringEncoding.CAN_DIRECT_WRITE_UTF8[i] = CAN_DIRECT_WRITE_ASCII[i];
            }
            StringEncoding.ESCAPE_CHAR[34] = 34;
            StringEncoding.ESCAPE_CHAR[92] = 92;
            StringEncoding.ESCAPE_CHAR[8] = 98;
            StringEncoding.ESCAPE_CHAR[12] = 102;
            StringEncoding.ESCAPE_CHAR[10] = 110;
            StringEncoding.ESCAPE_CHAR[13] = 114;
            StringEncoding.ESCAPE_CHAR[9] = 116;
        }
    }

    static class Base64Encoding {
        private static final byte[] BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(ProtoUtil.Charsets.ASCII);

        Base64Encoding() {
        }

        static void writeQuotedBase64(byte[] bytes, int length, RepeatedByte output) {
            int encodedLength = (length + 2) / 3 << 2;
            int pos = output.addLength(encodedLength + 2);
            byte[] buffer = output.array;
            buffer[pos++] = 34;
            int blockableLength = length / 3 * 3;
            int i = 0;
            while (i < blockableLength) {
                int bits = (bytes[i] & 0xFF) << 16 | (bytes[i + 1] & 0xFF) << 8 | bytes[i + 2] & 0xFF;
                buffer[pos] = BASE64[bits >>> 18 & 0x3F];
                buffer[pos + 1] = BASE64[bits >>> 12 & 0x3F];
                buffer[pos + 2] = BASE64[bits >>> 6 & 0x3F];
                buffer[pos + 3] = BASE64[bits & 0x3F];
                i += 3;
                pos += 4;
            }
            int remaining = length - blockableLength;
            if (remaining > 0) {
                int bits = (bytes[i] & 0xFF) << 10 | (remaining == 2 ? (bytes[i + 1] & 0xFF) << 2 : 0);
                buffer[pos] = BASE64[bits >>> 12];
                buffer[pos + 1] = BASE64[bits >>> 6 & 0x3F];
                buffer[pos + 2] = remaining == 2 ? BASE64[bits & 0x3F] : 61;
                buffer[pos + 3] = 61;
                pos += 4;
            }
            buffer[pos] = 34;
        }
    }
}

