/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import us.hebi.quickbuf.ProtoUtil;

public final class FieldName {
    private final String jsonName;
    private final String protoName;
    private byte[] jsonKey;
    private byte[] protoKey;

    public static FieldName forField(String jsonName) {
        return new FieldName(jsonName, jsonName);
    }

    public static FieldName forField(String jsonName, String protoName) {
        return new FieldName(jsonName, protoName);
    }

    private FieldName(String jsonName, String protoName) {
        this.jsonName = jsonName;
        this.protoName = protoName;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public String getProtoName() {
        return this.protoName;
    }

    public byte[] getJsonKeyBytes() {
        if (this.jsonKey == null) {
            this.jsonKey = ('\"' + this.jsonName + '\"' + ':').getBytes(ProtoUtil.Charsets.UTF_8);
            if (this.jsonName.equals(this.protoName)) {
                this.protoKey = this.jsonKey;
            }
        }
        return this.jsonKey;
    }

    public byte[] getProtoKeyBytes() {
        if (this.protoKey == null) {
            this.protoKey = ('\"' + this.protoName + '\"' + ':').getBytes(ProtoUtil.Charsets.UTF_8);
            if (this.protoName.equals(this.jsonName)) {
                this.jsonKey = this.protoKey;
            }
        }
        return this.protoKey;
    }
}

