/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.util.Arrays;
import us.hebi.quickbuf.InvalidJsonException;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedByte;

class JsonDecoding {
    private JsonDecoding() {
    }

    static class Numbers {
        static final int[] intDigits;
        static final int[] floatDigits;
        static final int END_OF_NUMBER = -2;
        static final int DOT_IN_NUMBER = -3;
        static final int INVALID_CHAR_FOR_NUMBER = -1;
        static final long[] POW10;

        Numbers() {
        }

        static double readDouble(byte[] buffer, int tokenStart, int tokenEnd) {
            byte first = buffer[tokenStart];
            if (first == 45) {
                return -Numbers.readDouble(buffer, tokenStart + 1, tokenEnd);
            }
            if (first == 78) {
                ProtoUtil.checkArgument(tokenEnd - tokenStart == 3, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 1] == 97, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 2] == 78, "invalid double value");
                return Double.NaN;
            }
            if (first == 73) {
                ProtoUtil.checkArgument(tokenEnd - tokenStart == 8, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 1] == 110, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 2] == 102, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 3] == 105, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 4] == 110, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 5] == 105, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 6] == 116, "invalid double value");
                ProtoUtil.checkArgument(buffer[tokenStart + 7] == 121, "invalid double value");
            }
            String str = new String(buffer, tokenStart, tokenEnd - tokenStart, ProtoUtil.Charsets.ASCII);
            return Double.parseDouble(str);
        }

        static long readLong(byte[] buffer, int tokenStart, int tokenEnd) throws InvalidJsonException {
            boolean negative = false;
            int i = 0;
            int len = tokenEnd - tokenStart;
            long limit = -9223372036854775807L;
            if (len <= 0) {
                return 0L;
            }
            int firstChar = buffer[tokenStart] & 0xFF;
            if (firstChar < 48) {
                if (firstChar == 45) {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != 43) {
                    throw InvalidJsonException.illegalNumberFormat();
                }
                if (len == 1) {
                    throw InvalidJsonException.illegalNumberFormat();
                }
                ++i;
            }
            long multmin = limit / 10L;
            long result = 0L;
            while (i < len) {
                int digit;
                if ((digit = (buffer[i++ + tokenStart] & 0xFF) - 48) < 0 || result < multmin) {
                    throw InvalidJsonException.illegalNumberFormat();
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw InvalidJsonException.illegalNumberFormat();
                }
                result -= (long)digit;
            }
            return negative ? result : -result;
        }

        static boolean isInteger(byte[] buffer, int tokenStart, int tokenEnd) {
            if (tokenEnd == tokenStart) {
                return false;
            }
            if (buffer[tokenStart] == 45) {
                ++tokenStart;
            }
            for (int i = tokenStart; i < tokenEnd; ++i) {
                if (buffer[i] >= 0 && intDigits[buffer[i]] >= 0) continue;
                return false;
            }
            return true;
        }

        static {
            int i;
            intDigits = new int[127];
            floatDigits = new int[127];
            POW10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L};
            for (i = 0; i < floatDigits.length; ++i) {
                Numbers.floatDigits[i] = -1;
                Numbers.intDigits[i] = -1;
            }
            for (i = 48; i <= 57; ++i) {
                Numbers.floatDigits[i] = i - 48;
                Numbers.intDigits[i] = i - 48;
            }
            Numbers.floatDigits[44] = -2;
            Numbers.floatDigits[93] = -2;
            Numbers.floatDigits[125] = -2;
            Numbers.floatDigits[32] = -2;
            Numbers.floatDigits[46] = -3;
        }
    }

    static class StringDecoding {
        StringDecoding() {
        }

        static void readQuotedUtf8(JsonLexer source, RepeatedByte result) throws IOException {
            result.clear();
            int ch;
            while ((ch = source.readByte()) != 34) {
                if (ch != 92) {
                    result.add((byte)ch);
                    continue;
                }
                int escapedChar = source.readByte();
                if (escapedChar == 117) {
                    char c = StringDecoding.readEscapedHexChar(source);
                    if (c < '\u0080') {
                        result.add((byte)c);
                        continue;
                    }
                    if (c < '\u0800') {
                        result.add((byte)(0x3C0 | c >>> 6));
                        result.add((byte)(0x80 | 0x3F & c));
                        continue;
                    }
                    if (c < '\ud800' || '\udfff' < c) {
                        result.add((byte)(0x1E0 | c >>> 12));
                        result.add((byte)(0x80 | 0x3F & c >>> 6));
                        result.add((byte)(0x80 | 0x3F & c));
                        continue;
                    }
                    ProtoUtil.checkArgument(source.readByte() == 92, "expected surrogate pair");
                    ProtoUtil.checkArgument(source.readByte() == 117, "expected surrogate pair");
                    char low = StringDecoding.readEscapedHexChar(source);
                    int codePoint = Character.toCodePoint(c, low);
                    result.add((byte)(0xF0 | codePoint >>> 18));
                    result.add((byte)(0x80 | 0x3F & codePoint >>> 12));
                    result.add((byte)(0x80 | 0x3F & codePoint >>> 6));
                    result.add((byte)(0x80 | 0x3F & codePoint));
                    continue;
                }
                result.add((byte)StringDecoding.escapedToRawChar(escapedChar));
            }
            return;
        }

        static void readQuotedUtf8(JsonLexer source, StringBuilder result) throws IOException {
            result.setLength(0);
            int c;
            while ((c = source.readByte()) != 34) {
                int d;
                if (c == 92) {
                    int ch2 = source.readByte();
                    if (ch2 == 117) {
                        result.append(StringDecoding.readEscapedHexChar(source));
                        continue;
                    }
                    result.append(StringDecoding.escapedToRawChar(ch2));
                    continue;
                }
                if (c < 128) {
                    result.append((char)c);
                    continue;
                }
                int tmp = c & 0xF0;
                if (tmp == 192 || tmp == 208) {
                    d = source.readByte();
                    if ((d & 0xC0) != 128) {
                        throw new InvalidJsonException("Invalid UTF8 2 byte encoding");
                    }
                    c = (c & 0x1F) << 6 | d & 0x3F;
                } else if (tmp == 224) {
                    c &= 0xF;
                    d = source.readByte();
                    if ((d & 0xC0) != 128) {
                        throw new InvalidJsonException("Invalid UTF8 3 byte encoding");
                    }
                    c = c << 6 | d & 0x3F;
                    d = source.readByte();
                    if ((d & 0xC0) != 128) {
                        throw new InvalidJsonException("Invalid UTF8 3 byte encoding");
                    }
                    c = c << 6 | d & 0x3F;
                } else if (tmp == 240) {
                    d = source.readByte();
                    if ((d & 0xC0) != 128) {
                        throw new InvalidJsonException("Invalid UTF8 4 byte encoding");
                    }
                    c = (c & 7) << 6 | d & 0x3F;
                    d = source.readByte();
                    if ((d & 0xC0) != 128) {
                        throw new InvalidJsonException("Invalid UTF8 4 byte encoding");
                    }
                    c = c << 6 | d & 0x3F;
                    d = source.readByte();
                    if ((d & 0xC0) != 128) {
                        throw new InvalidJsonException("Invalid UTF8 4 byte encoding");
                    }
                    c = (c << 6 | d & 0x3F) - 65536;
                    result.append((char)(0xD800 | c >> 10));
                    c = 0xDC00 | c & 0x3FF;
                }
                result.append((char)c);
            }
            return;
        }

        static char escapedToRawChar(int escapedChar) throws InvalidJsonException {
            switch (escapedChar) {
                case 92: {
                    return '\\';
                }
                case 34: {
                    return '\"';
                }
                case 98: {
                    return '\b';
                }
                case 116: {
                    return '\t';
                }
                case 110: {
                    return '\n';
                }
                case 102: {
                    return '\f';
                }
                case 114: {
                    return '\r';
                }
            }
            throw new InvalidJsonException("Unknown character format in result: '" + (char)escapedChar + "'");
        }

        static char readEscapedHexChar(JsonLexer source) throws IOException {
            return (char)(StringDecoding.readHexDigit(source) << 12 | StringDecoding.readHexDigit(source) << 8 | StringDecoding.readHexDigit(source) << 4 | StringDecoding.readHexDigit(source));
        }

        static int readHexDigit(JsonLexer source) throws IOException {
            int raw = source.readByte();
            int value = IntChar.sHexValues[raw];
            if (value < 0) {
                throw new InvalidJsonException("expected a hex-digit, but found: '" + (char)raw + "'");
            }
            return value;
        }
    }

    static class IntChar {
        public static final int INT_UNINITIALIZED = -2;
        public static final int INT_EOF = -1;
        public static final int INT_TAB = 9;
        public static final int INT_LF = 10;
        public static final int INT_CR = 13;
        public static final int INT_SPACE = 32;
        public static final int INT_LBRACKET = 91;
        public static final int INT_RBRACKET = 93;
        public static final int INT_LCURLY = 123;
        public static final int INT_RCURLY = 125;
        public static final int INT_QUOTE = 34;
        public static final int INT_APOS = 39;
        public static final int INT_BACKSLASH = 92;
        public static final int INT_SLASH = 47;
        public static final int INT_ASTERISK = 42;
        public static final int INT_COLON = 58;
        public static final int INT_COMMA = 44;
        public static final int INT_HASH = 35;
        public static final int INT_0 = 48;
        public static final int INT_9 = 57;
        public static final int INT_MINUS = 45;
        public static final int INT_PLUS = 43;
        public static final int INT_PERIOD = 46;
        public static final int INT_e = 101;
        public static final int INT_E = 69;
        public static final int INT_t = 116;
        public static final int INT_r = 114;
        public static final int INT_u = 117;
        public static final int INT_f = 102;
        public static final int INT_a = 97;
        public static final int INT_l = 108;
        public static final int INT_s = 115;
        public static final int INT_n = 110;
        private static final boolean[] breaks;
        static final int[] sHexValues;
        static final int[] TRUE_VALUE;
        static final int[] FALSE_VALUE;
        static final int[] NULL_VALUE;

        IntChar() {
        }

        public static boolean isDigit(int ch) {
            return ch >= 48 && ch <= 57;
        }

        public static boolean isWhitespace(int ch) {
            return ch == 32 || ch == 10 || ch == 13 || ch == 9;
        }

        public static boolean isBreak(int ch) {
            return breaks[ch];
        }

        static {
            int i;
            breaks = new boolean[127];
            sHexValues = new int[256];
            TRUE_VALUE = new int[]{116, 114, 117, 101};
            FALSE_VALUE = new int[]{102, 97, 108, 115, 101};
            NULL_VALUE = new int[]{110, 117, 108, 108};
            IntChar.breaks[32] = true;
            IntChar.breaks[9] = true;
            IntChar.breaks[10] = true;
            IntChar.breaks[13] = true;
            IntChar.breaks[44] = true;
            IntChar.breaks[125] = true;
            IntChar.breaks[93] = true;
            Arrays.fill(sHexValues, -1);
            for (i = 0; i < 10; ++i) {
                IntChar.sHexValues[48 + i] = i;
            }
            for (i = 0; i < 6; ++i) {
                IntChar.sHexValues[97 + i] = 10 + i;
                IntChar.sHexValues[65 + i] = 10 + i;
            }
        }
    }

    static interface JsonLexer {
        public int readRawByte() throws IOException;

        public int readByte() throws IOException;

        public int readNextToken() throws IOException;
    }
}

