/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import us.hebi.quickbuf.Base64;
import us.hebi.quickbuf.FieldName;
import us.hebi.quickbuf.InvalidJsonException;
import us.hebi.quickbuf.JsonDecoding;
import us.hebi.quickbuf.MessageFactory;
import us.hebi.quickbuf.ProtoEnum;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedBoolean;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.RepeatedBytes;
import us.hebi.quickbuf.RepeatedDouble;
import us.hebi.quickbuf.RepeatedEnum;
import us.hebi.quickbuf.RepeatedFloat;
import us.hebi.quickbuf.RepeatedInt;
import us.hebi.quickbuf.RepeatedLong;
import us.hebi.quickbuf.RepeatedMessage;
import us.hebi.quickbuf.RepeatedString;
import us.hebi.quickbuf.Utf8String;

public abstract class JsonSource
implements Closeable {
    protected boolean ignoreUnknownFields = false;
    CharSequence currentField = null;

    public static JsonSource newInstance(byte[] bytes) {
        return JsonSource.newInstance(bytes, 0, bytes.length);
    }

    public static JsonSource newInstance(byte[] bytes, int offset, int length) {
        return new ArraySource(bytes, offset, length);
    }

    public static JsonSource newInstance(RepeatedByte bytes) {
        return JsonSource.newInstance(bytes.array, 0, bytes.length);
    }

    public static JsonSource newInstance(InputStream inputStream) {
        return new InputStreamSource(inputStream);
    }

    public static JsonSource newInstance(String string) {
        return JsonSource.newInstance(string.getBytes(ProtoUtil.Charsets.UTF_8));
    }

    public <ProtoMsg extends ProtoMessage<ProtoMsg>> ProtoMsg parseMessage(MessageFactory<ProtoMsg> factory) throws IOException {
        return ((ProtoMessage)this.readMessage(factory.create())).checkInitialized();
    }

    public <ProtoMsg extends ProtoMessage<ProtoMsg>> RepeatedMessage<ProtoMsg> parseRepeatedMessage(MessageFactory<ProtoMsg> factory) throws IOException {
        return this.readRepeatedMessage(RepeatedMessage.newEmptyInstance(factory)).checkInitialized();
    }

    public JsonSource setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
        return this;
    }

    public void skipUnknownField() throws IOException {
        if (!this.ignoreUnknownFields) {
            throw new InvalidJsonException("Encountered unknown field: '" + this.currentField + "'");
        }
        this.skipValue();
    }

    public void skipUnknownEnumValue() throws IOException {
        if (!this.ignoreUnknownFields) {
            throw new InvalidJsonException("Encountered unknown enum value on field: '" + this.currentField + "'");
        }
    }

    public abstract double readDouble() throws IOException;

    public abstract int readInt32() throws IOException;

    public abstract long readInt64() throws IOException;

    public abstract boolean readBool() throws IOException;

    public abstract <T extends ProtoEnum<?>> T readEnum(ProtoEnum.EnumConverter<T> var1) throws IOException;

    public abstract void readString(Utf8String var1) throws IOException;

    public abstract void readBytes(RepeatedByte var1) throws IOException;

    public abstract ProtoSource readBytesAsSource() throws IOException;

    public <ProtoMsg extends ProtoMessage<ProtoMsg>> ProtoMsg readMessage(ProtoMsg msg) throws IOException {
        msg.mergeFrom(this);
        return msg;
    }

    protected abstract void skipValue() throws IOException;

    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    public long readUInt64() throws IOException {
        return this.readInt64();
    }

    public long readFixed64() throws IOException {
        return this.readInt64();
    }

    public int readFixed32() throws IOException {
        return this.readInt32();
    }

    public <ProtoMsg extends ProtoMessage<ProtoMsg>> ProtoMsg readGroup(ProtoMsg msg) throws IOException {
        return this.readMessage(msg);
    }

    public int readUInt32() throws IOException {
        return this.readInt32();
    }

    public int readSFixed32() throws IOException {
        return this.readInt32();
    }

    public long readSFixed64() throws IOException {
        return this.readInt64();
    }

    public int readSInt32() throws IOException {
        return this.readInt32();
    }

    public long readSInt64() throws IOException {
        return this.readInt64();
    }

    public void readRepeatedFixed64(RepeatedLong value) throws IOException {
        this.readRepeatedInt64(value);
    }

    public void readRepeatedSFixed64(RepeatedLong value) throws IOException {
        this.readRepeatedInt64(value);
    }

    public void readRepeatedUInt64(RepeatedLong value) throws IOException {
        this.readRepeatedInt64(value);
    }

    public void readRepeatedSInt64(RepeatedLong value) throws IOException {
        this.readRepeatedInt64(value);
    }

    public void readRepeatedFixed32(RepeatedInt value) throws IOException {
        this.readRepeatedInt32(value);
    }

    public void readRepeatedSFixed32(RepeatedInt value) throws IOException {
        this.readRepeatedInt32(value);
    }

    public void readRepeatedUInt32(RepeatedInt value) throws IOException {
        this.readRepeatedInt32(value);
    }

    public void readRepeatedSInt32(RepeatedInt value) throws IOException {
        this.readRepeatedInt32(value);
    }

    public void readRepeatedGroup(RepeatedMessage<?> value) throws IOException {
        this.readRepeatedMessage(value);
    }

    public void readRepeatedDouble(RepeatedDouble value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            value.add(this.readDouble());
        }
        this.endArray();
    }

    public void readRepeatedInt64(RepeatedLong value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            value.add(this.readInt64());
        }
        this.endArray();
    }

    public void readRepeatedFloat(RepeatedFloat value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            value.add(this.readFloat());
        }
        this.endArray();
    }

    public void readRepeatedInt32(RepeatedInt value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            value.add(this.readInt32());
        }
        this.endArray();
    }

    public <ProtoMsg extends ProtoMessage<ProtoMsg>> RepeatedMessage<ProtoMsg> readRepeatedMessage(RepeatedMessage<ProtoMsg> value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            this.readMessage((ProtoMessage)value.next());
        }
        this.endArray();
        return value;
    }

    public void readRepeatedString(RepeatedString value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            this.readString((Utf8String)value.next());
        }
        this.endArray();
    }

    public <E extends ProtoEnum<?>> void readRepeatedEnum(RepeatedEnum<E> value, ProtoEnum.EnumConverter<E> converter) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            E val = this.readEnum(converter);
            value.addValue(val == null ? 0 : val.getNumber());
        }
        this.endArray();
    }

    public void readRepeatedBool(RepeatedBoolean value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            value.add(this.readBool());
        }
        this.endArray();
    }

    public void readRepeatedBytes(RepeatedBytes value) throws IOException {
        this.beginArray();
        while (!this.isAtEnd()) {
            this.readBytes((RepeatedByte)value.next());
        }
        this.endArray();
    }

    public abstract void beginArray() throws IOException;

    public abstract void endArray() throws IOException;

    public abstract boolean beginObject() throws IOException;

    public abstract void endObject() throws IOException;

    public abstract boolean isAtEnd() throws IOException;

    public boolean trySkipNullValue() throws IOException {
        if (this.isAtNull()) {
            this.skipValue();
            return true;
        }
        return false;
    }

    protected abstract boolean isAtNull() throws IOException;

    public final int readFieldHash() throws IOException {
        this.currentField = this.readFieldName();
        return ProtoUtil.hash32(this.currentField);
    }

    public final int readFieldHashOrZero() throws IOException {
        return this.isAtEnd() ? 0 : this.readFieldHash();
    }

    public boolean isAtField(FieldName fieldName) {
        return ProtoUtil.isEqual(fieldName.getJsonName(), this.currentField) || ProtoUtil.isEqual(fieldName.getProtoName(), this.currentField);
    }

    protected abstract CharSequence readFieldName() throws IOException;

    protected static void decodeBase64(String input, RepeatedByte output) {
        output.addAll(Base64.decodeFast(input));
    }

    protected static void decodeBase64(RepeatedByte input, RepeatedByte output) {
        output.addAll(Base64.decode(input.array, 0, input.length));
    }

    static abstract class DefaultJsonSource
    extends JsonSource
    implements JsonDecoding.JsonLexer {
        private int token = -2;
        private final RepeatedByte buffer = RepeatedByte.newEmptyInstance();
        private final StringBuilder key = new StringBuilder(16);
        private final CharSequence bufferViewAscii = new CharSequence(){

            @Override
            public int length() {
                return DefaultJsonSource.this.buffer.length();
            }

            @Override
            public char charAt(int index) {
                return (char)DefaultJsonSource.this.buffer.get(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toString() {
                return new String(((DefaultJsonSource)DefaultJsonSource.this).buffer.array, 0, ((DefaultJsonSource)DefaultJsonSource.this).buffer.length, ProtoUtil.Charsets.ASCII);
            }
        };

        DefaultJsonSource() {
        }

        @Override
        public double readDouble() throws IOException {
            this.getValueAsBytes(this.buffer);
            return JsonDecoding.Numbers.readDouble(this.buffer.array, 0, this.buffer.length);
        }

        @Override
        public int readInt32() throws IOException {
            return (int)this.readInt64();
        }

        @Override
        public long readInt64() throws IOException {
            this.getValueAsBytes(this.buffer);
            return JsonDecoding.Numbers.readLong(this.buffer.array, 0, this.buffer.length);
        }

        @Override
        public boolean readBool() throws IOException {
            if (this.token == 116) {
                this.readExpectedBytes(JsonDecoding.IntChar.TRUE_VALUE);
                this.readNextToken();
                return true;
            }
            if (this.token == 102) {
                this.readExpectedBytes(JsonDecoding.IntChar.FALSE_VALUE);
                this.readNextToken();
                return false;
            }
            throw new InvalidJsonException("Unsupported boolean value");
        }

        @Override
        public <T extends ProtoEnum<?>> T readEnum(ProtoEnum.EnumConverter<T> converter) throws IOException {
            this.getValueAsBytes(this.buffer);
            if (JsonDecoding.Numbers.isInteger(this.buffer.array, 0, this.buffer.length)) {
                return converter.forNumber((int)JsonDecoding.Numbers.readLong(this.buffer.array, 0, this.buffer.length));
            }
            return converter.forName(this.bufferViewAscii);
        }

        @Override
        public void readString(Utf8String store) throws IOException {
            this.checkNotAtNull();
            this.checkCurrentToken(34);
            JsonDecoding.StringDecoding.readQuotedUtf8((JsonDecoding.JsonLexer)this, this.buffer);
            store.copyFromUtf8(this.buffer.array, 0, this.buffer.length);
            this.token = this.readNextToken();
        }

        @Override
        public void readBytes(RepeatedByte store) throws IOException {
            this.getValueAsBytes(this.buffer);
            store.clear();
            DefaultJsonSource.decodeBase64(this.buffer, store);
        }

        @Override
        public ProtoSource readBytesAsSource() throws IOException {
            this.getValueAsBytes(this.buffer);
            return ProtoSource.newInstance(Base64.decode(this.buffer.array, 0, this.buffer.length));
        }

        @Override
        public void skipValue() throws IOException {
            switch (this.token) {
                case 110: {
                    this.readExpectedBytes(JsonDecoding.IntChar.NULL_VALUE);
                    this.token = this.readNextToken();
                    break;
                }
                case 34: {
                    this.skipString();
                    this.token = this.readNextToken();
                    break;
                }
                case 91: {
                    this.skipArray();
                    this.token = this.readNextToken();
                    break;
                }
                case 123: {
                    this.skipObject();
                    this.token = this.readNextToken();
                    break;
                }
                default: {
                    this.token = this.readValueBytes(this.buffer, this.token);
                }
            }
        }

        private void skipArray() throws IOException {
            this.checkCurrentToken(91);
            int level = 1;
            while (level != 0) {
                switch (this.readNextToken()) {
                    case 34: {
                        this.skipString();
                        break;
                    }
                    case 91: {
                        ++level;
                        break;
                    }
                    case 93: {
                        --level;
                    }
                }
            }
        }

        private void skipObject() throws IOException {
            this.checkCurrentToken(123);
            int level = 1;
            while (level != 0) {
                switch (this.readNextToken()) {
                    case 34: {
                        this.readStringBytes(this.buffer);
                        break;
                    }
                    case 123: {
                        ++level;
                        break;
                    }
                    case 125: {
                        --level;
                    }
                }
            }
        }

        @Override
        public boolean beginObject() throws IOException {
            if (this.token == -2) {
                this.token = this.readNextToken();
            }
            this.checkCurrentToken(123);
            this.token = this.readNextToken();
            return true;
        }

        @Override
        public void endObject() throws IOException {
            this.checkCurrentToken(125);
            this.token = this.readNextToken();
        }

        @Override
        public void beginArray() throws IOException {
            if (this.token == -2) {
                this.token = this.readNextToken();
            }
            this.checkCurrentToken(91);
            this.token = this.readNextToken();
        }

        @Override
        public void endArray() throws IOException {
            this.checkCurrentToken(93);
            this.token = this.readNextToken();
        }

        @Override
        public boolean isAtEnd() throws IOException {
            if (this.token == 44) {
                this.token = this.readNextToken();
                return false;
            }
            return this.token == 125 || this.token == 93 || this.token == -1;
        }

        @Override
        protected boolean isAtNull() {
            return this.token == 110;
        }

        @Override
        protected CharSequence readFieldName() throws IOException {
            DefaultJsonSource.checkJson(this.token == 34, "Expected key quotes");
            JsonDecoding.StringDecoding.readQuotedUtf8((JsonDecoding.JsonLexer)this, this.key);
            DefaultJsonSource.checkJson(this.readNextToken() == 58, "Expected colon after key name");
            this.readNextToken();
            return this.key;
        }

        private void getValueAsBytes(RepeatedByte buffer) throws IOException {
            this.checkNotAtNull();
            if (this.token == 34) {
                this.readStringBytes(buffer);
                this.token = this.readNextToken();
            } else {
                this.token = this.readValueBytes(buffer, this.token);
            }
        }

        private int readValueBytes(RepeatedByte buffer, int ch) throws IOException {
            buffer.clear();
            while (!JsonDecoding.IntChar.isBreak(ch)) {
                buffer.add((byte)ch);
                ch = this.readByte();
            }
            if (JsonDecoding.IntChar.isWhitespace(ch)) {
                ch = this.readNextToken();
            }
            this.token = ch;
            return this.token;
        }

        private void readStringBytes(RepeatedByte buffer) throws IOException {
            this.checkNotAtNull();
            buffer.clear();
            int ch = this.readByte();
            while (ch != 34) {
                buffer.add((byte)ch);
                if (ch == 92) {
                    buffer.add((byte)this.readByte());
                }
                ch = this.readByte();
            }
        }

        public void skipString() throws IOException {
            int ch = this.readByte();
            while (ch != 34) {
                if (ch == 92) {
                    this.readByte();
                }
                ch = this.readByte();
            }
        }

        protected static void checkJson(boolean condition, String error) throws InvalidJsonException {
            if (!condition) {
                throw new InvalidJsonException(error);
            }
        }

        protected void checkNotAtNull() throws InvalidJsonException {
            if (this.isAtNull()) {
                String atField = this.currentField == null ? "" : " for field '" + this.currentField + "'";
                throw new InvalidJsonException("Expected non-null value" + atField);
            }
        }

        protected void checkExpected(boolean condition, String expected, String actual) throws InvalidJsonException {
            if (!condition) {
                String atField = this.currentField == null ? "" : " for field '" + this.currentField + "'";
                throw new InvalidJsonException("Expected '" + expected + "' but got '" + actual + "'" + atField);
            }
        }

        protected void checkCurrentToken(int expectedToken) throws InvalidJsonException {
            if (expectedToken != this.token) {
                String atField = this.currentField == null ? "" : " for field '" + this.currentField + "'";
                throw new InvalidJsonException("Expected '" + (char)expectedToken + "' but got '" + (char)this.token + "'" + atField);
            }
        }

        protected void readExpectedBytes(int[] expected) throws IOException {
            for (int i = 1; i < expected.length; ++i) {
                int ch = this.readByte();
                if (expected[i] == ch) continue;
                int[] actual = Arrays.copyOfRange(expected, 0, i + 1);
                actual[i] = ch;
                this.checkExpected(false, this.toCharString(expected), this.toCharString(actual));
            }
        }

        private String toCharString(int ... bytes) {
            StringBuilder chars = new StringBuilder(bytes.length);
            for (int b : bytes) {
                chars.append((char)b);
            }
            return chars.toString();
        }

        @Override
        public int readByte() throws IOException {
            int value = this.readRawByte();
            if (value == -1) {
                throw InvalidJsonException.truncatedMessage();
            }
            return value;
        }

        @Override
        public int readNextToken() throws IOException {
            int ch = this.readRawByte();
            while (JsonDecoding.IntChar.isWhitespace(ch)) {
                ch = this.readRawByte();
            }
            this.token = ch;
            return this.token;
        }
    }

    static class InputStreamSource
    extends DefaultJsonSource {
        final InputStream inputStream;

        InputStreamSource(InputStream inputStream) {
            this.inputStream = ProtoUtil.checkNotNull(inputStream);
        }

        @Override
        public int readRawByte() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }

    static class ArraySource
    extends DefaultJsonSource {
        int position = 0;
        final int limit;
        final byte[] bytes;

        ArraySource(byte[] bytes, int offset, int length) {
            ProtoUtil.checkBounds(bytes, offset, length);
            this.bytes = bytes;
            this.position = offset;
            this.limit = offset + length;
        }

        @Override
        public int readRawByte() {
            if (this.position == this.limit) {
                return -1;
            }
            return this.bytes[this.position++] & 0xFF;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

