/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import us.hebi.quickbuf.ArraySink;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedBoolean;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.RepeatedBytes;
import us.hebi.quickbuf.RepeatedDouble;
import us.hebi.quickbuf.RepeatedEnum;
import us.hebi.quickbuf.RepeatedFloat;
import us.hebi.quickbuf.RepeatedInt;
import us.hebi.quickbuf.RepeatedLong;
import us.hebi.quickbuf.RepeatedMessage;
import us.hebi.quickbuf.RepeatedString;
import us.hebi.quickbuf.UnsafeAccess;
import us.hebi.quickbuf.Utf8;
import us.hebi.quickbuf.Utf8String;
import us.hebi.quickbuf.WireFormat;

public abstract class ProtoSink {
    protected ProtoSink() {
    }

    public static ProtoSink newInstance(byte[] flatArray) {
        return ProtoSink.newArraySink().setOutput(flatArray);
    }

    public static ProtoSink newInstance(byte[] flatArray, int offset, int length) {
        return ProtoSink.newArraySink().setOutput(flatArray, offset, length);
    }

    public static ProtoSink newInstance(RepeatedByte bytes) {
        return ProtoSink.newBytesSink().setOutput(bytes);
    }

    public static ProtoSink newInstance(OutputStream stream) {
        return ProtoSink.newStreamSink().setOutput(stream);
    }

    public static ProtoSink newInstance(ByteBuffer buffer) {
        return ProtoSink.newBufferSink().setOutput(buffer);
    }

    public static ProtoSink newArraySink() {
        return new ArraySink();
    }

    public static ProtoSink newDirectSink() {
        return new ArraySink.DirectArraySink();
    }

    public static ProtoSink newBytesSink() {
        return new ArraySink.RepeatedByteSink();
    }

    public static ProtoSink newStreamSink() {
        return new StreamSink();
    }

    public static ProtoSink newBufferSink() {
        return new BufferSink();
    }

    public final ProtoSink setOutput(byte[] buffer) {
        return this.setOutput(buffer, 0L, buffer.length);
    }

    public ProtoSink setOutput(byte[] buffer, long offset, int length) {
        throw new UnsupportedOperationException("sink does not support writing to a byte array");
    }

    public ProtoSink setOutput(RepeatedByte bytes) {
        throw new UnsupportedOperationException("sink does not support writing to RepeatedByte");
    }

    public ProtoSink setOutput(OutputStream stream) {
        throw new UnsupportedOperationException("sink does not support writing to an InputStream");
    }

    public ProtoSink setOutput(ByteBuffer buffer) {
        throw new UnsupportedOperationException("sink does not support writing to a ByteBuffer");
    }

    public abstract ProtoSink clear();

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, wireType));
    }

    public void writePackedTag(int fieldNumber) throws IOException {
        this.writeUInt32NoTag(WireFormat.makeTag(fieldNumber, 2));
    }

    public void writeDouble(int fieldNumber, double value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeDoubleNoTag(value);
    }

    public void writeFloat(int fieldNumber, float value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFloatNoTag(value);
    }

    public void writeUInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt64NoTag(value);
    }

    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeBoolNoTag(value);
    }

    public void writeString(int fieldNumber, CharSequence value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    public void writeGroup(int fieldNumber, ProtoMessage value) throws IOException {
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag(value);
        this.writeTag(fieldNumber, 4);
    }

    public void writeMessage(int fieldNumber, ProtoMessage value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeMessageNoTag(value);
    }

    public void writeBytes(int fieldNumber, RepeatedByte value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeEnum(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeEnumNoTag(value);
    }

    public void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 5);
        this.writeSFixed32NoTag(value);
    }

    public void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeSFixed64NoTag(value);
    }

    public void writeSInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt32NoTag(value);
    }

    public void writeSInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeSInt64NoTag(value);
    }

    public void writePackedDoubleNoTag(RepeatedDouble values) throws IOException {
        this.writeLength(values.length * 8);
        this.writeRawDoubles(values.array, values.length);
    }

    public void writePackedFloatNoTag(RepeatedFloat values) throws IOException {
        this.writeLength(values.length * 4);
        this.writeRawFloats(values.array, values.length);
    }

    public void writePackedFixed64NoTag(RepeatedLong values) throws IOException {
        this.writeLength(values.length * 8);
        this.writeRawFixed64s(values.array, values.length);
    }

    public void writePackedFixed32NoTag(RepeatedInt values) throws IOException {
        this.writeLength(values.length * 4);
        this.writeRawFixed32s(values.array, values.length);
    }

    public void writePackedSFixed32NoTag(RepeatedInt values) throws IOException {
        this.writeLength(values.length * 4);
        this.writeRawFixed32s(values.array, values.length);
    }

    public void writePackedSFixed64NoTag(RepeatedLong values) throws IOException {
        this.writeLength(values.length * 8);
        this.writeRawFixed64s(values.array, values.length);
    }

    public void writePackedBoolNoTag(RepeatedBoolean values) throws IOException {
        this.writeLength(values.length * 1);
        this.writeRawBooleans(values.array, values.length);
    }

    protected void writeRawDoubles(double[] values, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeRawLittleEndian64(Double.doubleToLongBits(values[i]));
        }
    }

    protected void writeRawFloats(float[] values, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeRawLittleEndian32(Float.floatToIntBits(values[i]));
        }
    }

    protected void writeRawFixed64s(long[] values, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeRawLittleEndian64(values[i]);
        }
    }

    protected void writeRawFixed32s(int[] values, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeRawLittleEndian32(values[i]);
        }
    }

    protected void writeRawBooleans(boolean[] values, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeRawByte(values[i] ? 1 : 0);
        }
    }

    public static int computeRepeatedEnumSizeNoTag(RepeatedEnum<?> values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeEnumSizeNoTag(values.array()[i]);
        }
        return dataSize;
    }

    public void writePackedEnumNoTag(RepeatedEnum<?> values) throws IOException {
        this.writeLength(ProtoSink.computeRepeatedEnumSizeNoTag(values));
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            this.writeEnumNoTag(values.array()[i]);
        }
    }

    public static int computeRepeatedInt32SizeNoTag(RepeatedInt values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeInt32SizeNoTag(values.array()[i]);
        }
        return dataSize;
    }

    public void writePackedInt32NoTag(RepeatedInt values) throws IOException {
        this.writeLength(ProtoSink.computeRepeatedInt32SizeNoTag(values));
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            this.writeInt32NoTag(values.array()[i]);
        }
    }

    public static int computeRepeatedUInt32SizeNoTag(RepeatedInt values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeUInt32SizeNoTag(values.array()[i]);
        }
        return dataSize;
    }

    public void writePackedUInt32NoTag(RepeatedInt values) throws IOException {
        this.writeLength(ProtoSink.computeRepeatedUInt32SizeNoTag(values));
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            this.writeUInt32NoTag(values.array()[i]);
        }
    }

    public static int computeRepeatedSInt32SizeNoTag(RepeatedInt values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeSInt32SizeNoTag(values.array()[i]);
        }
        return dataSize;
    }

    public void writePackedSInt32NoTag(RepeatedInt values) throws IOException {
        this.writeLength(ProtoSink.computeRepeatedSInt32SizeNoTag(values));
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            this.writeSInt32NoTag(values.array()[i]);
        }
    }

    public static int computeRepeatedInt64SizeNoTag(RepeatedLong values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeInt64SizeNoTag(values.array()[i]);
        }
        return dataSize;
    }

    public void writePackedInt64NoTag(RepeatedLong values) throws IOException {
        this.writeLength(ProtoSink.computeRepeatedInt64SizeNoTag(values));
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            this.writeInt64NoTag(values.array()[i]);
        }
    }

    public static int computeRepeatedUInt64SizeNoTag(RepeatedLong values) {
        return ProtoSink.computeRepeatedInt64SizeNoTag(values);
    }

    public void writePackedUInt64NoTag(RepeatedLong values) throws IOException {
        this.writePackedInt64NoTag(values);
    }

    public static int computeRepeatedSInt64SizeNoTag(RepeatedLong values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeSInt64SizeNoTag(values.array()[i]);
        }
        return dataSize;
    }

    public void writePackedSInt64NoTag(RepeatedLong values) throws IOException {
        this.writeLength(ProtoSink.computeRepeatedSInt64SizeNoTag(values));
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            this.writeSInt64NoTag(values.array()[i]);
        }
    }

    public static int computeRepeatedMessageSizeNoTag(RepeatedMessage<?> values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeMessageSizeNoTag(((ProtoMessage[])values.array)[i]);
        }
        return dataSize;
    }

    public static int computeRepeatedGroupSizeNoTag(RepeatedMessage<?> values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeGroupSizeNoTag(((ProtoMessage[])values.array)[i]);
        }
        return dataSize;
    }

    public static int computeRepeatedStringSizeNoTag(RepeatedString values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeStringSizeNoTag(((Utf8String[])values.array)[i]);
        }
        return dataSize;
    }

    public static int computeRepeatedBytesSizeNoTag(RepeatedBytes values) {
        int dataSize = 0;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            dataSize += ProtoSink.computeBytesSizeNoTag(((RepeatedByte[])values.array)[i]);
        }
        return dataSize;
    }

    public void writeLength(int length) throws IOException {
        this.writeUInt32NoTag(length);
    }

    public void writeDoubleNoTag(double value) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToLongBits(value));
    }

    public void writeFloatNoTag(float value) throws IOException {
        this.writeRawLittleEndian32(Float.floatToIntBits(value));
    }

    public void writeInt64NoTag(long value) throws IOException {
        if (value >= 0L) {
            this.writeUInt64NoTag(value);
        } else {
            this.writeNegativeVarint64(value);
        }
    }

    public void writeInt32NoTag(int value) throws IOException {
        if (value >= 0) {
            this.writeUInt32NoTag(value);
        } else {
            this.writeNegativeVarint32(value);
        }
    }

    public void writeFixed64NoTag(long value) throws IOException {
        this.writeRawLittleEndian64(value);
    }

    public void writeFixed32NoTag(int value) throws IOException {
        this.writeRawLittleEndian32(value);
    }

    public void writeBoolNoTag(boolean value) throws IOException {
        this.writeRawByte((byte)(value ? 1 : 0));
    }

    public void writeStringNoTag(Utf8String value) throws IOException {
        int length = value.size();
        this.writeLength(length);
        this.writeRawBytes(value.bytes(), 0, length);
    }

    public void writeStringNoTag(CharSequence value) throws IOException {
        this.writeLength(Utf8.encodedLength(value));
        Utf8.encodeSink(value, this);
    }

    public void writeGroupNoTag(ProtoMessage<?> value) throws IOException {
        value.writeTo(this);
    }

    public void writeMessageNoTag(ProtoMessage<?> value) throws IOException {
        this.writeLength(value.getCachedSize());
        value.writeTo(this);
    }

    public void writeBytesNoTag(RepeatedByte value) throws IOException {
        this.writeLength(value.length);
        this.writeRawBytes(value.array, 0, value.length);
    }

    public void writeEnumNoTag(int value) throws IOException {
        this.writeInt32NoTag(value);
    }

    public void writeSFixed32NoTag(int value) throws IOException {
        this.writeRawLittleEndian32(value);
    }

    public void writeSFixed64NoTag(long value) throws IOException {
        this.writeRawLittleEndian64(value);
    }

    public void writeSInt32NoTag(int value) throws IOException {
        this.writeUInt32NoTag(ProtoSink.encodeZigZag32(value));
    }

    public void writeSInt64NoTag(long value) throws IOException {
        this.writeUInt64NoTag(ProtoSink.encodeZigZag64(value));
    }

    public static int computeDoubleSize(int fieldNumber, double value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeDoubleSizeNoTag(value);
    }

    public static int computeFloatSize(int fieldNumber, float value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeFloatSizeNoTag(value);
    }

    public static int computeUInt64Size(int fieldNumber, long value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeUInt64SizeNoTag(value);
    }

    public static int computeInt64Size(int fieldNumber, long value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeInt64SizeNoTag(value);
    }

    public static int computeInt32Size(int fieldNumber, int value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeInt32SizeNoTag(value);
    }

    public static int computeFixed64Size(int fieldNumber, long value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeFixed64SizeNoTag(value);
    }

    public static int computeFixed32Size(int fieldNumber, int value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeFixed32SizeNoTag(value);
    }

    public static int computeBoolSize(int fieldNumber, boolean value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeBoolSizeNoTag(value);
    }

    public static int computeStringSize(int fieldNumber, CharSequence value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeStringSizeNoTag(value);
    }

    public static int computeGroupSize(int fieldNumber, ProtoMessage<?> value) {
        return ProtoSink.computeTagSize(fieldNumber) * 2 + ProtoSink.computeGroupSizeNoTag(value);
    }

    public static int computeMessageSize(int fieldNumber, ProtoMessage<?> value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeMessageSizeNoTag(value);
    }

    public static int computeBytesSize(int fieldNumber, RepeatedByte value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeBytesSizeNoTag(value);
    }

    public static int computeUInt32Size(int fieldNumber, int value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeUInt32SizeNoTag(value);
    }

    public static int computeEnumSize(int fieldNumber, int value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeEnumSizeNoTag(value);
    }

    public static int computeSFixed32Size(int fieldNumber, int value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeSFixed32SizeNoTag(value);
    }

    public static int computeSFixed64Size(int fieldNumber, long value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeSFixed64SizeNoTag(value);
    }

    public static int computeSInt32Size(int fieldNumber, int value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeSInt32SizeNoTag(value);
    }

    public static int computeSInt64Size(int fieldNumber, long value) {
        return ProtoSink.computeTagSize(fieldNumber) + ProtoSink.computeSInt64SizeNoTag(value);
    }

    public static int computeDoubleSizeNoTag(double value) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float value) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long value) {
        return ProtoSink.computeRawVarint64Size(value);
    }

    public static int computeInt64SizeNoTag(long value) {
        return ProtoSink.computeRawVarint64Size(value);
    }

    public static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            return ProtoSink.computeRawVarint32Size(value);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean value) {
        return 1;
    }

    public static int computeStringSizeNoTag(Utf8String value) {
        int length = value.size();
        return ProtoSink.computeRawVarint32Size(length) + length;
    }

    public static int computeStringSizeNoTag(CharSequence value) {
        int length = Utf8.encodedLength(value);
        return ProtoSink.computeRawVarint32Size(length) + length;
    }

    public static int computeGroupSizeNoTag(ProtoMessage value) {
        return value.getSerializedSize();
    }

    public static int computeMessageSizeNoTag(ProtoMessage value) {
        int size = value.getSerializedSize();
        return ProtoSink.computeRawVarint32Size(size) + size;
    }

    public static int computeBytesSizeNoTag(RepeatedByte value) {
        return ProtoSink.computeRawVarint32Size(value.length) + value.length;
    }

    public static int computeUInt32SizeNoTag(int value) {
        return ProtoSink.computeRawVarint32Size(value);
    }

    public static int computeEnumSizeNoTag(int value) {
        return ProtoSink.computeInt32SizeNoTag(value);
    }

    public static int computeSFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return ProtoSink.computeRawVarint32Size(ProtoSink.encodeZigZag32(value));
    }

    public static int computeSInt64SizeNoTag(long value) {
        return ProtoSink.computeRawVarint64Size(ProtoSink.encodeZigZag64(value));
    }

    public static int computeDelimitedSize(int length) {
        return ProtoSink.computeRawVarint32Size(length) + length;
    }

    public int spaceLeft() {
        throw new UnsupportedOperationException("The space limit for this sink is unknown");
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected. Remaining bytes: " + this.spaceLeft());
        }
    }

    public abstract int getTotalBytesWritten();

    public abstract ProtoSink reset();

    public abstract void writeRawByte(byte var1) throws IOException;

    public void writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
    }

    public void writeRawBytes(byte[] value) throws IOException {
        this.writeRawBytes(value, 0, value.length);
    }

    public void writeRawBytes(RepeatedByte bytes) throws IOException {
        this.writeRawBytes(bytes.array(), 0, bytes.length());
    }

    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            this.writeRawByte(value[i]);
        }
    }

    public static int computeTagSize(int fieldNumber) {
        return ProtoSink.computeRawVarint32Size(WireFormat.makeTag(fieldNumber, 0));
    }

    public void writeUInt32NoTag(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte((byte)value);
                return;
            }
            this.writeRawByte((byte)(value | 0x80));
            value >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeUInt64NoTag(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((byte)value);
                return;
            }
            this.writeRawByte((byte)((int)value | 0x80));
            value >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value) {
        return Varint64.sizeOf(value);
    }

    protected void writeNegativeVarint32(int value) throws IOException {
        if (UnsafeAccess.allowUnalignedAccess()) {
            long first8 = 0xFFFFFFF080808080L | (long)value & 0x7FL | ((long)value & 0x3F80L) << 1 | ((long)value & 0x1FC000L) << 2 | ((long)value & 0xFE00000L) << 3 | ((long)value & 0xF0000000L) << 4;
            this.writeRawLittleEndian64(first8);
            this.writeRawLittleEndian16((short)511);
        } else {
            this.writeRawByte((byte)(value | 0x80));
            this.writeRawByte((byte)(value >>> 7 | 0x80));
            this.writeRawByte((byte)(value >>> 14 | 0x80));
            this.writeRawByte((byte)(value >>> 21 | 0x80));
            this.writeRawByte((byte)(value >>> 28 | 0x80));
            this.writeRawByte((byte)-1);
            this.writeRawByte((byte)-1);
            this.writeRawByte((byte)-1);
            this.writeRawByte((byte)-1);
            this.writeRawByte((byte)1);
        }
    }

    protected void writeNegativeVarint64(long value) throws IOException {
        if (UnsafeAccess.allowUnalignedAccess()) {
            long first8 = 0x8080808080808080L | value & 0x7FL | (value & 0x3F80L) << 1 | (value & 0x1FC000L) << 2 | (value & 0xFE00000L) << 3 | (value & 0x7F0000000L) << 4 | (value & 0x3F800000000L) << 5 | (value & 0x1FC0000000000L) << 6 | (value & 0xFE000000000000L) << 7;
            long last2 = 0x80L | (value & 0x7F00000000000000L) >>> 56 | (value & Long.MIN_VALUE) >>> 55;
            this.writeRawLittleEndian64(first8);
            this.writeRawLittleEndian16((short)last2);
        } else {
            this.writeRawByte((int)value | 0x80);
            this.writeRawByte((int)(value >>> 7) | 0x80);
            this.writeRawByte((int)(value >>> 14) | 0x80);
            this.writeRawByte((int)(value >>> 21) | 0x80);
            this.writeRawByte((int)(value >>> 28) | 0x80);
            this.writeRawByte((int)(value >>> 35) | 0x80);
            this.writeRawByte((int)(value >>> 42) | 0x80);
            this.writeRawByte((int)(value >>> 49) | 0x80);
            this.writeRawByte((int)(value >>> 56) | 0x80);
            this.writeRawByte((byte)(value >>> 63));
        }
    }

    public void writeRawLittleEndian16(short value) throws IOException {
        this.writeRawByte((byte)(value & 0xFF));
        this.writeRawByte((byte)(value >>> 8));
    }

    public void writeRawLittleEndian32(int value) throws IOException {
        this.writeRawByte((byte)(value & 0xFF));
        this.writeRawByte((byte)(value >>> 8));
        this.writeRawByte((byte)(value >>> 16));
        this.writeRawByte((byte)(value >>> 24));
    }

    public void writeRawLittleEndian64(long value) throws IOException {
        this.writeRawByte((byte)(value & 0xFFL));
        this.writeRawByte((byte)(value >>> 8));
        this.writeRawByte((byte)(value >>> 16));
        this.writeRawByte((byte)(value >>> 24));
        this.writeRawByte((byte)(value >>> 32));
        this.writeRawByte((byte)(value >>> 40));
        this.writeRawByte((byte)(value >>> 48));
        this.writeRawByte((byte)(value >>> 56));
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    @Deprecated
    public void writeRawVarint32(int value) throws IOException {
        this.writeUInt32NoTag(value);
    }

    @Deprecated
    public void writeRawVarint64(long value) throws IOException {
        this.writeUInt64NoTag(value);
    }

    public static int writeUInt32(OutputStream output, int value) throws IOException {
        int numBytes = 1;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                output.write(value);
                return numBytes;
            }
            output.write(value & 0x7F | 0x80);
            value >>>= 7;
            ++numBytes;
        }
    }

    static class BufferSink
    extends ProtoSink {
        ByteBuffer buffer = ProtoUtil.EMPTY_BYTE_BUFFER;
        int initialPosition = 0;

        BufferSink() {
        }

        @Override
        public ProtoSink setOutput(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
            this.initialPosition = this.buffer.position();
            return this;
        }

        @Override
        public ProtoSink clear() {
            return this.setOutput(ProtoUtil.EMPTY_BYTE_BUFFER);
        }

        @Override
        public int spaceLeft() {
            return this.buffer.remaining();
        }

        @Override
        public int getTotalBytesWritten() {
            return this.buffer.position() - this.initialPosition;
        }

        @Override
        public ProtoSink reset() {
            this.buffer.position(this.initialPosition);
            return this;
        }

        @Override
        public void writeRawByte(byte value) throws IOException {
            try {
                this.buffer.put(value);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }

        @Override
        public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
            try {
                this.buffer.put(value, offset, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new OutOfSpaceException(e);
            }
            catch (BufferOverflowException e) {
                throw new OutOfSpaceException(e);
            }
        }
    }

    static class StreamSink
    extends ProtoSink {
        OutputStream stream = EMPTY_OUTPUT_STREAM;
        int position = 0;
        private static final OutputStream EMPTY_OUTPUT_STREAM = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };

        StreamSink() {
        }

        @Override
        public ProtoSink setOutput(OutputStream outputStream) {
            if (outputStream == null) {
                throw new NullPointerException();
            }
            this.stream = outputStream;
            return this;
        }

        @Override
        public ProtoSink clear() {
            return this.setOutput(EMPTY_OUTPUT_STREAM);
        }

        @Override
        public int getTotalBytesWritten() {
            return this.position;
        }

        @Override
        public ProtoSink reset() {
            this.position = 0;
            return this;
        }

        @Override
        public void writeRawByte(byte value) throws IOException {
            this.stream.write(value);
            ++this.position;
        }

        @Override
        public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
            this.stream.write(value, offset, length);
            this.position += length;
        }
    }

    static class Varint64 {
        static final int[] SIZE = new int[65];

        Varint64() {
        }

        static int sizeOf(long value) {
            return SIZE[Long.numberOfLeadingZeros(value)];
        }

        static {
            for (int i = 0; i <= 64; ++i) {
                Varint64.SIZE[i] = 1 + (63 - i) / 7;
            }
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = 0L;
        private static final String MESSAGE = "ProtoSink was writing and ran out of space";

        OutOfSpaceException(int position, int limit) {
            super("ProtoSink was writing and ran out of space: (pos " + position + " limit " + limit + ").");
        }

        OutOfSpaceException(Throwable cause) {
            super(MESSAGE, cause);
        }
    }
}

