/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import us.hebi.quickbuf.ArraySource;
import us.hebi.quickbuf.ByteUtil;
import us.hebi.quickbuf.InvalidProtocolBufferException;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedBoolean;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.RepeatedBytes;
import us.hebi.quickbuf.RepeatedDouble;
import us.hebi.quickbuf.RepeatedEnum;
import us.hebi.quickbuf.RepeatedField;
import us.hebi.quickbuf.RepeatedFloat;
import us.hebi.quickbuf.RepeatedInt;
import us.hebi.quickbuf.RepeatedLong;
import us.hebi.quickbuf.RepeatedMessage;
import us.hebi.quickbuf.RepeatedString;
import us.hebi.quickbuf.Utf8String;
import us.hebi.quickbuf.WireFormat;

public abstract class ProtoSource {
    private static final int xorBits7 = -128;
    private static final int xorBits14 = 16256;
    private static final int xorBits21 = -2080896;
    private static final int xorBits28 = 266354560;
    private static final long xorBits28L = 266354560L;
    private static final long xorBits35L = -34093383808L;
    private static final long xorBits42L = 4363953127296L;
    private static final long xorBits49L = -558586000294016L;
    private static final long xorBits56L = 71499008037633920L;
    private int lastTag;
    protected int recursionDepth;
    protected int recursionLimit = 64;
    private static final int DEFAULT_RECURSION_LIMIT = 64;
    protected int currentLimit = Integer.MAX_VALUE;
    protected static final int NO_LIMIT = Integer.MAX_VALUE;
    private boolean shouldDiscardUnknownFields = false;

    public static ProtoSource newInstance(byte[] buf) {
        return ProtoSource.newInstance(buf, 0, buf.length);
    }

    public static ProtoSource newInstance(byte[] buf, int off, int len) {
        return ProtoSource.newArraySource().setInput(buf, off, len);
    }

    public static ProtoSource newInstance(RepeatedByte bytes) {
        return ProtoSource.newArraySource().setInput(bytes);
    }

    public static ProtoSource newInstance(InputStream stream) {
        return ProtoSource.newStreamSource().setInput(stream);
    }

    public static ProtoSource newInstance(ByteBuffer buffer) {
        return ProtoSource.newBufferSource().setInput(buffer);
    }

    public static ProtoSource newArraySource() {
        return new ArraySource();
    }

    public static ProtoSource newDirectSource() {
        return new ArraySource.DirectArraySource();
    }

    public static ProtoSource newStreamSource() {
        return new StreamSource();
    }

    public static ProtoSource newBufferSource() {
        return new BufferSource();
    }

    public final ProtoSource setInput(byte[] buffer) {
        return this.setInput(buffer, 0L, buffer.length);
    }

    public ProtoSource setInput(byte[] buffer, long off, int len) {
        throw new UnsupportedOperationException("source does not support reading from a byte array");
    }

    public final ProtoSource setInput(RepeatedByte bytes) {
        return this.setInput(bytes.array(), 0L, bytes.length());
    }

    public ProtoSource setInput(InputStream stream) {
        throw new UnsupportedOperationException("source does not support reading from an InputStream");
    }

    public ProtoSource setInput(ByteBuffer buffer) {
        throw new UnsupportedOperationException("source does not support reading from a ByteBuffer");
    }

    public abstract ProtoSource clear();

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int value) throws InvalidProtocolBufferException {
        if (this.lastTag != value) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.readRawVarint32();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readLength());
                return true;
            }
            case 3: {
                this.skipMessage();
                int endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                this.checkLastTagWas(endGroupTag);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public boolean skipField(int tag, RepeatedByte unknownBytes) throws IOException {
        if (this.shouldDiscardUnknownFields) {
            return this.skipField(tag);
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                long value = this.readRawVarint64();
                ByteUtil.writeUInt32(unknownBytes, tag);
                ByteUtil.writeVarint64(unknownBytes, value);
                return true;
            }
            case 1: {
                ByteUtil.writeUInt32(unknownBytes, tag);
                ByteUtil.writeBytes(unknownBytes, 8, this);
                return true;
            }
            case 2: {
                int length = this.readLength();
                ByteUtil.writeUInt32(unknownBytes, tag);
                ByteUtil.writeUInt32(unknownBytes, length);
                ByteUtil.writeBytes(unknownBytes, length, this);
                return true;
            }
            case 3: {
                int endTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                ByteUtil.writeUInt32(unknownBytes, tag);
                this.skipMessage(unknownBytes);
                this.checkLastTagWas(endTag);
                ByteUtil.writeUInt32(unknownBytes, endTag);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                ByteUtil.writeUInt32(unknownBytes, tag);
                ByteUtil.writeBytes(unknownBytes, 4, this);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public void skipEnum(int tag, int value, RepeatedByte unknownBytes) throws IOException {
        if (!this.shouldDiscardUnknownFields) {
            ByteUtil.writeUInt32(unknownBytes, tag);
            ByteUtil.writeUInt32(unknownBytes, value);
        }
    }

    protected void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    protected void skipMessage(RepeatedByte unknownBytes) throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag, unknownBytes)) {
        }
    }

    public void readPackedDouble(RepeatedDouble store) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        int count = WireFormat.roundedCount64(length);
        int offset = store.addLength(count);
        this.readRawDoubles(store.array, offset, count);
        this.popLimit(limit);
    }

    protected void readRawDoubles(double[] values, int offset, int length) throws IOException {
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            values[i] = this.readDouble();
        }
    }

    public int readRepeatedDouble(RepeatedDouble store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readDouble());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public void readPackedFloat(RepeatedFloat store) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        int count = WireFormat.roundedCount32(length);
        int offset = store.addLength(count);
        this.readRawFloats(store.array, offset, count);
        this.popLimit(limit);
    }

    protected void readRawFloats(float[] values, int offset, int length) throws IOException {
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            values[i] = this.readFloat();
        }
    }

    public int readRepeatedFloat(RepeatedFloat store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readFloat());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public void readPackedSFixed64(RepeatedLong store) throws IOException {
        this.readPackedFixed64(store);
    }

    public void readPackedFixed64(RepeatedLong store) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        int count = WireFormat.roundedCount64(length);
        int offset = store.addLength(count);
        this.readRawFixed64s(store.array, offset, count);
        this.popLimit(limit);
    }

    protected void readRawFixed64s(long[] values, int offset, int length) throws IOException {
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            values[i] = this.readRawLittleEndian64();
        }
    }

    public int readRepeatedSFixed64(RepeatedLong store, int tag) throws IOException {
        return this.readRepeatedFixed64(store, tag);
    }

    public int readRepeatedFixed64(RepeatedLong store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readFixed64());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public void readPackedSFixed32(RepeatedInt store) throws IOException {
        this.readPackedFixed32(store);
    }

    public void readPackedFixed32(RepeatedInt store) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        int count = WireFormat.roundedCount32(length);
        int offset = store.addLength(count);
        this.readRawFixed32s(store.array, offset, count);
        this.popLimit(limit);
    }

    protected void readRawFixed32s(int[] values, int offset, int length) throws IOException {
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            values[i] = this.readRawLittleEndian32();
        }
    }

    public int readRepeatedSFixed32(RepeatedInt store, int tag) throws IOException {
        return this.readRepeatedFixed32(store, tag);
    }

    public int readRepeatedFixed32(RepeatedInt store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readFixed32());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public void readPackedUInt64(RepeatedLong store, int tag) throws IOException {
        this.readPackedInt64(store, tag);
    }

    public void readPackedInt64(RepeatedLong store, int tag) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        while (!this.isAtEnd()) {
            this.reservePackedVarintCapacity(store);
            store.add(this.readInt64());
        }
        this.popLimit(limit);
    }

    public void readPackedSInt64(RepeatedLong store, int tag) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        while (!this.isAtEnd()) {
            this.reservePackedVarintCapacity(store);
            store.add(this.readSInt64());
        }
        this.popLimit(limit);
    }

    public int readRepeatedUInt64(RepeatedLong store, int tag) throws IOException {
        return this.readRepeatedInt64(store, tag);
    }

    public int readRepeatedInt64(RepeatedLong store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readInt64());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public int readRepeatedSInt64(RepeatedLong store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readSInt64());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readSInt64() throws IOException {
        return ProtoSource.decodeZigZag64(this.readRawVarint64());
    }

    public void readPackedUInt32(RepeatedInt store, int tag) throws IOException {
        this.readPackedInt32(store, tag);
    }

    public void readPackedInt32(RepeatedInt store, int tag) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        while (!this.isAtEnd()) {
            this.reservePackedVarintCapacity(store);
            store.add(this.readInt32());
        }
        this.popLimit(limit);
    }

    public void readPackedSInt32(RepeatedInt store, int tag) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        while (!this.isAtEnd()) {
            this.reservePackedVarintCapacity(store);
            store.add(this.readSInt32());
        }
        this.popLimit(limit);
    }

    public int readRepeatedUInt32(RepeatedInt store, int tag) throws IOException {
        return this.readRepeatedInt32(store, tag);
    }

    public int readRepeatedInt32(RepeatedInt store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readInt32());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public int readRepeatedSInt32(RepeatedInt store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readSInt32());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readSInt32() throws IOException {
        return ProtoSource.decodeZigZag32(this.readRawVarint32());
    }

    public void readPackedBool(RepeatedBoolean store) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        store.reserve(length / 1);
        while (!this.isAtEnd()) {
            store.add(this.readBool());
        }
        this.popLimit(limit);
    }

    public int readRepeatedBool(RepeatedBoolean store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.add(this.readBool());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint64() != 0L;
    }

    public void readPackedEnum(RepeatedEnum<?> store, int tag) throws IOException {
        int length = this.readLength();
        int limit = this.pushLimit(length);
        while (!this.isAtEnd()) {
            this.reservePackedVarintCapacity(store);
            store.addValue(this.readEnum());
        }
        this.popLimit(limit);
    }

    public int readRepeatedEnum(RepeatedEnum<?> store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            store.addValue(this.readEnum());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readLength() throws IOException {
        return this.readRawVarint32();
    }

    public int readRepeatedString(RepeatedString store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            this.readString((Utf8String)store.next());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public void readString(Utf8String store) throws IOException {
        int length = this.readLength();
        store.setSize(length);
        this.readRawBytes(store.bytes(), 0, length);
    }

    public int readRepeatedGroup(RepeatedMessage<?> store, int tag) throws IOException {
        int nextTag;
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            this.readGroup((ProtoMessage)store.next(), fieldNumber);
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public void readGroup(ProtoMessage<?> msg, int fieldNumber) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        msg.mergeFrom(this);
        this.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
        --this.recursionDepth;
    }

    public int readRepeatedMessage(RepeatedMessage<?> store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            this.readMessage((ProtoMessage)store.next());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public void readMessage(ProtoMessage<?> msg) throws IOException {
        int length = this.readLength();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int oldLimit = this.pushLimit(length);
        ++this.recursionDepth;
        msg.mergeFrom(this);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(oldLimit);
    }

    public int readRepeatedBytes(RepeatedBytes store, int tag) throws IOException {
        int nextTag;
        do {
            this.reserveRepeatedFieldCapacity(store, tag);
            this.readBytes((RepeatedByte)store.next());
        } while ((nextTag = this.readTag()) == tag);
        return nextTag;
    }

    public void readBytes(RepeatedByte store) throws IOException {
        int length = this.readLength();
        store.setLength(length);
        this.readRawBytes(store.array, 0, length);
    }

    public void readRawBytes(byte[] values, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            values[offset + i] = this.readRawByte();
        }
    }

    public int readRawVarint32() throws IOException {
        int x = this.readRawByte();
        if (x >= 0) {
            return x;
        }
        if ((x ^= this.readRawByte() << 7) < 0) {
            return x ^ 0xFFFFFF80;
        }
        if ((x ^= this.readRawByte() << 14) >= 0) {
            return x ^ 0x3F80;
        }
        if ((x ^= this.readRawByte() << 21) < 0) {
            return x ^ 0xFFE03F80;
        }
        byte y = this.readRawByte();
        if (y < 0 && this.readRawByte() < 0 && this.readRawByte() < 0 && this.readRawByte() < 0 && this.readRawByte() < 0 && this.readRawByte() < 0) {
            throw InvalidProtocolBufferException.malformedVarint();
        }
        return x ^ y << 28 ^ 0xFE03F80;
    }

    public long readRawVarint64() throws IOException {
        int y = this.readRawByte();
        if (y >= 0) {
            return y;
        }
        if ((y ^= this.readRawByte() << 7) < 0) {
            return y ^ 0xFFFFFF80;
        }
        if ((y ^= this.readRawByte() << 14) >= 0) {
            return y ^ 0x3F80;
        }
        if ((y ^= this.readRawByte() << 21) < 0) {
            return y ^ 0xFFE03F80;
        }
        long x = (long)y ^ (long)this.readRawByte() << 28;
        if (x >= 0L) {
            return x ^ 0xFE03F80L;
        }
        if ((x ^= (long)this.readRawByte() << 35) < 0L) {
            return x ^ 0xFFFFFFF80FE03F80L;
        }
        if ((x ^= (long)this.readRawByte() << 42) >= 0L) {
            return x ^ 0x3F80FE03F80L;
        }
        if ((x ^= (long)this.readRawByte() << 49) < 0L) {
            return x ^ 0xFFFE03F80FE03F80L;
        }
        if ((x ^= (long)this.readRawByte() << 56 ^ 0xFE03F80FE03F80L) < 0L && this.readRawByte() < 0) {
            throw InvalidProtocolBufferException.malformedVarint();
        }
        return x;
    }

    long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public short readRawLittleEndian16() throws IOException {
        return (short)(this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8);
    }

    public int readRawLittleEndian32() throws IOException {
        return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        return (long)this.readRawByte() & 0xFFL | ((long)this.readRawByte() & 0xFFL) << 8 | ((long)this.readRawByte() & 0xFFL) << 16 | ((long)this.readRawByte() & 0xFFL) << 24 | ((long)this.readRawByte() & 0xFFL) << 32 | ((long)this.readRawByte() & 0xFFL) << 40 | ((long)this.readRawByte() & 0xFFL) << 48 | ((long)this.readRawByte() & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    protected ProtoSource resetInternalState() {
        this.lastTag = 0;
        this.recursionDepth = 0;
        this.recursionLimit = 64;
        this.currentLimit = Integer.MAX_VALUE;
        return this;
    }

    protected ProtoSource() {
    }

    public int setRecursionLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + limit);
        }
        int oldLimit = this.recursionLimit;
        this.recursionLimit = limit;
        return oldLimit;
    }

    public int setSizeLimit(int limit) {
        throw new UnsupportedOperationException("Only valid for stream backed sources");
    }

    public ProtoSource resetSizeCounter() {
        throw new UnsupportedOperationException("Only valid for stream backed sources");
    }

    public final ProtoSource discardUnknownFields() {
        this.shouldDiscardUnknownFields = true;
        return this;
    }

    public final ProtoSource unsetDiscardUnknownFields() {
        this.shouldDiscardUnknownFields = false;
        return this;
    }

    final boolean shouldDiscardUnknownFields() {
        return this.shouldDiscardUnknownFields;
    }

    public int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
        if (byteLimit < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if ((byteLimit += this.getTotalBytesRead()) > this.currentLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int oldLimit = this.currentLimit;
        this.currentLimit = byteLimit;
        return oldLimit;
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        return this.currentLimit - this.getTotalBytesRead();
    }

    public abstract boolean isAtEnd() throws IOException;

    public abstract int getTotalBytesRead();

    public abstract void rewindTo(int var1);

    public abstract byte readRawByte() throws IOException;

    public abstract void skipRawBytes(int var1) throws IOException;

    protected void reserveRepeatedFieldCapacity(RepeatedField<?, ?> store, int tag) throws IOException {
    }

    protected void reservePackedVarintCapacity(RepeatedField<?, ?> store) throws IOException {
    }

    public static int readRawVarint32(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return ProtoSource.readRawVarint32(firstByte, input);
    }

    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        int b;
        int offset;
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        int result = firstByte & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = input.read();
            if (b == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            b = input.read();
            if (b == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    static class BufferSource
    extends ProtoSource {
        ByteBuffer buffer = ProtoUtil.EMPTY_BYTE_BUFFER;

        BufferSource() {
        }

        @Override
        public ProtoSource setInput(ByteBuffer buffer) {
            this.buffer = buffer;
            return this.resetInternalState();
        }

        @Override
        public ProtoSource clear() {
            return this.setInput(ProtoUtil.EMPTY_BYTE_BUFFER);
        }

        @Override
        public boolean isAtEnd() throws IOException {
            return this.currentLimit != Integer.MAX_VALUE ? this.buffer.position() == this.currentLimit : this.buffer.remaining() == 0;
        }

        @Override
        public int getTotalBytesRead() {
            return this.buffer.position();
        }

        @Override
        public void rewindTo(int totalBytesRead) {
            this.buffer.position(totalBytesRead);
        }

        @Override
        public byte readRawByte() throws IOException {
            try {
                return this.buffer.get();
            }
            catch (BufferUnderflowException truncated) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        @Override
        public void skipRawBytes(int size) throws IOException {
            if (this.buffer.remaining() < size) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.buffer.position(this.buffer.position() + size);
        }

        @Override
        public void readRawBytes(byte[] values, int offset, int length) throws IOException {
            try {
                this.buffer.get(values, offset, length);
            }
            catch (BufferUnderflowException truncated) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }
    }

    static class StreamSource
    extends ProtoSource {
        private int peekByte = -1;
        private int position = 0;
        private int sizeLimit = Integer.MAX_VALUE;
        private InputStream input = EMPTY_INPUT_STREAM;
        private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(ProtoUtil.EMPTY_BYTE_ARRAY);
        private static final int EOF = -1;

        StreamSource() {
        }

        @Override
        public ProtoSource setInput(InputStream stream) {
            this.input = stream;
            return this.resetInternalState();
        }

        @Override
        protected ProtoSource resetInternalState() {
            this.peekByte = -1;
            this.position = 0;
            this.sizeLimit = Integer.MAX_VALUE;
            return super.resetInternalState();
        }

        @Override
        public ProtoSource clear() {
            return this.setInput(EMPTY_INPUT_STREAM);
        }

        @Override
        public int setSizeLimit(int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException("Size limit cannot be negative: " + limit);
            }
            int oldLimit = this.sizeLimit;
            this.sizeLimit = limit;
            return oldLimit;
        }

        @Override
        public ProtoSource resetSizeCounter() {
            this.position = 0;
            return this;
        }

        @Override
        public boolean isAtEnd() throws IOException {
            return this.position == this.currentLimit || this.peek() == -1;
        }

        @Override
        public int getTotalBytesRead() {
            return this.position;
        }

        @Override
        public void rewindTo(int totalBytesRead) {
            throw new UnsupportedOperationException("Stream can't be rewound");
        }

        @Override
        public byte readRawByte() throws IOException {
            if (this.position == this.sizeLimit || this.position == this.currentLimit) {
                this.require(1);
            }
            if (this.peek() == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            try {
                ++this.position;
                byte by = (byte)this.peekByte;
                return by;
            }
            finally {
                this.peekByte = -1;
            }
        }

        private int peek() throws IOException {
            if (this.peekByte == -1 && (this.peekByte = this.input.read()) == -1 && this.getBytesUntilLimit() > 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.peekByte;
        }

        @Override
        public void skipRawBytes(int length) throws IOException {
            if (length == 0) {
                return;
            }
            this.require(length);
            if (this.peekByte != -1) {
                this.peekByte = -1;
                --length;
            }
            if (this.input.skip(length) < (long)length) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        @Override
        public void readRawBytes(byte[] buffer, int offset, int length) throws IOException {
            if (length == 0) {
                return;
            }
            this.require(length);
            if (this.peekByte != -1) {
                buffer[offset++] = (byte)this.peekByte;
                --length;
                this.peekByte = -1;
            }
            while (length > 0) {
                int n = this.input.read(buffer, offset, length);
                if (n == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                offset += n;
                length -= n;
            }
        }

        private void require(int size) throws IOException {
            int newPosition = this.position + size;
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (newPosition - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (newPosition > this.currentLimit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.position = newPosition;
        }
    }
}

