/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import us.hebi.quickbuf.Base64;
import us.hebi.quickbuf.RepeatedByte;
import us.hebi.quickbuf.Utf8;
import us.hebi.quickbuf.Utf8Decoder;

public final class ProtoUtil {
    static final Utf8Decoder DEFAULT_UTF8_DECODER = new Utf8Decoder(){

        @Override
        public String decode(byte[] bytes, int offset, int length) {
            return new String(bytes, offset, length, Charsets.UTF_8);
        }
    };
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);

    public static void decodeUtf8(byte[] bytes, int offset, int length, StringBuilder output) {
        Utf8.decodeArray(bytes, offset, length, output);
    }

    public static RepeatedByte decodeBase64(int expectedSize, String ... parts) {
        RepeatedByte bytes = (RepeatedByte)RepeatedByte.newEmptyInstance().reserve(expectedSize);
        for (String part : parts) {
            bytes.addAll(Base64.decode(part));
        }
        return bytes;
    }

    public static int hash32(CharSequence value) {
        if (value instanceof String) {
            return ((String)value).hashCode();
        }
        int hash = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + value.charAt(i);
        }
        return hash;
    }

    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static void checkBounds(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean isEqual(CharSequence a, CharSequence b) {
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    public static boolean isEqual(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static boolean isEqual(boolean a, boolean b) {
        return a == b;
    }

    public static boolean isEqual(long a, long b) {
        return a == b;
    }

    public static boolean isEqual(int a, int b) {
        return a == b;
    }

    public static boolean isEqual(byte a, byte b) {
        return a == b;
    }

    private ProtoUtil() {
    }

    static class Charsets {
        static final Charset UTF_8 = Charset.forName("UTF-8");
        static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
        static final Charset ASCII = Charset.forName("US-ASCII");

        Charsets() {
        }
    }
}

