/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import us.hebi.quickbuf.ProtoSink;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedField;

public final class RepeatedByte
extends RepeatedField<RepeatedByte, Byte> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 10;
    byte[] array = EMPTY_ARRAY;
    private static final byte[] EMPTY_ARRAY = new byte[0];

    public static RepeatedByte newEmptyInstance() {
        return new RepeatedByte();
    }

    public static RepeatedByte newInstance(byte[] initialValue) {
        return RepeatedByte.newEmptyInstance().copyFrom(initialValue);
    }

    RepeatedByte() {
    }

    @Override
    protected void extendCapacityTo(int desiredSize) {
        this.array = Arrays.copyOf(this.array, desiredSize);
    }

    @Override
    protected Byte getValueAt(int index) {
        return this.get(index);
    }

    public byte get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    public RepeatedByte set(int index, byte value) {
        this.checkIndex(index);
        this.array[index] = value;
        return this;
    }

    public RepeatedByte add(byte value) {
        int pos = this.addLength(1);
        this.array[pos] = value;
        return this;
    }

    public RepeatedByte addAll(byte[] values) {
        return this.addAll(values, 0, values.length);
    }

    public RepeatedByte addAll(byte[] buffer, int offset, int length) {
        int pos = this.addLength(length);
        System.arraycopy(buffer, offset, this.array, pos, length);
        return this;
    }

    public RepeatedByte copyFrom(byte[] buffer) {
        return this.copyFrom(buffer, 0, buffer.length);
    }

    public RepeatedByte copyFrom(byte[] buffer, int offset, int length) {
        this.setLength(length);
        System.arraycopy(buffer, offset, this.array, 0, length);
        return this;
    }

    @Override
    public void addAll(RepeatedByte values) {
        this.addAll(values.array, 0, values.length);
    }

    @Override
    public void copyFrom(RepeatedByte other) {
        if (other.length > this.length) {
            this.extendCapacityTo(other.length);
        }
        System.arraycopy(other.array, 0, this.array, 0, other.length);
        this.length = other.length;
    }

    public RepeatedByte setInternalArray(byte[] array) {
        return this.setInternalArray(array, array.length);
    }

    public RepeatedByte setInternalArray(byte[] array, int length) {
        ProtoUtil.checkNotNull(array);
        this.array = array;
        this.length = length;
        return this;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public final byte[] toArray() {
        if (this.length == 0) {
            return EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.array, this.length);
    }

    public final byte[] array() {
        return this.array;
    }

    public final RepeatedByte setLength(int length) {
        if (length - this.array.length > 0) {
            this.extendCapacityTo(length);
        }
        this.length = length;
        return this;
    }

    public final int addLength(int length) {
        int oldLength = this.length;
        int newLength = oldLength + length;
        int oldCapacity = this.array.length;
        if (newLength - oldCapacity > 0) {
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.array == EMPTY_ARRAY ? Math.max(newLength, 10) : newLength;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = RepeatedByte.hugeCapacity(minCapacity);
            }
            this.extendCapacityTo(newCapacity);
        }
        this.length = newLength;
        return oldLength;
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatedByte other = (RepeatedByte)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (ProtoUtil.isEqual(this.array[i], other.array[i])) continue;
            return false;
        }
        return true;
    }

    public RepeatedByte writeTo(ProtoSink sink) throws IOException {
        sink.writeRawBytes(this.array, 0, this.length);
        return this;
    }

    public RepeatedByte writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.array, 0, this.length);
        return this;
    }

    public RepeatedByte writeTo(ByteBuffer buffer) {
        buffer.put(this.array, 0, this.length);
        return this;
    }
}

