/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.Arrays;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedField;

public final class RepeatedLong
extends RepeatedField<RepeatedLong, Long> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 10;
    long[] array = EMPTY_ARRAY;
    private static final long[] EMPTY_ARRAY = new long[0];

    public static RepeatedLong newEmptyInstance() {
        return new RepeatedLong();
    }

    public static RepeatedLong newInstance(long[] initialValue) {
        return RepeatedLong.newEmptyInstance().copyFrom(initialValue);
    }

    RepeatedLong() {
    }

    @Override
    protected void extendCapacityTo(int desiredSize) {
        this.array = Arrays.copyOf(this.array, desiredSize);
    }

    @Override
    protected Long getValueAt(int index) {
        return this.get(index);
    }

    public long get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    public RepeatedLong set(int index, long value) {
        this.checkIndex(index);
        this.array[index] = value;
        return this;
    }

    public RepeatedLong add(long value) {
        int pos = this.addLength(1);
        this.array[pos] = value;
        return this;
    }

    public RepeatedLong addAll(long[] values) {
        return this.addAll(values, 0, values.length);
    }

    public RepeatedLong addAll(long[] buffer, int offset, int length) {
        int pos = this.addLength(length);
        System.arraycopy(buffer, offset, this.array, pos, length);
        return this;
    }

    public RepeatedLong copyFrom(long[] buffer) {
        return this.copyFrom(buffer, 0, buffer.length);
    }

    public RepeatedLong copyFrom(long[] buffer, int offset, int length) {
        this.setLength(length);
        System.arraycopy(buffer, offset, this.array, 0, length);
        return this;
    }

    @Override
    public void addAll(RepeatedLong values) {
        this.addAll(values.array, 0, values.length);
    }

    @Override
    public void copyFrom(RepeatedLong other) {
        if (other.length > this.length) {
            this.extendCapacityTo(other.length);
        }
        System.arraycopy(other.array, 0, this.array, 0, other.length);
        this.length = other.length;
    }

    public RepeatedLong setInternalArray(long[] array) {
        return this.setInternalArray(array, array.length);
    }

    public RepeatedLong setInternalArray(long[] array, int length) {
        ProtoUtil.checkNotNull(array);
        this.array = array;
        this.length = length;
        return this;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    public final long[] toArray() {
        if (this.length == 0) {
            return EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.array, this.length);
    }

    public final long[] array() {
        return this.array;
    }

    public final RepeatedLong setLength(int length) {
        if (length - this.array.length > 0) {
            this.extendCapacityTo(length);
        }
        this.length = length;
        return this;
    }

    public final int addLength(int length) {
        int oldLength = this.length;
        int newLength = oldLength + length;
        int oldCapacity = this.array.length;
        if (newLength - oldCapacity > 0) {
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            int minCapacity = this.array == EMPTY_ARRAY ? Math.max(newLength, 10) : newLength;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = RepeatedLong.hugeCapacity(minCapacity);
            }
            this.extendCapacityTo(newCapacity);
        }
        this.length = newLength;
        return oldLength;
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatedLong other = (RepeatedLong)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (ProtoUtil.isEqual(this.array[i], other.array[i])) continue;
            return false;
        }
        return true;
    }
}

