/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.hebi.quickbuf.InvalidProtocolBufferException;
import us.hebi.quickbuf.ProtoMessage;
import us.hebi.quickbuf.RepeatedMessage;

public class UninitializedMessageException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    String description;
    private ProtoMessage<?> origin;
    private List<String> missingFields;

    public UninitializedMessageException(ProtoMessage<?> message) {
        super("Message missing required fields");
        this.origin = message;
    }

    public UninitializedMessageException(RepeatedMessage<?> messageArray) {
        super("Message array missing required fields");
        this.missingFields = new ArrayList<String>();
        ProtoMessage.getMissingFields("", "", messageArray, this.missingFields);
    }

    public UninitializedMessageException(List<String> missingFields) {
        super("Message missing required fields");
        this.missingFields = missingFields;
    }

    UninitializedMessageException withParentMessage(ProtoMessage<?> message) {
        this.origin = message;
        this.description = null;
        this.missingFields = null;
        return this;
    }

    @Override
    public String getMessage() {
        if (this.description == null) {
            if (this.missingFields == null) {
                this.missingFields = this.origin.getMissingFields();
            }
            this.description = UninitializedMessageException.buildDescription(this.missingFields);
        }
        return this.description;
    }

    public List<String> getMissingFields() {
        if (this.missingFields == null) {
            this.missingFields = this.origin.getMissingFields();
        }
        return Collections.unmodifiableList(this.missingFields);
    }

    public InvalidProtocolBufferException asInvalidProtocolBufferException() {
        return new InvalidProtocolBufferException(this);
    }

    private static String buildDescription(List<String> missingFields) {
        StringBuilder description = new StringBuilder("Message missing required fields: ");
        boolean first = true;
        for (String field : missingFields) {
            if (first) {
                first = false;
            } else {
                description.append(", ");
            }
            description.append(field);
        }
        return description.toString();
    }
}

