/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sass;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import us.hebi.sass.PlatformUtil;

@Mojo(name="run")
@Execute(phase=LifecyclePhase.GENERATE_RESOURCES)
public class RunMojo
extends AbstractMojo {
    @Parameter(defaultValue="https://github.com/sass/dart-sass/releases/download/{sassVersion}/dart-sass-{sassVersion}-{os}-{arch}.{archiveExtension}")
    String downloadUrlTemplate;
    @Parameter
    Path downloadDirectory;
    @Parameter(defaultValue="dart-sass")
    String nestedDirectory;
    @Parameter(defaultValue="1.57.1", property="sass.version")
    String sassVersion;
    @Parameter(property="sass.skip", defaultValue="false")
    Boolean skip;
    @Parameter(property="sass.watch")
    Boolean watch;
    @Parameter(required=true)
    List<String> args;

    public void execute() throws MojoExecutionException {
        if (this.skip != null && this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping sass execution");
            return;
        }
        Path homeDir = this.downloadDirectory != null ? this.downloadDirectory.toAbsolutePath() : Paths.get(System.getProperty("user.home"), ".hebi", "sass");
        Path extractDir = homeDir.resolve(this.replaceTemplate("dart-sass-{sassVersion}-{os}-{arch}"));
        Path executable = extractDir.resolve(this.nestedDirectory).resolve(PlatformUtil.toScriptName("sass"));
        if (!Files.exists(executable, new LinkOption[0])) {
            try {
                String url = this.replaceTemplate(this.downloadUrlTemplate);
                this.getLog().info((CharSequence)("Downloading sass archive from " + url));
                PlatformUtil.downloadAndExtractArchive(new URL(url), extractDir);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid url", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to download dart sass archive", (Exception)e);
            }
        }
        if (!Files.isExecutable(executable)) {
            throw new MojoExecutionException("Target file is not executable: " + executable);
        }
        this.getLog().debug((CharSequence)("sass path: " + executable));
        ArrayList<String> commandArgs = new ArrayList<String>();
        commandArgs.add(String.valueOf(executable));
        commandArgs.addAll(this.args);
        if (this.watch != null && this.watch.booleanValue()) {
            commandArgs.add("--watch");
        }
        try {
            this.getLog().info((CharSequence)"Executing sass");
            int returnCode = new ProcessBuilder(commandArgs).inheritIO().start().waitFor();
            if (returnCode != 0) {
                throw new MojoExecutionException("Dart sass executable returned error code " + returnCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Failed to execute dart sass", e);
        }
    }

    String replaceTemplate(String input) {
        return input.replaceAll("\\{sassVersion}", this.sassVersion).replaceAll("\\{os}", this.getOsString()).replaceAll("\\{arch}", this.getArchString()).replaceAll("\\{archiveExtension}", PlatformUtil.getDefaultArchiveExtension());
    }

    String getOsString() {
        switch (PlatformUtil.getOsFamily()) {
            case Windows: {
                return "windows";
            }
            case Linux: {
                return "linux";
            }
            case macOS: {
                return "macos";
            }
        }
        throw new AssertionError((Object)("Unsupported OS: " + PlatformUtil.OS_NAME));
    }

    String getArchString() {
        switch (PlatformUtil.getArch()) {
            case x86_32: {
                return "ia32";
            }
            case x86_64: {
                return "x64";
            }
            case arm_64: {
                return "arm64";
            }
        }
        throw new AssertionError((Object)("Unsupported arch: " + PlatformUtil.OS_ARCH));
    }
}

