/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sass;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;

public class PlatformUtil {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);

    public static String getDefaultArchiveExtension() {
        return PlatformUtil.isWindows() ? "zip" : "tar.gz";
    }

    public static String toScriptName(String name) {
        return PlatformUtil.isWindows() ? name + ".bat" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadAndExtractArchive(URL url, Path destinationDirectory) throws IOException {
        Path tmpArchive = PlatformUtil.createTemporaryArchive(url.toExternalForm());
        try {
            try (InputStream downloadFile = url.openStream();){
                Files.createDirectories(destinationDirectory, new FileAttribute[0]);
                Files.copy(downloadFile, tmpArchive, StandardCopyOption.REPLACE_EXISTING);
            }
            PlatformUtil.extractArchive(tmpArchive, destinationDirectory);
        }
        finally {
            Files.delete(tmpArchive);
        }
    }

    private static Path createTemporaryArchive(String url) throws IOException {
        String extension;
        if (url.endsWith(".zip")) {
            extension = ".zip";
        } else if (url.endsWith(".tar.gz")) {
            extension = ".tar.gz";
        } else {
            throw new UnsupportedOperationException("Unsupported archive extension on: " + url);
        }
        return Files.createTempFile("archive", extension, new FileAttribute[0]);
    }

    public static void extractArchive(Path sourceArchive, Path destinationDirectory) {
        ZipUnArchiver unArchiver;
        String path = sourceArchive.toString().toLowerCase(Locale.ENGLISH);
        if (path.endsWith(".zip")) {
            unArchiver = new ZipUnArchiver();
        } else if (path.endsWith(".tar.gz")) {
            TarGZipUnArchiver untar = new TarGZipUnArchiver();
            untar.setCompression(TarUnArchiver.UntarCompressionMethod.GZIP);
            unArchiver = untar;
        } else {
            throw new UnsupportedOperationException("Unsupported archive extension on: " + path);
        }
        unArchiver.setSourceFile(sourceArchive.toFile());
        unArchiver.setOverwrite(true);
        unArchiver.setDestDirectory(destinationDirectory.toFile());
        unArchiver.extract();
    }

    public static Architecture getArch() {
        switch (OS_ARCH) {
            case "aarch64": {
                return Architecture.arm_64;
            }
            case "arm": {
                return Architecture.arm_32;
            }
            case "amd64": 
            case "ia64": 
            case "x86_64": {
                return Architecture.x86_64;
            }
            case "x86": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": {
                return Architecture.x86_32;
            }
        }
        throw new UnsupportedOperationException("Unsupported arch: " + System.getProperty("os.arch"));
    }

    public static OsFamily getOsFamily() {
        if (PlatformUtil.isWindows()) {
            return OsFamily.Windows;
        }
        if (PlatformUtil.isLinux()) {
            return OsFamily.Linux;
        }
        if (PlatformUtil.isMac()) {
            return OsFamily.macOS;
        }
        throw new UnsupportedOperationException("Unsupported OS: " + System.getProperty("os.name"));
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith("win");
    }

    public static boolean isMac() {
        return OS_NAME.contains("mac");
    }

    public static boolean isLinux() {
        return OS_NAME.startsWith("linux");
    }

    public static enum OsFamily {
        Windows,
        Linux,
        macOS;

    }

    public static enum Architecture {
        x86_32,
        x86_64,
        arm_32,
        arm_64;

    }
}

