/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.JSAPException;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.DRCFlatGroundWalkingTrack;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simulationconstructionset.util.ground.BumpyGroundProfile;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;

public class AtlasFlatGroundWalkingTrack {
    private static final DRCRobotModel defaultModelForGraphicSelector = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.SCS, false);
    private static final boolean USE_BUMPY_GROUND = false;

    public static void main(String[] args) throws JSAPException {
        AtlasRobotModel model = null;
        model = AtlasRobotModelFactory.selectSimulationModelFromFlag(args);
        if (model == null) {
            model = AtlasRobotModelFactory.selectModelFromGraphicSelector(defaultModelForGraphicSelector);
        }
        if (model == null) {
            throw new RuntimeException("No robot model selected");
        }
        DRCGuiInitialSetup guiInitialSetup = new DRCGuiInitialSetup(true, false);
        double groundHeight = 0.0;
        FlatGroundProfile groundProfile = new FlatGroundProfile(0.0);
        DRCSCSInitialSetup scsInitialSetup = new DRCSCSInitialSetup((GroundProfile3D)groundProfile, model.getSimulateDT());
        scsInitialSetup.setDrawGroundProfile(true);
        scsInitialSetup.setInitializeEstimatorToActual(true);
        double initialYaw = 0.3;
        RobotInitialSetup robotInitialSetup = model.getDefaultRobotInitialSetup(0.0, initialYaw);
        boolean useVelocityAndHeadingScript = true;
        boolean cheatWithGroundHeightAtForFootstep = false;
        DRCFlatGroundWalkingTrack drcFlatGroundWalkingTrack = new DRCFlatGroundWalkingTrack(robotInitialSetup, guiInitialSetup, scsInitialSetup, useVelocityAndHeadingScript, cheatWithGroundHeightAtForFootstep, (DRCRobotModel)model);
    }

    private static BumpyGroundProfile createBumpyGroundProfile() {
        double xAmp1 = 0.05;
        double xFreq1 = 0.5;
        double xAmp2 = 0.01;
        double xFreq2 = 0.5;
        double yAmp1 = 0.01;
        double yFreq1 = 0.07;
        double yAmp2 = 0.05;
        double yFreq2 = 0.37;
        BumpyGroundProfile groundProfile = new BumpyGroundProfile(xAmp1, xFreq1, xAmp2, xFreq2, yAmp1, yFreq1, yAmp2, yFreq2);
        return groundProfile;
    }
}

