/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasRobotModelFactory {
    private static final String[] AVAILABLE_ROBOT_MODELS = new String[AtlasRobotVersion.values().length];

    public static AtlasRobotModel createDefaultRobotModel() {
        return AtlasRobotModelFactory.createDRCRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ.toString(), RobotTarget.SCS, false, null);
    }

    public static AtlasRobotModel createDefaultRobotModel(FootContactPoints<RobotSide> simulationContactPoints) {
        return AtlasRobotModelFactory.createDRCRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ.toString(), RobotTarget.SCS, false, simulationContactPoints);
    }

    public static AtlasRobotModel createDefaultRobotModel(AtlasRobotVersion robotVersion) {
        return AtlasRobotModelFactory.createDRCRobotModel(robotVersion.toString(), RobotTarget.SCS, false, null);
    }

    public static AtlasRobotModel createDefaultRobotModel(AtlasRobotVersion robotVersion, FootContactPoints<RobotSide> simulationContactPoints) {
        return AtlasRobotModelFactory.createDRCRobotModel(robotVersion.toString(), RobotTarget.SCS, false, simulationContactPoints);
    }

    public static AtlasRobotModel createDRCRobotModel(String robotModelAsString, RobotTarget runningOnRealRobot, boolean headless) {
        return AtlasRobotModelFactory.createDRCRobotModel(robotModelAsString, runningOnRealRobot, headless, null);
    }

    public static AtlasRobotModel createDRCRobotModel(String robotModelAsString, RobotTarget runningOnRealRobot, boolean headless, FootContactPoints<RobotSide> simulationContactPoints) {
        robotModelAsString = robotModelAsString.toUpperCase().trim();
        try {
            AtlasRobotVersion atlasRobotVersion = AtlasRobotVersion.valueOf(robotModelAsString);
            if (atlasRobotVersion != null) {
                return new AtlasRobotModel(atlasRobotVersion, runningOnRealRobot, headless, simulationContactPoints);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException(robotModelAsString + " Not a valid robot model");
    }

    public static String robotModelsToString() {
        return Arrays.toString(AVAILABLE_ROBOT_MODELS);
    }

    public static String[] getAvailableRobotModels() {
        return AVAILABLE_ROBOT_MODELS;
    }

    public static int getOrdinalOfModel(String st) {
        st = st.toUpperCase();
        for (int i = 0; i < AVAILABLE_ROBOT_MODELS.length; ++i) {
            if (!st.equals(AVAILABLE_ROBOT_MODELS[i].toUpperCase())) continue;
            return i;
        }
        return -1;
    }

    public static AtlasRobotModel selectModelFromGraphicSelector() {
        return AtlasRobotModelFactory.selectModelFromGraphicSelector(new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.SCS, false));
    }

    public static AtlasRobotModel selectModelFromGraphicSelector(DRCRobotModel defaultOption) {
        JPanel userPromptPanel = new JPanel(new BorderLayout());
        JPanel comboBoxPanel = new JPanel(new BorderLayout());
        JLabel userMessageLabel = new JLabel("What robot?");
        JComboBox<String> robotTypeComboBox = new JComboBox<String>(AVAILABLE_ROBOT_MODELS);
        robotTypeComboBox.setSelectedItem(defaultOption.toString());
        comboBoxPanel.add(robotTypeComboBox, "North");
        userPromptPanel.add((Component)userMessageLabel, "North");
        userPromptPanel.add((Component)comboBoxPanel, "Center");
        int selectedOption = JOptionPane.showOptionDialog(null, userPromptPanel, "Select", 2, 3, null, null, null);
        if (selectedOption == 2) {
            System.err.println("Operation canceled by the user.");
            return null;
        }
        if (selectedOption == 0) {
            String groundTypeString = robotTypeComboBox.getSelectedItem().toString();
            AtlasRobotModel model = AtlasRobotModelFactory.createDRCRobotModel(groundTypeString, RobotTarget.SCS, false);
            return model;
        }
        throw new RuntimeException("Ooops!");
    }

    public static AtlasRobotModel selectSimulationModelFromFlag(String[] args) {
        JSAP jsap = new JSAP();
        FlaggedOption robotModel = new FlaggedOption("robotModel").setLongFlag("model").setShortFlag('m').setRequired(true).setStringParser((StringParser)JSAP.STRING_PARSER);
        robotModel.setHelp("Robot models: " + Arrays.toString(AVAILABLE_ROBOT_MODELS));
        try {
            jsap.registerParameter((Parameter)robotModel);
            JSAPResult config = jsap.parse(args);
            if (config.success()) {
                return AtlasRobotModelFactory.createDRCRobotModel(config.getString("robotModel"), RobotTarget.SCS, false);
            }
        }
        catch (JSAPException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        for (AtlasRobotVersion version : AtlasRobotVersion.values()) {
            AtlasRobotModelFactory.AVAILABLE_ROBOT_MODELS[version.ordinal()] = version.toString();
        }
    }
}

