/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import java.io.IOException;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataVisualizer.visualizer.SCSVisualizer;

public class RemoteAtlasVisualizer {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int DEFAULT_UPDATE_RATE = 6;

    public static void startVisualizer() {
        ExceptionTools.handle(() -> RemoteAtlasVisualizer.startVisualizer(16384, 6), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    public static void startVisualizer(int bufferSize, int updateRateInMs) throws IOException {
        SCSVisualizer scsVisualizer = new SCSVisualizer(bufferSize);
        scsVisualizer.setVariableUpdateRate(updateRateInMs);
        scsVisualizer.addButton("requestStop", 1.0);
        scsVisualizer.addButton("calibrateWristForceSensors", 1.0);
        scsVisualizer.setShowOverheadView(true);
        YoVariableClient client = new YoVariableClient((YoVariablesUpdatedListener)scsVisualizer);
        client.startWithHostSelector();
    }

    public static void main(String[] args) throws JSAPException, IOException {
        int bufferSize = 16384;
        JSAP jsap = new JSAP();
        FlaggedOption updateRate = new FlaggedOption("updateRate").setLongFlag("rate").setShortFlag('r').setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false);
        updateRate.setHelp("Determines how often the GUI will update its parameters in milliseconds.");
        updateRate.setDefault(Integer.toString(6));
        jsap.registerParameter((Parameter)updateRate);
        JSAPResult config = jsap.parse(args);
        int updateRateInMs = 6;
        if (config.contains("displayOneInNPackets")) {
            updateRateInMs = config.getInt("displayOneInNPackets");
        }
        RemoteAtlasVisualizer.startVisualizer(bufferSize, updateRateInMs);
    }
}

