/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors.scsSensorSimulation;

import org.apache.commons.lang3.SystemUtils;
import us.ihmc.atlas.behaviors.scsSensorSimulation.SensorOnlyController;
import us.ihmc.atlas.behaviors.scsSensorSimulation.SensorOnlyRobot;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.tools.gui.AWTTools;

public class SensorOnlySimulation {
    private final SimulationConstructionSet scs;

    public SensorOnlySimulation() {
        SensorOnlyRobot robot = new SensorOnlyRobot();
        YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
        this.scs = new SimulationConstructionSet((Robot)robot);
        this.scs.setDT(1.0E-4, 100);
        SensorOnlyController controller = new SensorOnlyController(robot, yoGraphicsListRegistry, this.scs);
        robot.setController(controller);
        this.scs.addYoGraphicsListRegistry(yoGraphicsListRegistry);
        CameraConfiguration camera = new CameraConfiguration("camera");
        camera.setCameraMount("camera");
        this.scs.setupCamera(camera);
        this.addSphere(2.0, 2.0, this.scs);
        this.addSphere(-2.0, 2.0, this.scs);
        this.addSphere(2.0, -2.0, this.scs);
        this.addSphere(-2.0, -2.0, this.scs);
        controller.initialize();
        if (!SystemUtils.IS_OS_WINDOWS) {
            this.scs.getGUI().getFrame().setSize(AWTTools.getDimensionOfSmallestScreenScaled((double)0.6666666666666666));
        }
        this.scs.startOnAThread();
    }

    public SimulationConstructionSet getSCS() {
        return this.scs;
    }

    public void addSphere(double x, double y, SimulationConstructionSet scs) {
        Graphics3DObject sphere = new Graphics3DObject();
        sphere.translate(x, y, 0.5);
        sphere.addSphere(1.0, YoAppearance.Gray());
        scs.addStaticLinkGraphics(sphere);
    }

    public static void main(String[] args) {
        new SensorOnlySimulation();
    }
}

