/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.operatorInterfaceDebugging;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import us.ihmc.atlas.operatorInterfaceDebugging.AtlasUIPacketRecorder;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.net.ConnectionStateListener;
import us.ihmc.communication.net.KryoStreamDeSerializer;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;

public class AtlasUIPacketLoader {
    private static final boolean PRESS_ENTER = false;
    private static final boolean LOOP_PLAYBACK = false;
    private static final double PLAYBACK_SPEED = 0.5;

    public AtlasUIPacketLoader() throws IOException {
        IHMCCommunicationKryoNetClassList netClassList = new IHMCCommunicationKryoNetClassList();
        final KryoStreamDeSerializer kryoStreamDeSerializer = new KryoStreamDeSerializer(Conversions.megabytesToBytes((int)500));
        kryoStreamDeSerializer.registerClasses((NetClassList)netClassList);
        final PacketCommunicator packetCommunicator = PacketCommunicator.createTCPPacketCommunicatorServer((NetworkPorts)NetworkPorts.NETWORK_PROCESSOR_TO_UI_TCP_PORT, (int)Conversions.megabytesToBytes((int)500), (int)Conversions.megabytesToBytes((int)500), (NetClassList)netClassList);
        packetCommunicator.connect();
        packetCommunicator.attachStateListener(new ConnectionStateListener(){
            private DataInputStream fileDataInputStream;
            private BufferedReader timingReader;

            public void openFileDataStream() throws IOException {
                this.fileDataInputStream = FileTools.newFileDataInputStream((Path)AtlasUIPacketRecorder.getPacketRecordingFilePath(), (int)Conversions.megabytesToBytes((int)500));
                this.timingReader = Files.newBufferedReader(AtlasUIPacketRecorder.getPacketTimingPath());
            }

            public void disconnected() {
            }

            public void connected() {
                PrintTools.info((String)"Connected");
                try {
                    this.openFileDataStream();
                    Packet packet = null;
                    do {
                        try {
                            packet = (Packet)kryoStreamDeSerializer.read((InputStream)this.fileDataInputStream);
                            PrintTools.info((String)("Sending: " + packet));
                            packetCommunicator.send(packet);
                            double timeToWait = 0.01;
                            if (this.timingReader.ready()) {
                                timeToWait = Double.valueOf(this.timingReader.readLine()) / 0.5;
                            }
                            ThreadTools.sleepSeconds((double)timeToWait);
                        }
                        catch (IOException e) {
                            PrintTools.error((String)e.getMessage());
                        }
                    } while (packet != null && this.fileDataInputStream.available() > 1);
                    this.fileDataInputStream.close();
                    packetCommunicator.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void main(String[] args) throws IOException {
        new AtlasUIPacketLoader();
    }
}

