/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.operatorInterfaceDebugging;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.communication.configuration.NetworkParameterKeys;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.ConnectionStateListener;
import us.ihmc.communication.net.KryoStreamSerializer;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packetCommunicator.interfaces.GlobalPacketConsumer;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;

public class AtlasUIPacketRecorder {
    private static final Path PACKET_RECORDINGS_PATH = Paths.get("./packetRecordings", new String[0]);
    private static final String PACKET_RECORDING_FILENAME = "PacketRecording_" + FormattingTools.getDateString() + "_real3";
    private Object streamConch = new Object();

    public AtlasUIPacketRecorder() throws IOException {
        Scanner scanner = new Scanner(System.in);
        PrintTools.info((String)"Press Enter to record...");
        scanner.nextLine();
        final DataOutputStream fileDataOutputStream = FileTools.newFileDataOutputStream((Path)AtlasUIPacketRecorder.getPacketRecordingFilePath(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        final PrintWriter timeWriter = FileTools.newPrintWriter((Path)AtlasUIPacketRecorder.getPacketTimingPath(), (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        IHMCCommunicationKryoNetClassList netClassList = new IHMCCommunicationKryoNetClassList();
        final KryoStreamSerializer kryoStreamSerializer = new KryoStreamSerializer(Conversions.megabytesToBytes((int)10));
        kryoStreamSerializer.registerClasses((NetClassList)netClassList);
        PacketCommunicator packetClient = PacketCommunicator.createTCPPacketCommunicatorClient((String)NetworkParameters.getHost((NetworkParameterKeys)NetworkParameterKeys.networkManager), (NetworkPorts)NetworkPorts.NETWORK_PROCESSOR_TO_UI_TCP_PORT, (NetClassList)netClassList);
        packetClient.attachStateListener(new ConnectionStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void disconnected() {
                PrintTools.info((String)"Disconnected");
                try {
                    Object object = AtlasUIPacketRecorder.this.streamConch;
                    synchronized (object) {
                        fileDataOutputStream.flush();
                        fileDataOutputStream.close();
                        timeWriter.flush();
                        timeWriter.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void connected() {
                PrintTools.info((String)"Connected");
            }
        });
        packetClient.connect();
        packetClient.attachGlobalListener(new GlobalPacketConsumer(){
            Stopwatch timer = new Stopwatch();
            boolean firstPacketReceived = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receivedPacket(Packet<?> packet) {
                try {
                    Object object = AtlasUIPacketRecorder.this.streamConch;
                    synchronized (object) {
                        if (!this.firstPacketReceived) {
                            this.firstPacketReceived = true;
                            this.timer.start();
                        } else {
                            timeWriter.println(this.timer.lap());
                        }
                        PrintTools.info((String)("Receiving packet: " + packet));
                        kryoStreamSerializer.write((OutputStream)fileDataOutputStream, packet);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        scanner.nextLine();
        scanner.close();
        packetClient.disconnect();
    }

    public static Path getPacketRecordingFilePath() {
        FileTools.ensureDirectoryExists((Path)PACKET_RECORDINGS_PATH, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        return PACKET_RECORDINGS_PATH.resolve(AtlasUIPacketRecorder.getPrefixFileName() + ".ibag");
    }

    public static Path getPacketTimingPath() {
        return AtlasUIPacketRecorder.getPacketRecordingFilePath().getParent().resolve(AtlasUIPacketRecorder.getPrefixFileName() + ".tbag");
    }

    public static String getPrefixFileName() {
        return "PacketRecording_" + FormattingTools.getDateString() + "_real5";
    }

    public static void main(String[] args) throws IOException {
        new AtlasUIPacketRecorder();
    }
}

