/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGains;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.CoPProjectionTowardsMidpoint;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.ICPControllerParameters;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AtlasICPControllerParameters
extends ICPControllerParameters {
    private final boolean runningOnRealRobot;
    private final boolean useAngularMomentum = true;
    private ICPControllerParameters.FeedbackProjectionOperator feedbackProjectionOperator;

    public AtlasICPControllerParameters(boolean runningOnRealRobot) {
        this.runningOnRealRobot = runningOnRealRobot;
    }

    public double getFeedbackLateralWeight() {
        return this.runningOnRealRobot ? 1.5 : 1.5;
    }

    public double getFeedbackForwardWeight() {
        return this.runningOnRealRobot ? 1.5 : 1.5;
    }

    public double getFeedbackRateWeight() {
        return 5.0E-8;
    }

    public double getCoPCMPFeedbackRateWeight() {
        return 0.0;
    }

    public ICPControlGainsReadOnly getICPFeedbackGains() {
        ICPControlGains gains = new ICPControlGains();
        gains.setKpOrthogonalToMotion(2.0);
        gains.setKpParallelToMotion(2.5);
        gains.setIntegralLeakRatio(0.97);
        gains.setMaxIntegralError(0.05);
        gains.setKi(1.0);
        return gains;
    }

    public double getDynamicsObjectiveWeight() {
        return 10000.0;
    }

    public double getAngularMomentumMinimizationWeight() {
        return 10.0;
    }

    public boolean scaleFeedbackWeightWithGain() {
        return true;
    }

    public boolean useAngularMomentum() {
        return true;
    }

    public double getSafeCoPDistanceToEdge() {
        return 0.001;
    }

    public double getFeedbackDirectionWeight() {
        return 1000000.0;
    }

    public boolean useSmartICPIntegrator() {
        return true;
    }

    public void createFeedbackProjectionOperator(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.feedbackProjectionOperator = new CoPProjectionTowardsMidpoint(registry, yoGraphicsListRegistry);
    }

    public ICPControllerParameters.FeedbackProjectionOperator getFeedbackProjectionOperator() {
        return this.feedbackProjectionOperator;
    }
}

