/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FrameCapsule3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.geometry.shapes.FrameSTPBox3D;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.physics.Collidable;
import us.ihmc.robotics.physics.CollidableHelper;
import us.ihmc.robotics.physics.RobotCollisionModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class AtlasKinematicsCollisionModel
implements RobotCollisionModel {
    private final HumanoidJointNameMap jointMap;

    public AtlasKinematicsCollisionModel(HumanoidJointNameMap jointMap) {
        this.jointMap = jointMap;
    }

    public List<Collidable> getRobotCollidables(MultiBodySystemBasics multiBodySystem) {
        CollidableHelper helper = new CollidableHelper();
        ArrayList<Collidable> collidables = new ArrayList<Collidable>();
        String bodyName = "Body";
        SideDependentList armNames = new SideDependentList((Object)"LeftArm", (Object)"RightArm");
        long collisionMask = helper.getCollisionMask(bodyName);
        long collisionGroup = helper.createCollisionGroup(new String[]{(String)armNames.get((Enum)RobotSide.LEFT), (String)armNames.get((Enum)RobotSide.RIGHT)});
        RigidBodyBasics head = RobotCollisionModel.findRigidBody((String)this.jointMap.getHeadName(), (MultiBodySystemBasics)multiBodySystem);
        RigidBodyBasics torso = RobotCollisionModel.findRigidBody((String)this.jointMap.getChestName(), (MultiBodySystemBasics)multiBodySystem);
        RigidBodyBasics pelvis = RobotCollisionModel.findRigidBody((String)this.jointMap.getPelvisName(), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame headFrame = head.getBodyFixedFrame();
        FrameCapsule3D headShapeMultisense = new FrameCapsule3D((ReferenceFrame)headFrame, 0.08, 0.115);
        headShapeMultisense.getPosition().set(0.03, 0.0, 0.03);
        headShapeMultisense.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        collidables.add(new Collidable(head, collisionMask, collisionGroup, (FrameShape3DReadOnly)headShapeMultisense));
        MovingReferenceFrame torsoFrame = torso.getParentJoint().getFrameAfterJoint();
        MovingReferenceFrame beforeNeckFrame = head.getParentJoint().getFrameBeforeJoint();
        FrameCapsule3D headguardShapeFront = new FrameCapsule3D((ReferenceFrame)beforeNeckFrame, 0.25, 0.11);
        headguardShapeFront.getPosition().set(0.0, 0.0, 0.0);
        headguardShapeFront.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)headguardShapeFront));
        FrameCapsule3D torsoShapeFrontShoulder = new FrameCapsule3D((ReferenceFrame)torsoFrame, 0.2, 0.2);
        torsoShapeFrontShoulder.getPosition().set(0.14, 0.0, 0.415);
        torsoShapeFrontShoulder.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)torsoShapeFrontShoulder));
        FrameCapsule3D torsoShapeCenter = new FrameCapsule3D((ReferenceFrame)torsoFrame, 0.25, 0.2);
        torsoShapeCenter.getPosition().set(-0.015, 0.0, 0.265);
        torsoShapeCenter.getAxis().set((UnitVector3DReadOnly)Axis3D.X);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)torsoShapeCenter));
        FrameCapsule3D torsoShapeBottomCenter = new FrameCapsule3D((ReferenceFrame)torsoFrame, 0.25, 0.2);
        torsoShapeBottomCenter.getPosition().set(-0.045, 0.0, 0.115);
        torsoShapeBottomCenter.getAxis().set((UnitVector3DReadOnly)Axis3D.X);
        collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)torsoShapeBottomCenter));
        for (RobotSide robotSide : RobotSide.values) {
            FrameCapsule3D torsoShapeBottomSideCorner = new FrameCapsule3D((ReferenceFrame)torsoFrame, 0.25, 0.1);
            torsoShapeBottomSideCorner.getPosition().set(-0.115, robotSide.negateIfRightSide(0.1), 0.067);
            torsoShapeBottomSideCorner.getAxis().set((UnitVector3DReadOnly)Axis3D.X);
            collidables.add(new Collidable(torso, collisionMask, collisionGroup, (FrameShape3DReadOnly)torsoShapeBottomSideCorner));
        }
        MovingReferenceFrame pelvisFrame = pelvis.getParentJoint().getFrameAfterJoint();
        FrameCapsule3D pelvisShape = new FrameCapsule3D((ReferenceFrame)pelvisFrame, 0.05, 0.22);
        pelvisShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        pelvisShape.getPosition().set(0.012, 0.0, 0.037);
        collidables.add(new Collidable(pelvis, collisionMask, collisionGroup, (FrameShape3DReadOnly)pelvisShape));
        for (RobotSide robotSide : RobotSide.values) {
            JointBasics hipPitchJoint = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(robotSide, LegJointName.HIP_PITCH), (MultiBodySystemBasics)multiBodySystem);
            RigidBodyBasics thigh = hipPitchJoint.getSuccessor();
            MovingReferenceFrame thighFrame = hipPitchJoint.getFrameAfterJoint();
            FrameCapsule3D thighShapeTop = new FrameCapsule3D((ReferenceFrame)thighFrame, 0.1, 0.09);
            thighShapeTop.getPosition().set(0.0, 0.0, -0.1);
            thighShapeTop.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
            collidables.add(new Collidable(thigh, collisionMask, collisionGroup, (FrameShape3DReadOnly)thighShapeTop));
            FrameCapsule3D thighShapeBottom = new FrameCapsule3D((ReferenceFrame)thighFrame, 0.15, 0.085);
            thighShapeBottom.getPosition().set(-0.018, 0.0, -0.25);
            thighShapeBottom.getAxis().set(0.22, 0.0, 1.0);
            collidables.add(new Collidable(thigh, collisionMask, collisionGroup, (FrameShape3DReadOnly)thighShapeBottom));
            FrameCapsule3D thighShapeBack = new FrameCapsule3D((ReferenceFrame)thighFrame, 0.15, 0.085);
            thighShapeBack.getPosition().set(-0.05, 0.0, -0.15);
            thighShapeBack.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
            collidables.add(new Collidable(thigh, collisionMask, collisionGroup, (FrameShape3DReadOnly)thighShapeBack));
            JointBasics shinPitchJoint = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH), (MultiBodySystemBasics)multiBodySystem);
            RigidBodyBasics shin = shinPitchJoint.getSuccessor();
            MovingReferenceFrame shinFrame = shinPitchJoint.getFrameAfterJoint();
            FrameCapsule3D shinShape = new FrameCapsule3D((ReferenceFrame)shinFrame, 0.3, 0.08);
            shinShape.getPosition().set(0.015, 0.0, -0.2);
            shinShape.getAxis().set(0.1, 0.0, 1.0);
            collidables.add(new Collidable(shin, collisionMask, collisionGroup, (FrameShape3DReadOnly)shinShape));
        }
        for (RobotSide robotSide : RobotSide.values) {
            long collisionMask2 = helper.getCollisionMask((String)armNames.get((Enum)robotSide));
            long collisionGroup2 = helper.createCollisionGroup(new String[]{bodyName, (String)armNames.get((Enum)robotSide.getOppositeSide())});
            RigidBodyBasics hand = RobotCollisionModel.findRigidBody((String)this.jointMap.getHandName(robotSide), (MultiBodySystemBasics)multiBodySystem);
            MovingReferenceFrame handFrame = hand.getParentJoint().getFrameAfterJoint();
            FrameCapsule3D handShapeKnob = new FrameCapsule3D((ReferenceFrame)handFrame, 0.07, 0.06);
            handShapeKnob.getPosition().set(0.0, robotSide.negateIfRightSide(0.1), 0.0);
            handShapeKnob.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
            collidables.add(new Collidable(hand, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)handShapeKnob));
            JointBasics elbowJoint = RobotCollisionModel.findJoint((String)this.jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_ROLL), (MultiBodySystemBasics)multiBodySystem);
            RigidBodyBasics forearm = elbowJoint.getSuccessor();
            MovingReferenceFrame elbowFrame = elbowJoint.getFrameAfterJoint();
            FrameCapsule3D forearmShape = new FrameCapsule3D((ReferenceFrame)elbowFrame, 0.31, 0.1);
            forearmShape.getPosition().set(-0.01, robotSide.negateIfRightSide(0.12), -0.01);
            forearmShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Y);
            collidables.add(new Collidable(forearm, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)forearmShape));
        }
        collidables.addAll(this.setupLegCollisions(multiBodySystem, helper));
        return collidables;
    }

    private List<Collidable> setupLegCollisions(MultiBodySystemBasics multiBodySystem, CollidableHelper helper) {
        ArrayList<Collidable> collidables = new ArrayList<Collidable>();
        String leftFootName = "LeftFoot";
        String rightFootName = "RightFoot";
        long collisionMask = helper.getCollisionMask(leftFootName);
        long collisionGroup = helper.createCollisionGroup(new String[]{rightFootName});
        JointBasics ankleRoll = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(RobotSide.LEFT, LegJointName.ANKLE_ROLL), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame ankleRollFrame = ankleRoll.getFrameAfterJoint();
        RigidBodyBasics foot = ankleRoll.getSuccessor();
        FrameSTPBox3D footShape = new FrameSTPBox3D((ReferenceFrame)ankleRollFrame, 0.26, 0.14, 0.055);
        footShape.getPosition().set(0.045, 0.0, -0.05);
        footShape.setMargins(1.0E-5, 4.0E-4);
        collidables.add(new Collidable(foot, collisionMask, collisionGroup, (FrameShape3DReadOnly)footShape));
        collisionMask = helper.getCollisionMask(rightFootName);
        collisionGroup = helper.createCollisionGroup(new String[]{leftFootName});
        ankleRoll = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(RobotSide.RIGHT, LegJointName.ANKLE_ROLL), (MultiBodySystemBasics)multiBodySystem);
        ankleRollFrame = ankleRoll.getFrameAfterJoint();
        foot = ankleRoll.getSuccessor();
        footShape = new FrameSTPBox3D((ReferenceFrame)ankleRollFrame, 0.26, 0.14, 0.055);
        footShape.getPosition().set(0.045, 0.0, -0.05);
        footShape.setMargins(1.0E-5, 4.0E-4);
        collidables.add(new Collidable(foot, collisionMask, collisionGroup, (FrameShape3DReadOnly)footShape));
        String leftThighName = "LeftThigh";
        String rightThighName = "RightThigh";
        long collisionMask2 = helper.getCollisionMask(leftThighName);
        long collisionGroup2 = helper.createCollisionGroup(new String[]{rightThighName});
        JointBasics hipPitch = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(RobotSide.LEFT, LegJointName.HIP_PITCH), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame hipPitchFrame = hipPitch.getFrameAfterJoint();
        RigidBodyBasics thigh = hipPitch.getSuccessor();
        FrameCapsule3D thighTopShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.1, 0.09);
        thighTopShape.getPosition().set(0.0, 0.0, -0.1);
        thighTopShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        collidables.add(new Collidable(thigh, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)thighTopShape));
        FrameCapsule3D thighFrontShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.15, 0.085);
        thighFrontShape.getPosition().set(-0.018, 0.0, -0.25);
        thighFrontShape.getAxis().set((Tuple3DReadOnly)new Vector3D(0.22, 0.0, 1.0));
        collidables.add(new Collidable(thigh, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)thighFrontShape));
        FrameCapsule3D thighBackShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.15, 0.085);
        thighBackShape.getPosition().set(-0.05, 0.0, -0.15);
        thighBackShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        collidables.add(new Collidable(thigh, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)thighBackShape));
        collisionMask2 = helper.getCollisionMask(rightThighName);
        collisionGroup2 = helper.createCollisionGroup(new String[]{leftThighName});
        hipPitch = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(RobotSide.RIGHT, LegJointName.HIP_PITCH), (MultiBodySystemBasics)multiBodySystem);
        hipPitchFrame = hipPitch.getFrameAfterJoint();
        thigh = hipPitch.getSuccessor();
        thighTopShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.1, 0.09);
        thighTopShape.getPosition().set(0.0, 0.0, -0.1);
        thighTopShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        collidables.add(new Collidable(thigh, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)thighTopShape));
        thighFrontShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.15, 0.085);
        thighFrontShape.getPosition().set(-0.018, 0.0, -0.25);
        thighFrontShape.getAxis().set((Tuple3DReadOnly)new Vector3D(0.22, 0.0, 1.0));
        collidables.add(new Collidable(thigh, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)thighFrontShape));
        thighBackShape = new FrameCapsule3D((ReferenceFrame)hipPitchFrame, 0.15, 0.085);
        thighBackShape.getPosition().set(-0.05, 0.0, -0.15);
        thighBackShape.getAxis().set((UnitVector3DReadOnly)Axis3D.Z);
        collidables.add(new Collidable(thigh, collisionMask2, collisionGroup2, (FrameShape3DReadOnly)thighBackShape));
        String leftShinName = "LeftShin";
        String rightShinName = "RightShin";
        long collisionMask3 = helper.getCollisionMask(leftShinName);
        long collisionGroup3 = helper.createCollisionGroup(new String[]{rightShinName});
        JointBasics kneePitch = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(RobotSide.LEFT, LegJointName.KNEE_PITCH), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame kneePitchFrame = kneePitch.getFrameAfterJoint();
        RigidBodyBasics shin = kneePitch.getSuccessor();
        FrameCapsule3D shinShape = new FrameCapsule3D((ReferenceFrame)kneePitchFrame, 0.3, 0.08);
        shinShape.getPosition().set(0.015, 0.0, -0.2);
        shinShape.getAxis().set((Tuple3DReadOnly)new Vector3D(0.1, 0.0, 1.0));
        collidables.add(new Collidable(shin, collisionMask3, collisionGroup3, (FrameShape3DReadOnly)shinShape));
        collisionMask3 = helper.getCollisionMask(rightThighName);
        collisionGroup3 = helper.createCollisionGroup(new String[]{leftThighName});
        RobotSide robotSide = RobotSide.RIGHT;
        JointBasics kneePitch2 = RobotCollisionModel.findJoint((String)this.jointMap.getLegJointName(RobotSide.RIGHT, LegJointName.KNEE_PITCH), (MultiBodySystemBasics)multiBodySystem);
        MovingReferenceFrame kneePitchFrame2 = kneePitch2.getFrameAfterJoint();
        RigidBodyBasics shin2 = kneePitch2.getSuccessor();
        FrameCapsule3D shinShape2 = new FrameCapsule3D((ReferenceFrame)kneePitchFrame2, 0.3, 0.08);
        shinShape2.getPosition().set(0.015, 0.0, -0.2);
        shinShape2.getAxis().set((Tuple3DReadOnly)new Vector3D(0.1, 0.0, 1.0));
        collidables.add(new Collidable(shin2, collisionMask3, collisionGroup3, (FrameShape3DReadOnly)shinShape2));
        return collidables;
    }
}

