/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.ros;

import java.util.ArrayList;
import java.util.HashMap;
import us.ihmc.avatar.handControl.FingerJoint;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class ROSSandiaJointMap {
    public static final int f0_j0 = 0;
    public static final int f0_j1 = 1;
    public static final int f0_j2 = 2;
    public static final int f1_j0 = 3;
    public static final int f1_j1 = 4;
    public static final int f1_j2 = 5;
    public static final int f2_j0 = 6;
    public static final int f2_j1 = 7;
    public static final int f2_j2 = 8;
    public static final int f3_j0 = 9;
    public static final int f3_j1 = 10;
    public static final int f3_j2 = 11;
    public static final int numberOfJointsPerHand = 12;
    public static final SideDependentList<String[]> handNames = new SideDependentList();

    public static FingerJoint[] getFingerMap(RobotSide robotSide, ArrayList<FingerJoint> handJoints) {
        HashMap<String, FingerJoint> jointsByName = new HashMap<String, FingerJoint>();
        for (FingerJoint fingerJoint : handJoints) {
            jointsByName.put(fingerJoint.getName(), fingerJoint);
        }
        FingerJoint[] joints = new FingerJoint[12];
        for (int i = 0; i < 12; ++i) {
            joints[i] = (FingerJoint)jointsByName.get(((String[])handNames.get((Enum)robotSide))[i]);
        }
        return joints;
    }

    static {
        for (RobotSide robotSide : RobotSide.values) {
            String prefix = robotSide.getLowerCaseName() + "_";
            String[] handNamesForSide = new String[]{prefix + "f0_j0", prefix + "f0_j1", prefix + "f0_j2", prefix + "f1_j0", prefix + "f1_j1", prefix + "f1_j2", prefix + "f2_j0", prefix + "f2_j1", prefix + "f2_j2", prefix + "f3_j0", prefix + "f3_j1", prefix + "f3_j2"};
            handNames.put((Enum)robotSide, (Object)handNamesForSide);
        }
    }
}

