/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.generator.manager;

import com.eprosima.idl.generator.manager.TemplateExtension;
import com.eprosima.idl.generator.manager.TemplateGroup;
import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.log.ColorMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class TemplateManager {
    private static String m_loaderDirectories = "com/eprosima/idl/templates";
    private Map<String, StringTemplateGroup> m_groups = null;
    private Map<String, List<TemplateExtension>> m_extensions = null;
    private StringTemplateGroup strackgr_ = null;

    public TemplateManager(String stackTemplateNames) {
        CommonGroupLoader loader = new CommonGroupLoader(m_loaderDirectories, (StringTemplateErrorListener)new TemplateErrorListener());
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        TypeCode.idltypesgr = StringTemplateGroup.loadGroup((String)"idlTypes", DefaultTemplateLexer.class, null);
        TypeCode.cpptypesgr = StringTemplateGroup.loadGroup((String)"Types", DefaultTemplateLexer.class, null);
        TypeCode.javatypesgr = StringTemplateGroup.loadGroup((String)"JavaTypes", DefaultTemplateLexer.class, null);
        this.m_groups = new HashMap<String, StringTemplateGroup>();
        this.m_extensions = new HashMap<String, List<TemplateExtension>>();
        if (stackTemplateNames != null && !stackTemplateNames.isEmpty()) {
            int index = -1;
            int lastIndex = 0;
            String templateName = null;
            while ((index = stackTemplateNames.indexOf(58, lastIndex)) != -1) {
                templateName = stackTemplateNames.substring(lastIndex, index);
                this.strackgr_ = StringTemplateGroup.loadGroup((String)templateName, DefaultTemplateLexer.class, (StringTemplateGroup)this.strackgr_);
                lastIndex = index + 1;
            }
            templateName = stackTemplateNames.substring(lastIndex, stackTemplateNames.length());
            this.strackgr_ = StringTemplateGroup.loadGroup((String)templateName, DefaultTemplateLexer.class, (StringTemplateGroup)this.strackgr_);
        }
    }

    public static void setGroupLoaderDirectories(String paths) {
        m_loaderDirectories = m_loaderDirectories + ":" + paths;
    }

    public void changeCppTypesTemplateGroup(String templateName) {
        TypeCode.cpptypesgr = StringTemplateGroup.loadGroup((String)templateName, DefaultTemplateLexer.class, null);
    }

    public void addGroup(String groupname) {
        StringTemplateGroup group = StringTemplateGroup.loadGroup((String)groupname, DefaultTemplateLexer.class, (StringTemplateGroup)this.strackgr_);
        this.m_groups.put(groupname, group);
    }

    public void addGroup(String groupname, List<TemplateExtension> extensions) {
        this.addGroup(groupname);
        for (TemplateExtension extension : extensions) {
            String str = groupname + "_" + extension.getRuleName();
            List<Object> list = null;
            list = this.m_extensions.containsKey(str) ? this.m_extensions.get(str) : new ArrayList();
            extension.setCommonGroup(this.strackgr_);
            list.add(extension);
            this.m_extensions.put(str, list);
        }
    }

    public TemplateGroup createTemplateGroup(String templatename) {
        TemplateGroup tg = new TemplateGroup();
        Set<Map.Entry<String, StringTemplateGroup>> set = this.m_groups.entrySet();
        for (Map.Entry<String, StringTemplateGroup> m : set) {
            StringTemplate template = m.getValue().getInstanceOf(templatename);
            if (!this.m_extensions.containsKey(m.getKey() + "_" + template.getName())) {
                tg.addTemplate(m.getKey(), template);
                continue;
            }
            List<TemplateExtension> extensions = this.m_extensions.get(m.getKey() + "_" + template.getName());
            ArrayList<StringTemplate> extensionstemplates = new ArrayList<StringTemplate>();
            for (TemplateExtension extension : extensions) {
                extensionstemplates.add(extension.createStringTemplate());
            }
            tg.addTemplate(m.getKey(), template, extensionstemplates);
        }
        return tg;
    }

    public StringTemplate createStringTemplate(String templatename) {
        return this.strackgr_.getInstanceOf(templatename);
    }

    public StringTemplateGroup createStringTemplateGroup(String templateGroupName) {
        return StringTemplateGroup.loadGroup((String)templateGroupName, DefaultTemplateLexer.class, (StringTemplateGroup)this.strackgr_);
    }

    class TemplateErrorListener
    implements StringTemplateErrorListener {
        TemplateErrorListener() {
        }

        public void error(String arg0, Throwable arg1) {
            System.out.println(ColorMessage.error() + arg0);
            arg1.printStackTrace();
        }

        public void warning(String arg0) {
            System.out.println(ColorMessage.warning() + arg0);
        }
    }
}

