/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface FramePlane3DReadOnly
extends Plane3DReadOnly,
EuclidFrameGeometry {
    public FramePoint3DReadOnly getPoint();

    public FrameUnitVector3DReadOnly getNormal();

    default public double distance(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        return this.distance((Point3DReadOnly)point);
    }

    default public double signedDistance(FramePoint3DReadOnly point) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point);
        return this.signedDistance((Point3DReadOnly)point);
    }

    default public boolean intersectionWith(FrameLine3DReadOnly line, FramePoint3DBasics intersectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)line, (ReferenceFrameHolder)intersectionToPack);
        return this.intersectionWith(intersectionToPack, line.getPoint(), (FrameVector3DReadOnly)line.getDirection());
    }

    default public boolean intersectionWith(FramePoint3DBasics intersectionToPack, FramePoint3DReadOnly pointOnLine, FrameVector3DReadOnly lineDirection) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)intersectionToPack, (ReferenceFrameHolder)pointOnLine, (ReferenceFrameHolder)lineDirection);
        return EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)this.getPoint(), (Vector3DReadOnly)this.getNormal(), (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection, (Point3DBasics)intersectionToPack);
    }

    default public boolean isCoincident(FramePlane3DReadOnly otherPlane, double angleEpsilon, double distanceEpsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)otherPlane);
        return EuclidGeometryTools.arePlane3DsCoincident((Point3DReadOnly)this.getPoint(), (Vector3DReadOnly)this.getNormal(), (Point3DReadOnly)otherPlane.getPoint(), (Vector3DReadOnly)otherPlane.getNormal(), (double)angleEpsilon, (double)distanceEpsilon);
    }

    default public boolean isOnOrAbove(FramePoint3DReadOnly pointToTest) {
        return this.isOnOrAbove(pointToTest, 0.0);
    }

    default public boolean isOnOrAbove(FramePoint3DReadOnly pointToTest, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToTest);
        return this.isOnOrAbove(pointToTest.getX(), pointToTest.getY(), pointToTest.getZ(), epsilon);
    }

    default public boolean isOnOrBelow(FramePoint3DReadOnly pointToTest) {
        return this.isOnOrBelow(pointToTest, 0.0);
    }

    default public boolean isOnOrBelow(FramePoint3DReadOnly pointToTest, double epsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToTest);
        return this.isOnOrBelow(pointToTest.getX(), pointToTest.getY(), pointToTest.getZ(), epsilon);
    }

    default public boolean isParallel(FramePlane3DReadOnly otherPlane, double angleEpsilon) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)otherPlane);
        return EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)this.getNormal(), (Vector3DReadOnly)otherPlane.getNormal(), (double)angleEpsilon);
    }

    default public boolean orthogonalProjection(FramePoint3DBasics pointToProject) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject);
        return this.orthogonalProjection((FramePoint3DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint3DReadOnly pointToProject, FramePoint3DBasics projectionToPack) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)pointToProject, (ReferenceFrameHolder)projectionToPack);
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)this.getPoint(), (Vector3DReadOnly)this.getNormal(), (Point3DBasics)projectionToPack);
    }

    default public boolean epsilonEquals(EuclidFrameGeometry geometry, double epsilon) {
        super.epsilonEquals((EuclidGeometry)geometry, epsilon);
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof FramePlane3DReadOnly)) {
            return false;
        }
        FramePlane3DReadOnly other = (FramePlane3DReadOnly)geometry;
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return other.getNormal().epsilonEquals((EuclidFrameGeometry)this.getNormal(), epsilon) && other.getPoint().epsilonEquals((EuclidFrameGeometry)this.getPoint(), epsilon);
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof FramePlane3DReadOnly)) {
            return false;
        }
        FramePlane3DReadOnly other = (FramePlane3DReadOnly)geometry;
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return this.getPoint().equals((EuclidFrameGeometry)other.getPoint()) && this.getNormal().equals((EuclidFrameGeometry)other.getNormal());
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof FramePlane3DReadOnly)) {
            return false;
        }
        FramePlane3DReadOnly other = (FramePlane3DReadOnly)geometry;
        if (this.getReferenceFrame() != other.getReferenceFrame()) {
            return false;
        }
        return this.isCoincident(other, epsilon, epsilon);
    }
}

