/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.HashMap;
import java.util.Map;

public enum FrameNameRestrictionLevel {
    NONE,
    NAME_ID,
    FRAME_NAME;

    private static final Map<String, FrameNameRestrictionLevel> nameMap;

    public static FrameNameRestrictionLevel loadFromEnvironment(String propertyKey, String environmentVariableName, FrameNameRestrictionLevel defaultValue) {
        String stringValue;
        if (propertyKey != null && (stringValue = System.getProperty(propertyKey)) != null && nameMap.containsKey(stringValue)) {
            return nameMap.get(stringValue);
        }
        if (environmentVariableName != null && (stringValue = System.getenv(environmentVariableName)) != null && nameMap.containsKey(stringValue)) {
            return nameMap.get(stringValue);
        }
        return defaultValue;
    }

    static {
        nameMap = new HashMap<String, FrameNameRestrictionLevel>();
        for (FrameNameRestrictionLevel frameNameRestrictionLevel : FrameNameRestrictionLevel.values()) {
            nameMap.put(frameNameRestrictionLevel.name(), frameNameRestrictionLevel);
        }
    }
}

