/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Pose2DReferenceFrame
extends ReferenceFrame {
    private final FramePose2D originPose;

    public Pose2DReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        super(frameName, parentFrame);
        this.originPose = new FramePose2D(parentFrame);
    }

    public Pose2DReferenceFrame(String frameName, FramePose2DReadOnly poseInParentFrame) {
        this(frameName, poseInParentFrame.getReferenceFrame());
        this.setPoseAndUpdate(poseInParentFrame);
    }

    @Override
    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.originPose.get((RigidBodyTransformBasics)transformToParent);
    }

    public void setPoseAndUpdate(FramePose2DReadOnly pose) {
        pose.checkReferenceFrameMatch(this.getParent());
        this.setPoseAndUpdate((Pose2DReadOnly)pose);
    }

    public void setPositionAndUpdate(FramePoint2DReadOnly position) {
        position.checkReferenceFrameMatch(this.getParent());
        this.setPositionAndUpdate((Point2DReadOnly)position);
    }

    public void setOrientationAndUpdate(FrameOrientation2DReadOnly orientation) {
        orientation.checkReferenceFrameMatch(this.getParent());
        this.setOrientationAndUpdate((Orientation2DReadOnly)orientation);
    }

    public void setPoseAndUpdate(FramePoint2DReadOnly position, FrameOrientation2DReadOnly orientation) {
        position.checkReferenceFrameMatch(this.getParent());
        orientation.checkReferenceFrameMatch(this.getParent());
        this.setPoseAndUpdate((Point2DReadOnly)position, (Orientation2DReadOnly)orientation);
    }

    public void setPoseAndUpdate(Pose2DReadOnly pose) {
        this.setPoseAndUpdate(pose.getPosition(), pose.getOrientation());
    }

    public void setPoseAndUpdate(Point2DReadOnly position, Orientation2DReadOnly orientation) {
        this.setPoseAndUpdate(position, orientation.getYaw());
    }

    public void setPoseAndUpdate(Point2DReadOnly position, double orientation) {
        this.originPose.getPosition().set((Tuple2DReadOnly)position);
        this.originPose.getOrientation().setYaw(orientation);
        this.update();
    }

    public void setPositionAndUpdate(Point2DReadOnly position) {
        this.originPose.getPosition().set((Tuple2DReadOnly)position);
        this.update();
    }

    public void setOrientationAndUpdate(Orientation2DReadOnly orientation) {
        this.originPose.getOrientation().set(orientation);
        this.update();
    }

    @Override
    public String toString() {
        return super.toString() + ", originPose = " + String.valueOf(this.originPose);
    }
}

