/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface BoundingBox3DBasics
extends BoundingBox3DReadOnly,
Clearable {
    public Point3DBasics getMinPoint();

    public Point3DBasics getMaxPoint();

    @Override
    default public boolean containsNaN() {
        return BoundingBox3DReadOnly.super.containsNaN();
    }

    default public void setMin(Point3DReadOnly min) {
        this.getMinPoint().set((Tuple3DReadOnly)min);
        this.checkBounds();
    }

    default public void setMin(double[] min) {
        this.getMinPoint().set(min);
        this.checkBounds();
    }

    default public void setMin(double minX, double minY, double minZ) {
        this.getMinPoint().set(minX, minY, minZ);
        this.checkBounds();
    }

    default public void setMax(Point3DReadOnly max) {
        this.getMaxPoint().set((Tuple3DReadOnly)max);
        this.checkBounds();
    }

    default public void setMax(double[] max) {
        this.getMaxPoint().set(max);
        this.checkBounds();
    }

    default public void setMax(double maxX, double maxY, double maxZ) {
        this.getMaxPoint().set(maxX, maxY, maxZ);
        this.checkBounds();
    }

    default public void set(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.getMinPoint().set(minX, minY, minZ);
        this.getMaxPoint().set(maxX, maxY, maxZ);
        this.checkBounds();
    }

    default public void set(double[] min, double[] max) {
        this.getMinPoint().set(min);
        this.getMaxPoint().set(max);
        this.checkBounds();
    }

    default public void set(Point3DReadOnly min, Point3DReadOnly max) {
        this.getMinPoint().set((Tuple3DReadOnly)min);
        this.getMaxPoint().set((Tuple3DReadOnly)max);
        this.checkBounds();
    }

    default public void set(Point3DReadOnly center, Vector3DReadOnly halfSize) {
        this.getMinPoint().sub((Tuple3DReadOnly)center, (Tuple3DReadOnly)halfSize);
        this.getMaxPoint().add((Tuple3DReadOnly)center, (Tuple3DReadOnly)halfSize);
        this.checkBounds();
    }

    default public void set(BoundingBox3DReadOnly other) {
        this.getMinPoint().set((Tuple3DReadOnly)other.getMinPoint());
        this.getMaxPoint().set((Tuple3DReadOnly)other.getMaxPoint());
    }

    default public void combine(BoundingBox3DReadOnly other) {
        this.combine(this, other);
    }

    default public void combine(BoundingBox3DReadOnly boundingBoxOne, BoundingBox3DReadOnly boundingBoxTwo) {
        double minX = Double.isNaN(boundingBoxOne.getMinX()) ? boundingBoxTwo.getMinX() : (Double.isNaN(boundingBoxTwo.getMinX()) ? boundingBoxOne.getMinX() : Math.min(boundingBoxOne.getMinX(), boundingBoxTwo.getMinX()));
        double minY = Double.isNaN(boundingBoxOne.getMinY()) ? boundingBoxTwo.getMinY() : (Double.isNaN(boundingBoxTwo.getMinY()) ? boundingBoxOne.getMinY() : Math.min(boundingBoxOne.getMinY(), boundingBoxTwo.getMinY()));
        double minZ = Double.isNaN(boundingBoxOne.getMinZ()) ? boundingBoxTwo.getMinZ() : (Double.isNaN(boundingBoxTwo.getMinZ()) ? boundingBoxOne.getMinZ() : Math.min(boundingBoxOne.getMinZ(), boundingBoxTwo.getMinZ()));
        double maxX = Double.isNaN(boundingBoxOne.getMaxX()) ? boundingBoxTwo.getMaxX() : (Double.isNaN(boundingBoxTwo.getMaxX()) ? boundingBoxOne.getMaxX() : Math.max(boundingBoxOne.getMaxX(), boundingBoxTwo.getMaxX()));
        double maxY = Double.isNaN(boundingBoxOne.getMaxY()) ? boundingBoxTwo.getMaxY() : (Double.isNaN(boundingBoxTwo.getMaxY()) ? boundingBoxOne.getMaxY() : Math.max(boundingBoxOne.getMaxY(), boundingBoxTwo.getMaxY()));
        double maxZ = Double.isNaN(boundingBoxOne.getMaxZ()) ? boundingBoxTwo.getMaxZ() : (Double.isNaN(boundingBoxTwo.getMaxZ()) ? boundingBoxOne.getMaxZ() : Math.max(boundingBoxOne.getMaxZ(), boundingBoxTwo.getMaxZ()));
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public void setToNaN() {
        this.getMinPoint().setToNaN();
        this.getMaxPoint().setToNaN();
    }

    default public void setToZero() {
        this.getMinPoint().setToZero();
        this.getMaxPoint().setToZero();
    }

    default public void updateToIncludePoints(Vertex3DSupplier vertex3DSupplier) {
        for (int index = 0; index < vertex3DSupplier.getNumberOfVertices(); ++index) {
            this.updateToIncludePoint(vertex3DSupplier.getVertex(index));
        }
    }

    default public void updateToIncludePoint(Point3DReadOnly point) {
        this.updateToIncludePoint(point.getX(), point.getY(), point.getZ());
    }

    default public void updateToIncludePoint(double x, double y, double z) {
        if (Double.isNaN(this.getMinX()) || x < this.getMinX()) {
            this.getMinPoint().setX(x);
        }
        if (Double.isNaN(this.getMinY()) || y < this.getMinY()) {
            this.getMinPoint().setY(y);
        }
        if (Double.isNaN(this.getMinZ()) || z < this.getMinZ()) {
            this.getMinPoint().setZ(z);
        }
        if (Double.isNaN(this.getMaxX()) || x > this.getMaxX()) {
            this.getMaxPoint().setX(x);
        }
        if (Double.isNaN(this.getMaxY()) || y > this.getMaxY()) {
            this.getMaxPoint().setY(y);
        }
        if (Double.isNaN(this.getMaxZ()) || z > this.getMaxZ()) {
            this.getMaxPoint().setZ(z);
        }
    }
}

