/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class QuaternionTools {
    static final double EPS = 1.0E-12;

    private QuaternionTools() {
    }

    public static boolean isNeutralQuaternion(QuaternionReadOnly quaternion, double epsilon) {
        return QuaternionTools.isNeutralQuaternion(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getS(), epsilon);
    }

    public static boolean isNeutralQuaternion(QuaternionReadOnly quaternion, double epsilon, boolean limitToPi) {
        return QuaternionTools.isNeutralQuaternion(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getS(), epsilon, limitToPi);
    }

    public static boolean isNeutralQuaternion(double qx, double qy, double qz, double qs, double epsilon) {
        return QuaternionTools.isNeutralQuaternion(qx, qy, qz, qs, epsilon, false);
    }

    public static boolean isNeutralQuaternion(double qx, double qy, double qz, double qs, double epsilon, boolean limitToPi) {
        if (limitToPi) {
            qs = Math.abs(qs);
        }
        return EuclidCoreTools.epsilonEquals(1.0, qs, epsilon) && Math.abs(qx) <= epsilon && Math.abs(qy) <= epsilon && Math.abs(qz) <= epsilon;
    }

    public static void multiply(QuaternionReadOnly q1, QuaternionReadOnly q2, QuaternionBasics quaternionToPack) {
        QuaternionTools.multiplyImpl(q1, false, q2, false, quaternionToPack);
    }

    public static void multiplyConjugateLeft(QuaternionReadOnly q1, QuaternionReadOnly q2, QuaternionBasics quaternionToPack) {
        QuaternionTools.multiplyImpl(q1, true, q2, false, quaternionToPack);
    }

    public static void multiplyConjugateRight(QuaternionReadOnly q1, QuaternionReadOnly q2, QuaternionBasics quaternionToPack) {
        QuaternionTools.multiplyImpl(q1, false, q2, true, quaternionToPack);
    }

    public static void multiplyConjugateBoth(QuaternionReadOnly q1, QuaternionReadOnly q2, QuaternionBasics quaternionToPack) {
        QuaternionTools.multiplyImpl(q1, true, q2, true, quaternionToPack);
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, QuaternionBasics quaternionToPack) {
        double q2s;
        double q2z;
        double q2y;
        double q2x;
        if (orientation1 instanceof QuaternionReadOnly) {
            QuaternionTools.multiply((QuaternionReadOnly)orientation1, inverse1, orientation2, inverse2, quaternionToPack);
            return;
        }
        if (orientation2 instanceof QuaternionReadOnly) {
            QuaternionReadOnly q2 = (QuaternionReadOnly)orientation2;
            q2x = q2.getX();
            q2y = q2.getY();
            q2z = q2.getZ();
            q2s = q2.getS();
        } else {
            quaternionToPack.set(orientation2);
            q2x = quaternionToPack.getX();
            q2y = quaternionToPack.getY();
            q2z = quaternionToPack.getZ();
            q2s = quaternionToPack.getS();
        }
        quaternionToPack.set(orientation1);
        double q1x = quaternionToPack.getX();
        double q1y = quaternionToPack.getY();
        double q1z = quaternionToPack.getZ();
        double q1s = quaternionToPack.getS();
        QuaternionTools.multiplyImpl(q1x, q1y, q1z, q1s, inverse1, q2x, q2y, q2z, q2s, inverse2, quaternionToPack);
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, QuaternionReadOnly orientation2, boolean inverse2, QuaternionBasics quaternionToPack) {
        if (orientation1 instanceof QuaternionReadOnly) {
            QuaternionTools.multiplyImpl((QuaternionReadOnly)orientation1, inverse1, orientation2, inverse2, quaternionToPack);
            return;
        }
        double q2x = orientation2.getX();
        double q2y = orientation2.getY();
        double q2z = orientation2.getZ();
        double q2s = orientation2.getS();
        quaternionToPack.set(orientation1);
        double q1x = quaternionToPack.getX();
        double q1y = quaternionToPack.getY();
        double q1z = quaternionToPack.getZ();
        double q1s = quaternionToPack.getS();
        QuaternionTools.multiplyImpl(q1x, q1y, q1z, q1s, inverse1, q2x, q2y, q2z, q2s, inverse2, quaternionToPack);
    }

    public static void multiply(QuaternionReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, QuaternionBasics quaternionToPack) {
        if (orientation2 instanceof QuaternionReadOnly) {
            QuaternionTools.multiplyImpl(orientation1, inverse1, (QuaternionReadOnly)orientation2, inverse2, quaternionToPack);
            return;
        }
        double q1x = orientation1.getX();
        double q1y = orientation1.getY();
        double q1z = orientation1.getZ();
        double q1s = orientation1.getS();
        quaternionToPack.set(orientation2);
        double q2x = quaternionToPack.getX();
        double q2y = quaternionToPack.getY();
        double q2z = quaternionToPack.getZ();
        double q2s = quaternionToPack.getS();
        QuaternionTools.multiplyImpl(q1x, q1y, q1z, q1s, inverse1, q2x, q2y, q2z, q2s, inverse2, quaternionToPack);
    }

    private static void multiplyImpl(QuaternionReadOnly q1, boolean conjugateQ1, QuaternionReadOnly q2, boolean conjugateQ2, QuaternionBasics quaternionToPack) {
        QuaternionTools.multiplyImpl(q1.getX(), q1.getY(), q1.getZ(), q1.getS(), conjugateQ1, q2.getX(), q2.getY(), q2.getZ(), q2.getS(), conjugateQ2, quaternionToPack);
    }

    public static void multiplyImpl(double q1x, double q1y, double q1z, double q1s, boolean conjugateQ1, double q2x, double q2y, double q2z, double q2s, boolean conjugateQ2, Orientation3DBasics orientationToPack) {
        if (conjugateQ1) {
            q1x = -q1x;
            q1y = -q1y;
            q1z = -q1z;
        }
        if (conjugateQ2) {
            q2x = -q2x;
            q2y = -q2y;
            q2z = -q2z;
        }
        double x = q1s * q2x + q1x * q2s + q1y * q2z - q1z * q2y;
        double y = q1s * q2y - q1x * q2z + q1y * q2s + q1z * q2x;
        double z = q1s * q2z + q1x * q2y - q1y * q2x + q1z * q2s;
        double s = q1s * q2s - q1x * q2x - q1y * q2y - q1z * q2z;
        orientationToPack.setQuaternion(x, y, z, s);
    }

    public static void multiply(Tuple4DReadOnly t1, Tuple4DReadOnly t2, Vector4DBasics vectorToPack) {
        QuaternionTools.multiplyImpl(t1, false, t2, false, vectorToPack);
    }

    public static void multiplyConjugateLeft(Tuple4DReadOnly t1, Tuple4DReadOnly t2, Vector4DBasics vectorToPack) {
        QuaternionTools.multiplyImpl(t1, true, t2, false, vectorToPack);
    }

    public static void multiplyConjugateRight(Tuple4DReadOnly t1, Tuple4DReadOnly t2, Vector4DBasics vectorToPack) {
        QuaternionTools.multiplyImpl(t1, false, t2, true, vectorToPack);
    }

    private static void multiplyImpl(Tuple4DReadOnly t1, boolean conjugateT1, Tuple4DReadOnly t2, boolean conjugateT2, Vector4DBasics vectorToPack) {
        QuaternionTools.multiplyImpl(t1.getX(), t1.getY(), t1.getZ(), t1.getS(), conjugateT1, t2.getX(), t2.getY(), t2.getZ(), t2.getS(), conjugateT2, vectorToPack);
    }

    public static void multiplyImpl(double x1, double y1, double z1, double s1, boolean conjugateT1, double x2, double y2, double z2, double s2, boolean conjugateT2, Vector4DBasics vectorToPack) {
        if (conjugateT1) {
            x1 = -x1;
            y1 = -y1;
            z1 = -z1;
        }
        if (conjugateT2) {
            x2 = -x2;
            y2 = -y2;
            z2 = -z2;
        }
        double x = s1 * x2 + x1 * s2 + y1 * z2 - z1 * y2;
        double y = s1 * y2 - x1 * z2 + y1 * s2 + z1 * x2;
        double z = s1 * z2 + x1 * y2 - y1 * x2 + z1 * s2;
        double s = s1 * s2 - x1 * x2 - y1 * y2 - z1 * z2;
        vectorToPack.set(x, y, z, s);
    }

    public static void transform(QuaternionReadOnly quaternion, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.transformImpl(quaternion, false, tupleOriginal, tupleTransformed);
    }

    public static void inverseTransform(QuaternionReadOnly quaternion, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.transformImpl(quaternion, true, tupleOriginal, tupleTransformed);
    }

    private static void transformImpl(QuaternionReadOnly quaternion, boolean conjugateQuaternion, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double norm;
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        if (conjugateQuaternion) {
            qx = -qx;
            qy = -qy;
            qz = -qz;
        }
        if ((norm = quaternion.norm()) < 1.0E-12) {
            tupleTransformed.set(tupleOriginal);
            return;
        }
        norm = 1.0 / norm;
        qx *= norm;
        qs *= norm;
        double x = tupleOriginal.getX();
        double y = tupleOriginal.getY();
        double z = tupleOriginal.getZ();
        double crossX = 2.0 * ((qy *= norm) * z - (qz *= norm) * y);
        double crossY = 2.0 * (qz * x - qx * z);
        double crossZ = 2.0 * (qx * y - qy * x);
        double crossCrossX = qy * crossZ - qz * crossY;
        double crossCrossY = qz * crossX - qx * crossZ;
        double crossCrossZ = qx * crossY - qy * crossX;
        tupleTransformed.set(x + qs * crossX + crossCrossX, y + qs * crossY + crossCrossY, z + qs * crossZ + crossCrossZ);
    }

    public static void addTransform(QuaternionReadOnly quaternion, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.addTransform(false, quaternion, false, tupleOriginal, tupleTransformed);
    }

    public static void subTransform(QuaternionReadOnly quaternion, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.addTransform(true, quaternion, false, tupleOriginal, tupleTransformed);
    }

    private static void addTransform(boolean subtract, QuaternionReadOnly quaternion, boolean conjugateQuaternion, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double norm;
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        if (conjugateQuaternion) {
            qx = -qx;
            qy = -qy;
            qz = -qz;
        }
        if ((norm = quaternion.norm()) < 1.0E-12) {
            return;
        }
        norm = 1.0 / norm;
        qx *= norm;
        qs *= norm;
        double x = tupleOriginal.getX();
        double y = tupleOriginal.getY();
        double z = tupleOriginal.getZ();
        double crossX = 2.0 * ((qy *= norm) * z - (qz *= norm) * y);
        double crossY = 2.0 * (qz * x - qx * z);
        double crossZ = 2.0 * (qx * y - qy * x);
        double crossCrossX = qy * crossZ - qz * crossY;
        double crossCrossY = qz * crossX - qx * crossZ;
        double crossCrossZ = qx * crossY - qy * crossX;
        x = x + qs * crossX + crossCrossX;
        y = y + qs * crossY + crossCrossY;
        z = z + qs * crossZ + crossCrossZ;
        if (subtract) {
            tupleTransformed.sub(x, y, z);
        } else {
            tupleTransformed.add(x, y, z);
        }
    }

    public static void transform(QuaternionReadOnly quaternion, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        QuaternionTools.transformImpl(quaternion, false, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    public static void inverseTransform(QuaternionReadOnly quaternion, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        QuaternionTools.transformImpl(quaternion, true, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    private static void transformImpl(QuaternionReadOnly quaternion, boolean conjugateQuaternion, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        double norm;
        if (checkIfTransformInXYPlane) {
            quaternion.checkIfOrientation2D(1.0E-12);
        }
        if ((norm = quaternion.norm()) < 1.0E-12) {
            tupleTransformed.set(tupleOriginal);
            return;
        }
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        if (conjugateQuaternion) {
            qz = -qz;
        }
        norm = 1.0 / norm;
        qs *= norm;
        double x = tupleOriginal.getX();
        double y = tupleOriginal.getY();
        double crossX = -2.0 * (qz *= norm) * y;
        double crossY = 2.0 * qz * x;
        double crossCrossX = -qz * crossY;
        double crossCrossY = qz * crossX;
        tupleTransformed.set(x + qs * crossX + crossCrossX, y + qs * crossY + crossCrossY);
    }

    public static void transform(QuaternionReadOnly quaternion, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionTransformed) {
        QuaternionTools.multiplyImpl(quaternion, false, quaternionOriginal, false, quaternionTransformed);
    }

    public static void inverseTransform(QuaternionReadOnly quaternion, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionTransformed) {
        QuaternionTools.multiplyImpl(quaternion, true, quaternionOriginal, false, quaternionTransformed);
    }

    public static void transform(QuaternionReadOnly quaternion, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        QuaternionTools.transformImpl(quaternion, false, vectorOriginal, vectorTransformed);
    }

    public static void inverseTransform(QuaternionReadOnly quaternion, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        QuaternionTools.transformImpl(quaternion, true, vectorOriginal, vectorTransformed);
    }

    private static void transformImpl(QuaternionReadOnly quaternion, boolean conjugateQuaternion, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        double norm = quaternion.norm();
        if (norm < 1.0E-12) {
            vectorTransformed.set(vectorOriginal);
            return;
        }
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        if (conjugateQuaternion) {
            qx = -qx;
            qy = -qy;
            qz = -qz;
        }
        norm = 1.0 / norm;
        qx *= norm;
        qs *= norm;
        double x = vectorOriginal.getX();
        double y = vectorOriginal.getY();
        double z = vectorOriginal.getZ();
        double crossX = 2.0 * ((qy *= norm) * z - (qz *= norm) * y);
        double crossY = 2.0 * (qz * x - qx * z);
        double crossZ = 2.0 * (qx * y - qy * x);
        double crossCrossX = qy * crossZ - qz * crossY;
        double crossCrossY = qz * crossX - qx * crossZ;
        double crossCrossZ = qx * crossY - qy * crossX;
        vectorTransformed.set(x + qs * crossX + crossCrossX, y + qs * crossY + crossCrossY, z + qs * crossZ + crossCrossZ, vectorOriginal.getS());
    }

    public static void transform(QuaternionReadOnly quaternion, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        QuaternionTools.transformImpl(quaternion, false, matrixOriginal, matrixTransformed);
    }

    public static void inverseTransform(QuaternionReadOnly quaternion, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        QuaternionTools.transformImpl(quaternion, true, matrixOriginal, matrixTransformed);
    }

    private static void transformImpl(QuaternionReadOnly quaternion, boolean conjugateQuaternion, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        QuaternionTools.transformImpl(qx, qy, qz, qs, conjugateQuaternion, matrixOriginal, matrixTransformed);
    }

    static void transformImpl(double qx, double qy, double qz, double qs, boolean conjugateQuaternion, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        double norm = EuclidCoreTools.fastNorm(qx, qy, qz, qs);
        if (norm < 1.0E-12) {
            matrixTransformed.set(matrixOriginal);
            return;
        }
        if (conjugateQuaternion) {
            qx = -qx;
            qy = -qy;
            qz = -qz;
        }
        norm = 1.0 / norm;
        double yy2 = 2.0 * (qy *= norm) * qy;
        double zz2 = 2.0 * (qz *= norm) * qz;
        double xx2 = 2.0 * (qx *= norm) * qx;
        double xy2 = 2.0 * qx * qy;
        double sz2 = 2.0 * (qs *= norm) * qz;
        double xz2 = 2.0 * qx * qz;
        double sy2 = 2.0 * qs * qy;
        double yz2 = 2.0 * qy * qz;
        double sx2 = 2.0 * qs * qx;
        double q00 = 1.0 - yy2 - zz2;
        double q01 = xy2 - sz2;
        double q02 = xz2 + sy2;
        double q10 = xy2 + sz2;
        double q11 = 1.0 - xx2 - zz2;
        double q12 = yz2 - sx2;
        double q20 = xz2 - sy2;
        double q21 = yz2 + sx2;
        double q22 = 1.0 - xx2 - yy2;
        double qM00 = q00 * matrixOriginal.getM00() + q01 * matrixOriginal.getM10() + q02 * matrixOriginal.getM20();
        double qM01 = q00 * matrixOriginal.getM01() + q01 * matrixOriginal.getM11() + q02 * matrixOriginal.getM21();
        double qM02 = q00 * matrixOriginal.getM02() + q01 * matrixOriginal.getM12() + q02 * matrixOriginal.getM22();
        double qM10 = q10 * matrixOriginal.getM00() + q11 * matrixOriginal.getM10() + q12 * matrixOriginal.getM20();
        double qM11 = q10 * matrixOriginal.getM01() + q11 * matrixOriginal.getM11() + q12 * matrixOriginal.getM21();
        double qM12 = q10 * matrixOriginal.getM02() + q11 * matrixOriginal.getM12() + q12 * matrixOriginal.getM22();
        double qM20 = q20 * matrixOriginal.getM00() + q21 * matrixOriginal.getM10() + q22 * matrixOriginal.getM20();
        double qM21 = q20 * matrixOriginal.getM01() + q21 * matrixOriginal.getM11() + q22 * matrixOriginal.getM21();
        double qM22 = q20 * matrixOriginal.getM02() + q21 * matrixOriginal.getM12() + q22 * matrixOriginal.getM22();
        double qMqt00 = qM00 * q00 + qM01 * q01 + qM02 * q02;
        double qMqt01 = qM00 * q10 + qM01 * q11 + qM02 * q12;
        double qMqt02 = qM00 * q20 + qM01 * q21 + qM02 * q22;
        double qMqt10 = qM10 * q00 + qM11 * q01 + qM12 * q02;
        double qMqt11 = qM10 * q10 + qM11 * q11 + qM12 * q12;
        double qMqt12 = qM10 * q20 + qM11 * q21 + qM12 * q22;
        double qMqt20 = qM20 * q00 + qM21 * q01 + qM22 * q02;
        double qMqt21 = qM20 * q10 + qM21 * q11 + qM22 * q12;
        double qMqt22 = qM20 * q20 + qM21 * q21 + qM22 * q22;
        matrixTransformed.set(qMqt00, qMqt01, qMqt02, qMqt10, qMqt11, qMqt12, qMqt20, qMqt21, qMqt22);
    }

    public static void transform(QuaternionReadOnly quaternion, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        RotationMatrixTools.multiply((Orientation3DReadOnly)quaternion, false, rotationMatrixOriginal, false, (CommonMatrix3DBasics)rotationMatrixTransformed);
    }

    public static void inverseTransform(QuaternionReadOnly quaternion, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        RotationMatrixTools.multiply((Orientation3DReadOnly)quaternion, true, rotationMatrixOriginal, false, (CommonMatrix3DBasics)rotationMatrixTransformed);
    }

    public static void prependYawRotation(double yaw, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionToPack) {
        double qx = quaternionOriginal.getX();
        double qy = quaternionOriginal.getY();
        double qz = quaternionOriginal.getZ();
        double qs = quaternionOriginal.getS();
        double halfYaw = 0.5 * yaw;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double x = cYaw * qx - sYaw * qy;
        double y = cYaw * qy + sYaw * qx;
        double z = cYaw * qz + sYaw * qs;
        double s = cYaw * qs - sYaw * qz;
        quaternionToPack.setUnsafe(x, y, z, s);
    }

    public static void appendYawRotation(QuaternionReadOnly quaternionOriginal, double yaw, QuaternionBasics quaternionToPack) {
        double qx = quaternionOriginal.getX();
        double qy = quaternionOriginal.getY();
        double qz = quaternionOriginal.getZ();
        double qs = quaternionOriginal.getS();
        double halfYaw = 0.5 * yaw;
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double x = qx * cYaw + qy * sYaw;
        double y = -qx * sYaw + qy * cYaw;
        double z = qs * sYaw + qz * cYaw;
        double s = qs * cYaw - qz * sYaw;
        quaternionToPack.setUnsafe(x, y, z, s);
    }

    public static void prependPitchRotation(double pitch, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionToPack) {
        double qx = quaternionOriginal.getX();
        double qy = quaternionOriginal.getY();
        double qz = quaternionOriginal.getZ();
        double qs = quaternionOriginal.getS();
        double halfPitch = 0.5 * pitch;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double x = cPitch * qx + sPitch * qz;
        double y = cPitch * qy + sPitch * qs;
        double z = cPitch * qz - sPitch * qx;
        double s = cPitch * qs - sPitch * qy;
        quaternionToPack.setUnsafe(x, y, z, s);
    }

    public static void appendPitchRotation(QuaternionReadOnly quaternionOriginal, double pitch, QuaternionBasics quaternionToPack) {
        double qx = quaternionOriginal.getX();
        double qy = quaternionOriginal.getY();
        double qz = quaternionOriginal.getZ();
        double qs = quaternionOriginal.getS();
        double halfPitch = 0.5 * pitch;
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double x = qx * cPitch - qz * sPitch;
        double y = qs * sPitch + qy * cPitch;
        double z = qx * sPitch + qz * cPitch;
        double s = qs * cPitch - qy * sPitch;
        quaternionToPack.setUnsafe(x, y, z, s);
    }

    public static void prependRollRotation(double roll, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionToPack) {
        double qx = quaternionOriginal.getX();
        double qy = quaternionOriginal.getY();
        double qz = quaternionOriginal.getZ();
        double qs = quaternionOriginal.getS();
        double halfRoll = 0.5 * roll;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double x = cRoll * qx + sRoll * qs;
        double y = cRoll * qy - sRoll * qz;
        double z = cRoll * qz + sRoll * qy;
        double s = cRoll * qs - sRoll * qx;
        quaternionToPack.setUnsafe(x, y, z, s);
    }

    public static void appendRollRotation(QuaternionReadOnly quaternionOriginal, double roll, QuaternionBasics quaternionToPack) {
        double qx = quaternionOriginal.getX();
        double qy = quaternionOriginal.getY();
        double qz = quaternionOriginal.getZ();
        double qs = quaternionOriginal.getS();
        double halfRoll = 0.5 * roll;
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double x = qs * sRoll + qx * cRoll;
        double y = qy * cRoll + qz * sRoll;
        double z = -qy * sRoll + qz * cRoll;
        double s = qs * cRoll - qx * sRoll;
        quaternionToPack.setUnsafe(x, y, z, s);
    }

    public static double distance(QuaternionReadOnly quaternion, Orientation3DReadOnly orientation3D, boolean limitToPi) {
        if (orientation3D instanceof QuaternionReadOnly) {
            return QuaternionTools.distance(quaternion, (QuaternionReadOnly)orientation3D, limitToPi);
        }
        if (orientation3D instanceof YawPitchRollReadOnly) {
            return QuaternionTools.distance(quaternion, (YawPitchRollReadOnly)orientation3D, limitToPi);
        }
        if (orientation3D instanceof AxisAngleReadOnly) {
            return QuaternionTools.distance(quaternion, (AxisAngleReadOnly)orientation3D, limitToPi);
        }
        if (orientation3D instanceof RotationMatrixReadOnly) {
            return QuaternionTools.distance(quaternion, (RotationMatrixReadOnly)orientation3D);
        }
        throw new UnsupportedOperationException("Unsupported type: " + orientation3D.getClass().getSimpleName());
    }

    public static double distance(QuaternionReadOnly q1, QuaternionReadOnly q2, boolean limitToPi) {
        if (q1 == q2) {
            return 0.0;
        }
        return QuaternionTools.distance(q1.getX(), q1.getY(), q1.getZ(), q1.getS(), q2.getX(), q2.getY(), q2.getZ(), q2.getS(), limitToPi);
    }

    static double distance(double q1x, double q1y, double q1z, double q1s, double q2x, double q2y, double q2z, double q2s, boolean limitToPi) {
        double x = q1s * q2x - q1x * q2s - q1y * q2z + q1z * q2y;
        double y = q1s * q2y + q1x * q2z - q1y * q2s - q1z * q2x;
        double z = q1s * q2z - q1x * q2y + q1y * q2x - q1z * q2s;
        double s = q1s * q2s + q1x * q2x + q1y * q2y + q1z * q2z;
        return QuaternionTools.angle(x, y, z, s, limitToPi);
    }

    public static double distance(QuaternionReadOnly quaternion, RotationMatrixReadOnly rotationMatrix) {
        if (quaternion.containsNaN() || rotationMatrix.containsNaN()) {
            return Double.NaN;
        }
        if (quaternion.isZeroOrientation(1.0E-12)) {
            return RotationMatrixTools.angle(rotationMatrix);
        }
        if (rotationMatrix.isZeroOrientation(1.0E-12)) {
            return QuaternionTools.angle(quaternion);
        }
        double qs = quaternion.getS();
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double yy2 = 2.0 * qy * qy;
        double zz2 = 2.0 * qz * qz;
        double xx2 = 2.0 * qx * qx;
        double xy2 = 2.0 * qx * qy;
        double sz2 = 2.0 * qs * qz;
        double xz2 = 2.0 * qx * qz;
        double sy2 = 2.0 * qs * qy;
        double yz2 = 2.0 * qy * qz;
        double sx2 = 2.0 * qs * qx;
        double q00 = 1.0 - yy2 - zz2;
        double q01 = xy2 - sz2;
        double q02 = xz2 + sy2;
        double q10 = xy2 + sz2;
        double q11 = 1.0 - xx2 - zz2;
        double q12 = yz2 - sx2;
        double q20 = xz2 - sy2;
        double q21 = yz2 + sx2;
        double q22 = 1.0 - xx2 - yy2;
        return RotationMatrixTools.distance(rotationMatrix, q00, q01, q02, q10, q11, q12, q20, q21, q22);
    }

    public static double distance(QuaternionReadOnly quaternion, YawPitchRollReadOnly yawPitchRoll, boolean limitToPi) {
        if (quaternion.containsNaN() || yawPitchRoll.containsNaN()) {
            return Double.NaN;
        }
        if (quaternion.isZeroOrientation(1.0E-12)) {
            return YawPitchRollTools.angle(yawPitchRoll);
        }
        if (yawPitchRoll.isZeroOrientation(1.0E-12)) {
            return QuaternionTools.angle(quaternion);
        }
        double halfYaw = 0.5 * yawPitchRoll.getYaw();
        double cYaw = EuclidCoreTools.cos(halfYaw);
        double sYaw = EuclidCoreTools.sin(halfYaw);
        double halfPitch = 0.5 * yawPitchRoll.getPitch();
        double cPitch = EuclidCoreTools.cos(halfPitch);
        double sPitch = EuclidCoreTools.sin(halfPitch);
        double halfRoll = 0.5 * yawPitchRoll.getRoll();
        double cRoll = EuclidCoreTools.cos(halfRoll);
        double sRoll = EuclidCoreTools.sin(halfRoll);
        double qs = cYaw * cPitch * cRoll + sYaw * sPitch * sRoll;
        double qx = cYaw * cPitch * sRoll - sYaw * sPitch * cRoll;
        double qy = sYaw * cPitch * sRoll + cYaw * sPitch * cRoll;
        double qz = sYaw * cPitch * cRoll - cYaw * sPitch * sRoll;
        return QuaternionTools.distance(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getS(), qx, qy, qz, qs, limitToPi);
    }

    public static double distance(QuaternionReadOnly quaternion, AxisAngleReadOnly axisAngle, boolean limitToPi) {
        return AxisAngleTools.distance(axisAngle, quaternion, limitToPi);
    }

    public static double angle(QuaternionReadOnly quaternion, boolean limitToPi) {
        return QuaternionTools.angle(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getS(), limitToPi);
    }

    public static double angle(QuaternionReadOnly quaternion) {
        return QuaternionTools.angle(quaternion, false);
    }

    static double angle(double qx, double qy, double qz, double qs, boolean limitToPi) {
        if (limitToPi && qs < 0.0) {
            qx = -qx;
            qy = -qy;
            qz = -qz;
            qs = -qs;
        }
        double sinHalfTheta = EuclidCoreTools.norm(qx, qy, qz);
        if (EuclidCoreTools.epsilonEquals(1.0, qs, 1.0E-12)) {
            return 2.0 * sinHalfTheta / qs;
        }
        return 2.0 * EuclidCoreTools.atan2(sinHalfTheta, qs);
    }

    public static void interpolate(QuaternionReadOnly q0, QuaternionReadOnly qf, double alpha, QuaternionBasics interpolationToPack) {
        double q0x = q0.getX();
        double q0y = q0.getY();
        double q0z = q0.getZ();
        double q0s = q0.getS();
        double qfx = qf.getX();
        double qfy = qf.getY();
        double qfz = qf.getZ();
        double qfs = qf.getS();
        QuaternionTools.interpolate(q0x, q0y, q0z, q0s, qfx, qfy, qfz, qfs, alpha, interpolationToPack);
    }

    private static void interpolate(double q0x, double q0y, double q0z, double q0s, double qfx, double qfy, double qfz, double qfs, double alpha, QuaternionBasics interpolationToPack) {
        double cosHalfTheta = q0x * qfx + q0y * qfy + q0z * qfz + q0s * qfs;
        if (cosHalfTheta < 0.0) {
            qfx = -qfx;
            qfy = -qfy;
            qfz = -qfz;
            qfs = -qfs;
            cosHalfTheta = -cosHalfTheta;
        }
        double alpha0 = 1.0 - alpha;
        double alphaf = alpha;
        if (1.0 - cosHalfTheta > 1.0E-12) {
            double sinHalfTheta = EuclidCoreTools.squareRoot(1.0 - cosHalfTheta * cosHalfTheta);
            double halfTheta = EuclidCoreTools.atan2(sinHalfTheta, cosHalfTheta);
            alpha0 = EuclidCoreTools.sin(alpha0 * halfTheta) / sinHalfTheta;
            alphaf = EuclidCoreTools.sin(alphaf * halfTheta) / sinHalfTheta;
        }
        double qx = alpha0 * q0x + alphaf * qfx;
        double qy = alpha0 * q0y + alphaf * qfy;
        double qz = alpha0 * q0z + alphaf * qfz;
        double qs = alpha0 * q0s + alphaf * qfs;
        interpolationToPack.set(qx, qy, qz, qs);
    }
}

