/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import java.util.ArrayList;
import java.util.Arrays;
import us.ihmc.avatar.AvatarControllerThreadInterface;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextTools;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.corruptors.FullRobotModelCorruptor;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.ControllerCrashLocation;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.robotController.ModularRobotController;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusChangedListener;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.wholeBodyController.DRCOutputProcessor;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class AvatarControllerThread
implements AvatarControllerThreadInterface {
    private static final boolean CREATE_DYNAMICALLY_CONSISTENT_NULLSPACE_EVALUATOR = false;
    private static final boolean SHOW_INERTIA_GRAPHICS = false;
    private static final boolean SHOW_REFERENCE_FRAMES = false;
    private static final boolean SHOW_JOINTAXIS_ZALIGN_FRAMES = false;
    private static final boolean CREATE_COM_CALIBRATION_TOOL = false;
    private static final boolean ALLOW_MODEL_CORRUPTION = false;
    private final YoRegistry registry = new YoRegistry("DRCControllerThread");
    private final YoDouble controllerTime = new YoDouble("ControllerTime", this.registry);
    private final YoLong timestampOffset = new YoLong("TimestampOffsetController", this.registry);
    private final YoLong timestamp = new YoLong("TimestampController", this.registry);
    private final YoBoolean firstTick = new YoBoolean("FirstTick", this.registry);
    private final YoBoolean runController = new YoBoolean("RunController", this.registry);
    private final FullHumanoidRobotModel controllerFullRobotModel;
    private final FullRobotModelCorruptor fullRobotModelCorruptor;
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private final ModularRobotController robotController;
    private final IHMCRealtimeROS2Publisher<ControllerCrashNotificationPacket> crashNotificationPublisher;
    private final HumanoidRobotContextData humanoidRobotContextData;

    public AvatarControllerThread(String robotName, DRCRobotModel robotModel, DRCRobotInitialSetup robotInitialSetup, HumanoidRobotSensorInformation sensorInformation, HighLevelHumanoidControllerFactory controllerFactory, HumanoidRobotContextDataFactory contextDataFactory, DRCOutputProcessor outputProcessor, RealtimeROS2Node realtimeROS2Node, double gravity, double estimatorDT) {
        this.controllerFullRobotModel = robotModel.createFullRobotModel();
        if (robotInitialSetup != null) {
            robotInitialSetup.initializeFullRobotModel(this.controllerFullRobotModel);
        }
        HumanoidRobotContextJointData processedJointData = new HumanoidRobotContextJointData(this.controllerFullRobotModel.getOneDoFJoints().length);
        ForceSensorDataHolder forceSensorDataHolderForController = new ForceSensorDataHolder(Arrays.asList(this.controllerFullRobotModel.getForceSensorDefinitions()));
        CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator = new CenterOfPressureDataHolder(this.controllerFullRobotModel);
        LowLevelOneDoFJointDesiredDataHolder desiredJointDataHolder = new LowLevelOneDoFJointDesiredDataHolder((OneDoFJointReadOnly[])this.controllerFullRobotModel.getControllableOneDoFJoints());
        RobotMotionStatusHolder robotMotionStatusHolder = new RobotMotionStatusHolder();
        contextDataFactory.setForceSensorDataHolder(forceSensorDataHolderForController);
        contextDataFactory.setCenterOfPressureDataHolder(centerOfPressureDataHolderForEstimator);
        contextDataFactory.setRobotMotionStatusHolder(robotMotionStatusHolder);
        contextDataFactory.setJointDesiredOutputList(desiredJointDataHolder);
        contextDataFactory.setProcessedJointData(processedJointData);
        contextDataFactory.setSensorDataContext(new SensorDataContext((FullRobotModel)this.controllerFullRobotModel));
        this.humanoidRobotContextData = contextDataFactory.createHumanoidRobotContextData();
        this.crashNotificationPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)realtimeROS2Node, ControllerCrashNotificationPacket.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)robotName));
        this.fullRobotModelCorruptor = null;
        JointBasics[] arrayOfJointsToIgnore = AvatarControllerThread.createListOfJointsToIgnore(this.controllerFullRobotModel, robotModel, sensorInformation);
        this.robotController = this.createHighLevelController(this.controllerFullRobotModel, controllerFactory, this.controllerTime, robotModel.getControllerDT(), gravity, (ForceSensorDataHolderReadOnly)forceSensorDataHolderForController, centerOfPressureDataHolderForEstimator, sensorInformation, (JointDesiredOutputListBasics)desiredJointDataHolder, this.yoGraphicsListRegistry, this.registry, arrayOfJointsToIgnore);
        this.createControllerRobotMotionStatusUpdater(controllerFactory, robotMotionStatusHolder);
        this.firstTick.set(true);
        this.registry.addChild(this.robotController.getYoRegistry());
        if (outputProcessor != null) {
            outputProcessor.setLowLevelControllerCoreOutput(processedJointData, (JointDesiredOutputListBasics)desiredJointDataHolder);
            outputProcessor.setForceSensorDataHolderForController((ForceSensorDataHolderReadOnly)forceSensorDataHolderForController);
            this.registry.addChild(outputProcessor.getControllerYoVariableRegistry());
        }
        ParameterLoaderHelper.loadParameters((Object)this, (WholeBodyControllerParameters)robotModel, (YoRegistry)this.registry);
    }

    public static JointBasics[] createListOfJointsToIgnore(FullHumanoidRobotModel controllerFullRobotModel, WholeBodyControllerParameters<RobotSide> robotModel, HumanoidRobotSensorInformation sensorInformation) {
        String[] additionalJointsToIgnore;
        ArrayList<OneDoFJointBasics> listOfJointsToIgnore = new ArrayList<OneDoFJointBasics>();
        AvatarRobotLidarParameters lidarParameters = sensorInformation.getLidarParameters(0);
        if (lidarParameters != null) {
            listOfJointsToIgnore.add(controllerFullRobotModel.getOneDoFJointByName(lidarParameters.getLidarSpindleJointName()));
        }
        if ((additionalJointsToIgnore = robotModel.getWalkingControllerParameters().getJointsToIgnoreInController()) != null) {
            for (String jointToIgnore : additionalJointsToIgnore) {
                listOfJointsToIgnore.add(controllerFullRobotModel.getOneDoFJointByName(jointToIgnore));
            }
        }
        JointBasics[] arrayOfJointsToIgnore = listOfJointsToIgnore.toArray(new JointBasics[0]);
        return arrayOfJointsToIgnore;
    }

    private void createControllerRobotMotionStatusUpdater(HighLevelHumanoidControllerFactory controllerFactory, final RobotMotionStatusHolder controllerRobotMotionStatusHolder) {
        RobotMotionStatusChangedListener controllerRobotMotionStatusUpdater = new RobotMotionStatusChangedListener(){

            public void robotMotionStatusHasChanged(RobotMotionStatus newStatus, double time) {
                controllerRobotMotionStatusHolder.setCurrentRobotMotionStatus(newStatus);
            }
        };
        controllerFactory.attachRobotMotionStatusChangedListener(controllerRobotMotionStatusUpdater);
    }

    public FullRobotModelCorruptor getFullRobotModelCorruptor() {
        return this.fullRobotModelCorruptor;
    }

    private ModularRobotController createHighLevelController(FullHumanoidRobotModel controllerModel, HighLevelHumanoidControllerFactory controllerFactory, YoDouble yoTime, double controlDT, double gravity, ForceSensorDataHolderReadOnly forceSensorDataHolderForController, CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator, HumanoidRobotSensorInformation sensorInformation, JointDesiredOutputListBasics lowLevelControllerOutput, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry, JointBasics ... jointsToIgnore) {
        RobotController robotController = controllerFactory.getController(controllerModel, controlDT, gravity, yoTime, yoGraphicsListRegistry, sensorInformation, forceSensorDataHolderForController, centerOfPressureDataHolderForEstimator, lowLevelControllerOutput, jointsToIgnore);
        ModularRobotController modularRobotController = new ModularRobotController("DRCMomentumBasedController");
        modularRobotController.addRobotController(robotController);
        if (yoGraphicsListRegistry != null) {
            // empty if block
        }
        return modularRobotController;
    }

    public void initialize() {
        this.firstTick.set(true);
        this.humanoidRobotContextData.setControllerRan(false);
        this.humanoidRobotContextData.setEstimatorRan(false);
    }

    @Override
    public void run() {
        this.runController.set(this.humanoidRobotContextData.getEstimatorRan());
        if (!this.runController.getValue()) {
            return;
        }
        try {
            HumanoidRobotContextTools.updateRobot((FullRobotModel)this.controllerFullRobotModel, (HumanoidRobotContextJointData)this.humanoidRobotContextData.getProcessedJointData());
            this.timestamp.set(this.humanoidRobotContextData.getTimestamp());
            if (this.firstTick.getValue()) {
                this.timestampOffset.set(this.timestamp.getValue());
            }
            this.controllerTime.set(Conversions.nanosecondsToSeconds((long)(this.timestamp.getValue() - this.timestampOffset.getValue())));
            if (this.firstTick.getValue()) {
                this.robotController.initialize();
                this.firstTick.set(false);
            }
            this.robotController.doControl();
            this.humanoidRobotContextData.setControllerRan(true);
        }
        catch (Exception e) {
            this.crashNotificationPublisher.publish((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.CONTROLLER_RUN, (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public void addRobotController(RobotController controller) {
        this.robotController.addRobotController(controller);
    }

    @Override
    public FullHumanoidRobotModel getFullRobotModel() {
        return this.controllerFullRobotModel;
    }

    @Override
    public HumanoidRobotContextData getHumanoidRobotContextData() {
        return this.humanoidRobotContextData;
    }

    public JointDesiredOutputListBasics getDesiredJointDataHolder() {
        return this.humanoidRobotContextData.getJointDesiredOutputList();
    }
}

