/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import gnu.trove.map.TObjectDoubleMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextTools;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.packets.ControllerCrashLocation;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.packets.sensing.StateEstimatorMode;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.controllers.ControllerStateChangedListener;
import us.ihmc.robotics.robotController.ModularRobotController;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.stateEstimation.humanoid.StateEstimatorController;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.ForceSensorStateUpdater;
import us.ihmc.tools.lists.PairList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class AvatarEstimatorThread
extends ModularRobotController {
    private final YoRegistry estimatorRegistry;
    private final YoBoolean firstTick;
    private final SensorReader sensorReader;
    private final FullHumanoidRobotModel estimatorFullRobotModel;
    private final StateEstimatorController mainStateEstimator;
    private final PairList<BooleanSupplier, StateEstimatorController> secondaryStateEstimators;
    private final ForceSensorStateUpdater forceSensorStateUpdater;
    private final RigidBodyTransform rootToWorldTransform = new RigidBodyTransform();
    private final HumanoidRobotContextData humanoidRobotContextData;
    private final IHMCRealtimeROS2Publisher<ControllerCrashNotificationPacket> controllerCrashPublisher;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final ExecutionTimer estimatorThreadTimer;

    public AvatarEstimatorThread(SensorReader sensorReader, FullHumanoidRobotModel estimatorFullRobotModel, HumanoidRobotContextData humanoidRobotContextData, StateEstimatorController mainStateEstimator, PairList<BooleanSupplier, StateEstimatorController> secondaryStateEstimators, ForceSensorStateUpdater forceSensorStateUpdater, IHMCRealtimeROS2Publisher<ControllerCrashNotificationPacket> controllerCrashPublisher, YoRegistry estimatorRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        super("EstimatorController");
        this.sensorReader = sensorReader;
        this.estimatorFullRobotModel = estimatorFullRobotModel;
        this.humanoidRobotContextData = humanoidRobotContextData;
        this.mainStateEstimator = mainStateEstimator;
        this.secondaryStateEstimators = secondaryStateEstimators;
        this.forceSensorStateUpdater = forceSensorStateUpdater;
        this.controllerCrashPublisher = controllerCrashPublisher;
        this.estimatorRegistry = estimatorRegistry;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        estimatorRegistry.addChild(super.getYoRegistry());
        if (mainStateEstimator != null) {
            this.addRobotController((RobotController)mainStateEstimator);
        }
        for (int i = 0; i < secondaryStateEstimators.size(); ++i) {
            this.addRobotController((RobotController)((ImmutablePair)secondaryStateEstimators.get(i)).getRight());
        }
        this.estimatorThreadTimer = new ExecutionTimer("estimatorThreadTimer", super.getYoRegistry());
        this.firstTick = new YoBoolean("firstTick", estimatorRegistry);
        this.firstTick.set(true);
    }

    public void run() {
        this.estimatorThreadTimer.startMeasurement();
        try {
            if (this.firstTick.getBooleanValue()) {
                this.initialize();
                if (this.forceSensorStateUpdater != null) {
                    this.forceSensorStateUpdater.initialize();
                }
                this.firstTick.set(false);
            }
            for (int i = 0; i < this.secondaryStateEstimators.size(); ++i) {
                this.estimatorFullRobotModel.getRootJoint().getJointConfiguration(this.rootToWorldTransform);
                if (!((BooleanSupplier)((ImmutablePair)this.secondaryStateEstimators.get(i)).getLeft()).getAsBoolean()) continue;
                ((StateEstimatorController)((ImmutablePair)this.secondaryStateEstimators.get(i)).getRight()).initializeEstimator(this.rootToWorldTransform);
            }
            this.sensorReader.compute(this.humanoidRobotContextData.getTimestamp(), this.humanoidRobotContextData.getSensorDataContext());
            this.doControl();
            if (this.forceSensorStateUpdater != null) {
                this.forceSensorStateUpdater.updateForceSensorState();
            }
            HumanoidRobotContextTools.updateContext((FullRobotModel)this.estimatorFullRobotModel, (HumanoidRobotContextJointData)this.humanoidRobotContextData.getProcessedJointData());
            this.humanoidRobotContextData.setEstimatorRan(!this.firstTick.getValue());
        }
        catch (Throwable e) {
            if (this.controllerCrashPublisher != null) {
                this.controllerCrashPublisher.publish((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.ESTIMATOR_RUN, (Throwable)e));
            }
            throw new RuntimeException(e);
        }
        this.estimatorThreadTimer.stopMeasurement();
    }

    public void initializeStateEstimators(RigidBodyTransform rootJointTransform, TObjectDoubleMap<String> jointPositions) {
        this.sensorReader.initialize();
        if (this.mainStateEstimator != null) {
            this.mainStateEstimator.initializeEstimator(rootJointTransform, jointPositions);
        }
        for (int i = 0; i < this.secondaryStateEstimators.size(); ++i) {
            ((StateEstimatorController)((ImmutablePair)this.secondaryStateEstimators.get(i)).getRight()).initializeEstimator(rootJointTransform, jointPositions);
        }
        this.firstTick.set(true);
        this.humanoidRobotContextData.setControllerRan(false);
        this.humanoidRobotContextData.setEstimatorRan(false);
    }

    public void setupHighLevelControllerCallback(HighLevelHumanoidControllerFactory controllerFactory, final Map<HighLevelControllerName, StateEstimatorMode> stateModeMap) {
        controllerFactory.attachControllerStateChangedListener(new ControllerStateChangedListener(){

            public void controllerStateHasChanged(Enum<?> oldState, Enum<?> newState) {
                StateEstimatorMode requestedMode = (StateEstimatorMode)stateModeMap.get(newState);
                if (requestedMode != null) {
                    AvatarEstimatorThread.this.mainStateEstimator.requestStateEstimatorMode(requestedMode);
                }
            }
        });
    }

    @Deprecated
    public SensorReader getSensorReader() {
        return this.sensorReader;
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.estimatorFullRobotModel;
    }

    public YoRegistry getYoRegistry() {
        return this.estimatorRegistry;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public HumanoidRobotContextData getHumanoidRobotContextData() {
        return this.humanoidRobotContextData;
    }
}

