/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import controller_msgs.msg.dds.ControllerCrashNotificationPacket;
import controller_msgs.msg.dds.HighLevelStateChangeStatusMessage;
import controller_msgs.msg.dds.RequestWristForceSensorCalibrationPacket;
import gnu.trove.map.TObjectDoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commons.Conversions;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.packets.ControllerCrashLocation;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.packets.sensing.StateEstimatorMode;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicatorInterface;
import us.ihmc.humanoidRobotics.communication.subscribers.RequestWristForceSensorCalibrationSubscriber;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.robotController.ModularRobotController;
import us.ihmc.robotics.robotController.RawOutputWriter;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.CenterOfMassDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataPublisherFactory;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.sensorProcessors.RobotJointLimitWatcher;
import us.ihmc.sensorProcessing.sensorProcessors.SensorOutputMapReadOnly;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReader;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReaderFactory;
import us.ihmc.sensorProcessing.stateEstimation.IMUSensorReadOnly;
import us.ihmc.sensorProcessing.stateEstimation.StateEstimatorParameters;
import us.ihmc.simulationConstructionSetTools.robotController.MultiThreadedRobotControlElement;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.stateEstimation.humanoid.StateEstimatorController;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.ForceSensorCalibrationModule;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.ForceSensorStateUpdater;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.KinematicsBasedStateEstimatorFactory;
import us.ihmc.tools.UnitConversions;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.concurrent.ThreadDataSynchronizerInterface;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class DRCEstimatorThread
implements MultiThreadedRobotControlElement {
    private static final boolean USE_FORCE_SENSOR_TO_JOINT_TORQUE_PROJECTOR = false;
    private static final boolean CREATE_EKF_ESTIMATOR = false;
    private static final boolean USE_EKF_ESTIMATOR = false;
    private final YoRegistry estimatorRegistry = new YoRegistry("DRCEstimatorThread");
    private final RobotVisualizer robotVisualizer;
    private final FullHumanoidRobotModel estimatorFullRobotModel;
    private final ForceSensorDataHolder forceSensorDataHolderForEstimator;
    private final ModularRobotController estimatorController;
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private final StateEstimatorController drcStateEstimator;
    private final StateEstimatorController ekfStateEstimator;
    private final YoBoolean reinitializeEKF;
    private final ThreadDataSynchronizerInterface threadDataSynchronizer;
    private final SensorReader sensorReader;
    private final YoLong estimatorTime = new YoLong("estimatorTime", this.estimatorRegistry);
    private final YoLong estimatorTick = new YoLong("estimatorTick", this.estimatorRegistry);
    private final YoBoolean firstTick = new YoBoolean("firstTick", this.estimatorRegistry);
    private final YoBoolean controllerDataValid = new YoBoolean("controllerDataValid", this.estimatorRegistry);
    private final YoLong startClockTime = new YoLong("startTime", this.estimatorRegistry);
    private final ExecutionTimer estimatorTimer = new ExecutionTimer("estimatorTimer", 10.0, this.estimatorRegistry);
    private long lastReadSystemTime = 0L;
    private final YoDouble actualEstimatorDT = new YoDouble("actualEstimatorDTInMillis", this.estimatorRegistry);
    private final SensorOutputMapReadOnly processedSensorOutputMap;
    private final SensorOutputMapReadOnly rawSensorOutputMap;
    private final RobotMotionStatusHolder robotMotionStatusFromController;
    private final RigidBodyTransform rootToWorldTransform = new RigidBodyTransform();
    private final ReferenceFrame rootFrame;
    private final JointDesiredOutputWriter outputWriter;
    private final IHMCRealtimeROS2Publisher<ControllerCrashNotificationPacket> controllerCrashPublisher;
    private final ForceSensorStateUpdater forceSensorStateUpdater;
    private final SensorDataContext sensorDataContext = new SensorDataContext();

    public DRCEstimatorThread(String robotName, HumanoidRobotSensorInformation sensorInformation, RobotContactPointParameters<RobotSide> contactPointParameters, DRCRobotModel robotModel, StateEstimatorParameters stateEstimatorParameters, SensorReaderFactory sensorReaderFactory, ThreadDataSynchronizerInterface threadDataSynchronizer, RealtimeROS2Node realtimeROS2Node, PelvisPoseCorrectionCommunicatorInterface externalPelvisPoseSubscriber, JointDesiredOutputWriter outputWriter, RobotVisualizer robotVisualizer, double gravity) {
        this.threadDataSynchronizer = threadDataSynchronizer;
        this.robotVisualizer = robotVisualizer;
        this.estimatorFullRobotModel = threadDataSynchronizer.getEstimatorFullRobotModel();
        FloatingJointBasics rootJoint = this.estimatorFullRobotModel.getRootJoint();
        this.rootFrame = rootJoint.getFrameAfterJoint();
        this.forceSensorDataHolderForEstimator = threadDataSynchronizer.getEstimatorForceSensorDataHolder();
        IMUDefinition[] imuDefinitions = this.estimatorFullRobotModel.getIMUDefinitions();
        ForceSensorDefinition[] forceSensorDefinitions = this.estimatorFullRobotModel.getForceSensorDefinitions();
        JointDesiredOutputListBasics estimatorDesiredJointDataHolder = threadDataSynchronizer.getEstimatorDesiredJointDataHolder();
        sensorReaderFactory.build(rootJoint, imuDefinitions, forceSensorDefinitions, estimatorDesiredJointDataHolder, this.estimatorRegistry);
        this.sensorReader = sensorReaderFactory.getSensorReader();
        this.estimatorController = new ModularRobotController("EstimatorController");
        this.robotMotionStatusFromController = threadDataSynchronizer.getEstimatorRobotMotionStatusHolder();
        this.processedSensorOutputMap = this.sensorReader.getProcessedSensorOutputMap();
        this.rawSensorOutputMap = this.sensorReader.getRawSensorOutputMap();
        this.controllerCrashPublisher = realtimeROS2Node != null ? ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)realtimeROS2Node, ControllerCrashNotificationPacket.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)robotName)) : null;
        if (sensorReaderFactory.useStateEstimator()) {
            this.forceSensorStateUpdater = this.forceSensorDataHolderForEstimator != null ? new ForceSensorStateUpdater(this.estimatorFullRobotModel.getRootJoint(), this.processedSensorOutputMap, this.forceSensorDataHolderForEstimator, stateEstimatorParameters, gravity, this.robotMotionStatusFromController, this.yoGraphicsListRegistry, this.estimatorRegistry) : null;
            if (realtimeROS2Node != null) {
                RequestWristForceSensorCalibrationSubscriber requestWristForceSensorCalibrationSubscriber = new RequestWristForceSensorCalibrationSubscriber();
                ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
                ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, RequestWristForceSensorCalibrationPacket.class, (ROS2Topic)inputTopic, subscriber -> requestWristForceSensorCalibrationSubscriber.receivedPacket((RequestWristForceSensorCalibrationPacket)subscriber.takeNextData()));
                this.forceSensorStateUpdater.setRequestWristForceSensorCalibrationSubscriber(requestWristForceSensorCalibrationSubscriber);
            }
        } else {
            this.forceSensorStateUpdater = null;
        }
        if (sensorReaderFactory.useStateEstimator()) {
            KinematicsBasedStateEstimatorFactory estimatorFactory = new KinematicsBasedStateEstimatorFactory();
            ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
            ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
            ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
            ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
            contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
            contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
            for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
                contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
            }
            CenterOfPressureDataHolder centerOfPressureDataHolderFromController = threadDataSynchronizer.getEstimatorCenterOfPressureDataHolder();
            CenterOfMassDataHolder centerOfMassDataHolderForEstimator = threadDataSynchronizer.getEstimatorCenterOfMassDataHolder();
            estimatorFactory.setEstimatorFullRobotModel(this.estimatorFullRobotModel).setSensorInformation(sensorInformation).setSensorOutputMapReadOnly(this.processedSensorOutputMap).setGravity(Double.valueOf(gravity)).setStateEstimatorParameters(stateEstimatorParameters).setContactableBodiesFactory(contactableBodiesFactory).setEstimatorForceSensorDataHolder((ForceSensorDataHolderReadOnly)this.forceSensorDataHolderForEstimator).setEstimatorCenterOfMassDataHolderToUpdate(centerOfMassDataHolderForEstimator).setCenterOfPressureDataHolderFromController(centerOfPressureDataHolderFromController).setRobotMotionStatusFromController(this.robotMotionStatusFromController);
            this.drcStateEstimator = estimatorFactory.createStateEstimator(this.estimatorRegistry, this.yoGraphicsListRegistry);
            this.estimatorController.addRobotController((RobotController)this.drcStateEstimator);
        } else {
            this.drcStateEstimator = null;
        }
        RobotJointLimitWatcher robotJointLimitWatcher = new RobotJointLimitWatcher(this.estimatorFullRobotModel.getOneDoFJoints(), this.rawSensorOutputMap);
        this.estimatorController.addRobotController((RobotController)robotJointLimitWatcher);
        if (realtimeROS2Node != null) {
            ForceSensorDataHolder forceSensorDataHolderToSend = sensorReaderFactory.useStateEstimator() && this.forceSensorStateUpdater.getForceSensorOutputWithGravityCancelled() != null ? this.forceSensorStateUpdater.getForceSensorOutputWithGravityCancelled() : this.forceSensorDataHolderForEstimator;
            RobotConfigurationDataPublisherFactory factory = new RobotConfigurationDataPublisherFactory();
            factory.setDefinitionsToPublish(this.estimatorFullRobotModel);
            factory.setSensorSource((FullRobotModel)this.estimatorFullRobotModel, (ForceSensorDataHolderReadOnly)forceSensorDataHolderToSend, this.rawSensorOutputMap);
            factory.setRobotMotionStatusHolder(this.robotMotionStatusFromController);
            factory.setPublishPeriod(Conversions.secondsToNanoseconds((double)UnitConversions.hertzToSeconds((double)120.0)));
            factory.setROS2Info(realtimeROS2Node, ROS2Tools.getControllerOutputTopic((String)robotName));
            this.estimatorController.setRawOutputWriter((RawOutputWriter)factory.createRobotConfigurationDataPublisher());
        }
        this.firstTick.set(true);
        this.controllerDataValid.set(false);
        this.estimatorRegistry.addChild(this.estimatorController.getYoRegistry());
        this.outputWriter = outputWriter;
        if (this.outputWriter != null) {
            this.outputWriter.setJointDesiredOutputList(estimatorDesiredJointDataHolder);
            if (this.outputWriter.getYoVariableRegistry() != null) {
                this.estimatorRegistry.addChild(this.outputWriter.getYoVariableRegistry());
            }
        }
        ParameterLoaderHelper.loadParameters((Object)this, (WholeBodyControllerParameters)robotModel, (YoRegistry)this.estimatorRegistry);
        if (sensorReaderFactory.useStateEstimator()) {
            this.reinitializeEKF = null;
            this.ekfStateEstimator = null;
        } else {
            this.reinitializeEKF = null;
            this.ekfStateEstimator = null;
        }
        if (robotVisualizer != null) {
            robotVisualizer.setMainRegistry(this.estimatorRegistry, this.estimatorFullRobotModel.getElevator(), this.yoGraphicsListRegistry);
        }
    }

    public void setupHighLevelControllerCallback(String robotName, RealtimeROS2Node realtimeROS2Node, Map<HighLevelControllerName, StateEstimatorMode> stateModeMap) {
        ROS2Topic outputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((RealtimeROS2Node)realtimeROS2Node, HighLevelStateChangeStatusMessage.class, (ROS2Topic)outputTopic, subscriber -> {
            HighLevelStateChangeStatusMessage message = (HighLevelStateChangeStatusMessage)subscriber.takeNextData();
            LogTools.debug((String)"Estimator recieved message: controller going to {}", (Object)HighLevelControllerName.fromByte((byte)message.getEndHighLevelControllerName()));
            StateEstimatorMode requestedMode = (StateEstimatorMode)stateModeMap.get(HighLevelControllerName.fromByte((byte)message.getEndHighLevelControllerName()));
            LogTools.debug((String)"Estimator going to {}", (Object)requestedMode);
            if (this.drcStateEstimator != null) {
                this.drcStateEstimator.requestStateEstimatorMode(requestedMode);
            }
            if (this.ekfStateEstimator != null) {
                this.ekfStateEstimator.requestStateEstimatorMode(requestedMode);
            }
        });
    }

    public void initialize() {
    }

    public YoRegistry getYoVariableRegistry() {
        return this.estimatorRegistry;
    }

    public String getName() {
        return this.estimatorRegistry.getName();
    }

    public void read(long currentClockTime) {
        try {
            long nanoTime = System.nanoTime();
            this.actualEstimatorDT.set(Conversions.nanosecondsToMilliseconds((double)(nanoTime - this.lastReadSystemTime)));
            this.lastReadSystemTime = nanoTime;
            this.startClockTime.set(currentClockTime);
            this.controllerDataValid.set(this.threadDataSynchronizer.receiveControllerDataForEstimator());
            if (this.outputWriter != null && this.controllerDataValid.getBooleanValue()) {
                this.outputWriter.writeBefore(currentClockTime);
            }
            long timestamp = this.sensorReader.read(this.sensorDataContext);
            this.sensorReader.compute(timestamp, this.sensorDataContext);
            this.estimatorTime.set(this.processedSensorOutputMap.getWallTime());
        }
        catch (Throwable e) {
            if (this.controllerCrashPublisher != null) {
                this.controllerCrashPublisher.publish((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.ESTIMATOR_READ, (Throwable)e));
            }
            throw new RuntimeException(e);
        }
    }

    public void run() {
        try {
            if (this.firstTick.getBooleanValue()) {
                this.estimatorController.initialize();
                if (this.forceSensorStateUpdater != null) {
                    this.forceSensorStateUpdater.initialize();
                }
                this.firstTick.set(false);
            }
            this.estimatorTimer.startMeasurement();
            if (this.reinitializeEKF != null && this.reinitializeEKF.getValue()) {
                this.reinitializeEKF.set(false);
                this.estimatorFullRobotModel.getRootJoint().getJointConfiguration(this.rootToWorldTransform);
                this.ekfStateEstimator.initializeEstimator(this.rootToWorldTransform);
            }
            this.estimatorController.doControl();
            if (this.forceSensorStateUpdater != null) {
                this.forceSensorStateUpdater.updateForceSensorState();
            }
            this.estimatorTimer.stopMeasurement();
        }
        catch (Throwable e) {
            if (this.controllerCrashPublisher != null) {
                this.controllerCrashPublisher.publish((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.ESTIMATOR_RUN, (Throwable)e));
            }
            throw new RuntimeException(e);
        }
    }

    public void write(long timestamp) {
        try {
            if (this.outputWriter != null && this.controllerDataValid.getBooleanValue()) {
                this.outputWriter.writeAfter();
            }
            long startTimestamp = this.estimatorTime.getLongValue();
            this.threadDataSynchronizer.publishEstimatorState(startTimestamp, this.estimatorTick.getLongValue(), this.startClockTime.getLongValue());
            if (this.robotVisualizer != null) {
                this.robotVisualizer.update(startTimestamp);
            }
            this.estimatorTick.increment();
            this.rootFrame.getTransformToDesiredFrame(this.rootToWorldTransform, ReferenceFrame.getWorldFrame());
            this.yoGraphicsListRegistry.setControllerTransformToWorld(this.rootToWorldTransform);
        }
        catch (Throwable e) {
            if (this.controllerCrashPublisher != null) {
                this.controllerCrashPublisher.publish((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.ESTIMATOR_WRITE, (Throwable)e));
            }
            throw new RuntimeException(e);
        }
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public ForceSensorCalibrationModule getForceSensorCalibrationModule() {
        return this.forceSensorStateUpdater;
    }

    public long nextWakeupTime() {
        throw new RuntimeException("Estimator thread should not wake up based on clock");
    }

    public void initializeEstimator(RigidBodyTransform rootJointTransform, TObjectDoubleMap<String> jointPositions) {
        if (this.ekfStateEstimator != null) {
            this.ekfStateEstimator.initializeEstimator(rootJointTransform, jointPositions);
        }
        if (this.drcStateEstimator != null) {
            this.drcStateEstimator.initializeEstimator(rootJointTransform, jointPositions);
        }
    }

    public List<? extends IMUSensorReadOnly> getSimulatedIMUOutput() {
        return this.processedSensorOutputMap.getIMUOutputs();
    }

    public void dispose() {
    }

    public void addRobotController(RobotController controller) {
        this.estimatorController.addRobotController(controller);
    }
}

