/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar;

import java.util.ArrayList;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.robotics.math.filters.DelayedYoDouble;
import us.ihmc.robotics.robotController.RawOutputWriter;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.wholeBodyController.DRCOutputProcessor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DRCSimulationOutputWriterForControllerThread
implements DRCOutputProcessor {
    private static final int TICKS_TO_DELAY = 0;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final FloatingRootJointRobot robot;
    private final ArrayList<OutputDataSet> revoluteJoints = new ArrayList();
    private final ArrayList<RawOutputWriter> rawOutputWriters = new ArrayList();

    public DRCSimulationOutputWriterForControllerThread(FloatingRootJointRobot robot) {
        this.robot = robot;
    }

    public void processAfterController(long timestamp) {
        int i;
        for (i = 0; i < this.revoluteJoints.size(); ++i) {
            OutputDataSet data = this.revoluteJoints.get(i);
            double tau = 0.0;
            if (data.jointData.hasDesiredTorque()) {
                tau = data.jointData.getDesiredTorque();
            }
            YoDouble rawJointTorque = data.rawJointTorque;
            DelayedYoDouble delayedJointTorque = data.delayedJointTorque;
            if (rawJointTorque != null) {
                rawJointTorque.set(tau);
                delayedJointTorque.update();
                tau = delayedJointTorque.getDoubleValue();
            }
            data.simulatedJoint.setTau(tau);
            if (data.jointData.hasStiffness()) {
                data.simulatedJoint.setKp(data.jointData.getStiffness());
            }
            if (data.jointData.hasDamping()) {
                data.simulatedJoint.setKd(data.jointData.getDamping());
            }
            if (data.jointData.hasDesiredPosition()) {
                data.simulatedJoint.setqDesired(data.jointData.getDesiredPosition());
            }
            if (!data.jointData.hasDesiredVelocity()) continue;
            data.simulatedJoint.setQdDesired(data.jointData.getDesiredVelocity());
        }
        for (i = 0; i < this.rawOutputWriters.size(); ++i) {
            this.rawOutputWriters.get(i).write();
        }
    }

    public void setLowLevelControllerCoreOutput(HumanoidRobotContextJointData estimatedState, JointDesiredOutputListBasics lowLevelControllerOutput) {
        for (int i = 0; i < lowLevelControllerOutput.getNumberOfJointsWithDesiredOutput(); ++i) {
            String jointName = lowLevelControllerOutput.getOneDoFJoint(i).getName();
            OutputDataSet data = new OutputDataSet();
            data.rawJointTorque = new YoDouble("tau_desired_" + jointName, this.registry);
            data.delayedJointTorque = new DelayedYoDouble("tau_delayed_" + jointName, "", data.rawJointTorque, 0, this.registry);
            data.simulatedJoint = this.robot.getOneDegreeOfFreedomJoint(jointName);
            data.jointData = lowLevelControllerOutput.getJointDesiredOutput(i);
            this.revoluteJoints.add(data);
        }
    }

    public void addRawOutputWriter(RawOutputWriter rawOutputWriter) {
        this.rawOutputWriters.add(rawOutputWriter);
    }

    public void setForceSensorDataHolderForController(ForceSensorDataHolderReadOnly forceSensorDataHolderForEstimator) {
    }

    public YoRegistry getControllerYoVariableRegistry() {
        return this.registry;
    }

    public void initialize() {
    }

    private class OutputDataSet {
        private OneDegreeOfFreedomJoint simulatedJoint;
        private JointDesiredOutputBasics jointData;
        private YoDouble rawJointTorque;
        private DelayedYoDouble delayedJointTorque;

        private OutputDataSet() {
        }
    }
}

