/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.drcRobot;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.util.function.Function;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.tools.Timer;
import us.ihmc.tools.TimerSnapshot;

public abstract class CommunicationsSyncedRobotModel {
    private final FullHumanoidRobotModel fullRobotModel;
    private final Timer dataReceptionTimer;
    protected RobotConfigurationData robotConfigurationData;
    private final OneDoFJointBasics[] allJoints;
    protected final int jointNameHash;
    private final HumanoidReferenceFrames referenceFrames;
    private final FramePose3D temporaryPoseForQuickReading = new FramePose3D();

    public CommunicationsSyncedRobotModel(FullHumanoidRobotModel fullRobotModel, HumanoidRobotSensorInformation sensorInformation) {
        this.fullRobotModel = fullRobotModel;
        this.robotConfigurationData = new RobotConfigurationData();
        this.referenceFrames = new HumanoidReferenceFrames(fullRobotModel, sensorInformation);
        this.allJoints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        this.jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])this.allJoints, (ForceSensorDefinition[])fullRobotModel.getForceSensorDefinitions(), (IMUDefinition[])fullRobotModel.getIMUDefinitions());
        this.dataReceptionTimer = new Timer();
    }

    public abstract RobotConfigurationData getLatestRobotConfigurationData();

    protected synchronized void resetDataReceptionTimer() {
        this.dataReceptionTimer.reset();
    }

    public void update() {
        this.robotConfigurationData = this.getLatestRobotConfigurationData();
        if (this.robotConfigurationData != null) {
            this.updateInternal();
        }
    }

    protected void updateInternal() {
        this.fullRobotModel.getRootJoint().setJointOrientation((Orientation3DReadOnly)this.robotConfigurationData.getRootOrientation());
        this.fullRobotModel.getRootJoint().setJointPosition((Tuple3DReadOnly)this.robotConfigurationData.getRootTranslation());
        for (int i = 0; i < this.robotConfigurationData.getJointAngles().size(); ++i) {
            this.allJoints[i].setQ((double)this.robotConfigurationData.getJointAngles().get(i));
        }
        this.fullRobotModel.getElevator().updateFramesRecursively();
        try {
            this.referenceFrames.updateFrames();
        }
        catch (NotARotationMatrixException e) {
            LogTools.error((String)e.getMessage());
        }
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public HumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }

    public RobotConfigurationData getRobotConfigurationData() {
        return this.robotConfigurationData;
    }

    public long getTimestamp() {
        return this.robotConfigurationData.getMonotonicTime();
    }

    public FramePose3DReadOnly getFramePoseReadOnly(Function<HumanoidReferenceFrames, ReferenceFrame> frameSelector) {
        this.temporaryPoseForQuickReading.setFromReferenceFrame(frameSelector.apply(this.referenceFrames));
        return this.temporaryPoseForQuickReading;
    }

    public synchronized TimerSnapshot getDataReceptionTimerSnapshot() {
        return this.dataReceptionTimer.createSnapshot();
    }
}

