/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.environments;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import us.ihmc.avatar.environments.RealisticLabTerrainBuilder;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.pathPlanning.PlannerTestEnvironments;
import us.ihmc.robotEnvironmentAwareness.planarRegion.slam.PlanarRegionSLAM;
import us.ihmc.robotEnvironmentAwareness.planarRegion.slam.PlanarRegionSLAMParameters;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;
import us.ihmc.simulationConstructionSetTools.util.planarRegions.PlanarRegionsListExamples;

public class BehaviorPlanarRegionEnvironments
extends PlannerTestEnvironments {
    public static final double CINDER_SLOPE_ANGLE = 13.0;
    public static final double Z_STEP_UP_PER_ROW = 0.1;
    private static double cinderSquareSurfaceSize = 0.395;
    private static double cinderThickness = 0.145;
    public static final double TRIPLE_PLATFORM_HEIGHT = 0.44999999999999996;
    public static double topRegionHeight = 0.5 - cinderThickness;
    public static double topPlatformHeight = topRegionHeight + cinderThickness + 0.07;
    private static double superGridSize = cinderSquareSurfaceSize * 3.0;
    private static double groundSize = 20.0;
    private static int greenId = 6;

    public static PlanarRegionsList flatGround() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setId(greenId);
        generator.addRectangle(groundSize, groundSize);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createTraversalRegionsRegions() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        PlanarRegionsListExamples.generateCinderBlockField((PlanarRegionsListGenerator)generator, (double)0.4, (double)0.1, (int)5, (int)6, (double)0.02, (double)-0.03, (double)1.5, (double)0.0, (double)Math.toRadians(13.0), (double)Math.toRadians(13.0), (double)0.05, (boolean)false);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createStairs() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setId(greenId);
        generator.addRectangle(0.75, 0.75);
        generator.translate(0.75, 0.0, -0.25);
        generator.addRectangle(0.75, 0.75);
        generator.translate(0.75, 0.0, -0.25);
        generator.addRectangle(0.75, 0.75);
        generator.translate(0.75, 0.0, -0.25);
        generator.addRectangle(0.75, 0.75);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createUpDownOpenHouseRegions() {
        Random random = new Random(8349829898174L);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setId(greenId);
        generator.addRectangle(groundSize, groundSize);
        generator.translate(1.0, -superGridSize / 2.0, 0.0);
        BehaviorPlanarRegionEnvironments.addTopFlatRegionOld(generator);
        BehaviorPlanarRegionEnvironments.addPlusFormationSlopes(random, generator);
        BehaviorPlanarRegionEnvironments.addXFormationSlopes(random, generator);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createRoughUpAndDownStepsWithFlatTop() {
        return BehaviorPlanarRegionEnvironments.createRoughUpAndDownStepsWithFlatTop(true);
    }

    public static PlanarRegionsList createRoughUpAndDownStepsWithFlatTop(boolean createGroundPlane) {
        return BehaviorPlanarRegionEnvironments.generate((random, generator) -> BehaviorPlanarRegionEnvironments.offsetGrid(generator, 1.0, -0.5, 0.0, () -> {
            BehaviorPlanarRegionEnvironments.offsetGrid(generator, 0.0, 0.0, 0.0, () -> BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator));
            BehaviorPlanarRegionEnvironments.offsetGrid(generator, 1.0, 0.0, topRegionHeight, () -> BehaviorPlanarRegionEnvironments.addTopFlatRegion(generator));
            BehaviorPlanarRegionEnvironments.offsetGrid(generator, 3.0, 1.0, 0.0, () -> BehaviorPlanarRegionEnvironments.rotate(generator, Math.PI, () -> BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator)));
        }), createGroundPlane);
    }

    public static PlanarRegionsList createFlatUpAndDownStepsWithFlatTop() {
        return BehaviorPlanarRegionEnvironments.generate((random, generator) -> BehaviorPlanarRegionEnvironments.offsetGrid(generator, 1.0, -0.5, 0.0, () -> {
            BehaviorPlanarRegionEnvironments.offsetGrid(generator, 0.0, 0.0, 0.0, () -> BehaviorPlanarRegionEnvironments.generateFlatCinderBlockSteps(generator));
            BehaviorPlanarRegionEnvironments.offsetGrid(generator, 1.0, 0.0, topRegionHeight, () -> BehaviorPlanarRegionEnvironments.addTopFlatRegion(generator));
            BehaviorPlanarRegionEnvironments.offsetGrid(generator, 3.0, 1.0, 0.0, () -> BehaviorPlanarRegionEnvironments.rotate(generator, Math.PI, () -> BehaviorPlanarRegionEnvironments.generateFlatCinderBlockSteps(generator)));
        }), true);
    }

    public static PlanarRegionsList generateStartingBlockRegions() {
        return BehaviorPlanarRegionEnvironments.generateStartingBlockRegions(new RigidBodyTransform());
    }

    public static PlanarRegionsList generateStartingBlockRegions(RigidBodyTransform startingPose) {
        double platformXY = 1.0;
        double platformHeight = 0.3;
        double blockXY = 0.35;
        double blockHeight = 0.15;
        double blockSpacing = 0.1;
        double maxBlockAngle = Math.toRadians(20.0);
        double lastRowMaxBlockAngle = Math.toRadians(10.0);
        Random random = new Random(328903L);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setTransform(startingPose);
        generator.setId(250);
        generator.addCubeReferencedAtBottomMiddle(platformXY, platformXY, platformHeight);
        generator.translate(0.5 * (platformXY + blockXY), 3.0 * (blockXY + blockSpacing), 0.0);
        for (int i = 0; i < 5; ++i) {
            double height = platformHeight - blockHeight - 0.05 * (double)(i + 1);
            generator.translate(0.0, -4.0 * (blockXY + blockSpacing), 0.0);
            if (i % 2 == 0) {
                generator.translate(0.0, -0.5 * (blockXY + blockSpacing), 0.0);
            } else {
                generator.translate(0.0, 0.5 * (blockXY + blockSpacing), 0.0);
            }
            for (int j = 0; j < 4; ++j) {
                double rotationAxisDirection = Math.PI * 2 * random.nextDouble();
                double rotationAngle = (i == 4 ? lastRowMaxBlockAngle : maxBlockAngle) * random.nextDouble();
                double yawRotation = Math.PI * 2 * random.nextDouble();
                Vector3D rotationAxis = new Vector3D(Math.cos(rotationAxisDirection), Math.sin(rotationAxisDirection), 0.0);
                rotationAxis.scale(rotationAngle);
                AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)rotationAxis, rotationAngle);
                RotationMatrix rotationMatrix = new RotationMatrix();
                axisAngle.get((CommonMatrix3DBasics)rotationMatrix);
                generator.translate(0.0, 0.0, height);
                generator.rotate(rotationMatrix);
                generator.rotate(yawRotation, Axis3D.Z);
                generator.addCubeReferencedAtBottomMiddle(blockXY, blockXY, blockHeight);
                generator.rotate(-yawRotation, Axis3D.Z);
                rotationMatrix.invert();
                generator.rotate(rotationMatrix);
                generator.translate(0.0, 0.0, -height);
                generator.translate(0.0, blockXY + blockSpacing, 0.0);
            }
            generator.translate(blockXY, 0.0, 0.0);
        }
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList generateRealisticEasierStartingBlockRegions() {
        Pose3D pose = new Pose3D();
        pose.setX(-0.5);
        pose.setY(-0.5);
        return BehaviorPlanarRegionEnvironments.generateRealisticEasierStartingBlockRegions((Pose3DReadOnly)pose);
    }

    public static PlanarRegionsList generateRealisticEasierStartingBlockRegions(Pose3DReadOnly poseInWorld) {
        RealisticLabTerrainBuilder builder = new RealisticLabTerrainBuilder(true);
        builder.pushOffset((Tuple3DReadOnly)poseInWorld.getPosition(), (Orientation3DReadOnly)poseInWorld.getOrientation());
        builder.addGround(20.0);
        builder.addPalletStackReferencedAtNegativeXY(2);
        builder.pushOffset(1.0, 0.0);
        builder.addPalletStackReferencedAtNegativeXY(1, () -> {
            builder.placeSmallCinderBlockGroup(0.05, 0.4, Math.toRadians(-70.0), 2);
            builder.placeMediumCinderBlockGroup(0.7, 0.5, Math.toRadians(50.0), 2);
        });
        builder.pushOffset(1.0, 0.0);
        builder.addPalletStackReferencedAtNegativeXY(1, () -> {
            builder.placeMediumCinderBlockGroup(0.25, 0.02, Math.toRadians(40.0), 3);
            builder.placeLargeCinderBlockGroup(0.6, 0.55, Math.toRadians(10.0), 2);
            builder.placeMediumCinderBlockGroup(0.9, 0.05, Math.toRadians(-10.0), 2);
        });
        builder.pushOffset(1.0, 0.0);
        builder.addPalletStackReferencedAtNegativeXY(1, () -> {
            builder.placeSmallCinderBlockGroup(0.55, 0.6, Math.toRadians(90.0), 2);
            builder.placeMediumCinderBlockGroup(0.7, 0.04, Math.toRadians(30.0), 2);
        });
        builder.popAllRemainingOffsets();
        builder.setRegionIds(greenId);
        return builder.getPlanarRegionsList();
    }

    public static PlanarRegionsList generateTriplePalletCinderBlockStepsUpAndDown() {
        RealisticLabTerrainBuilder builder = new RealisticLabTerrainBuilder(true);
        builder.addGround(20.0);
        builder.pushOffset(1.5, -0.5);
        builder.addMediumCinderBlockGroup(5);
        builder.pushOffset(0.4, 0.0);
        builder.addMediumCinderBlockGroup(5);
        builder.pushOffset(0.0, 0.0, 0.15);
        builder.addMediumCinderBlockGroup(5);
        builder.popOffset();
        builder.pushOffset(0.4, 0.0);
        builder.addPalletStackReferencedAtNegativeXY(3);
        builder.pushOffset(1.0, 0.0);
        builder.addMediumCinderBlockGroup(5);
        builder.pushOffset(0.0, 0.0, 0.15);
        builder.addMediumCinderBlockGroup(5);
        builder.popOffset();
        builder.pushOffset(0.4, 0.0);
        builder.addMediumCinderBlockGroup(5);
        builder.pushOffset(0.4, 0.0);
        builder.popAllRemainingOffsets();
        builder.setRegionIds(greenId);
        return builder.getPlanarRegionsList();
    }

    public static PlanarRegionsList generateTriplePalletCinderBlockAngledStepsUpAndDown() {
        RealisticLabTerrainBuilder builder = new RealisticLabTerrainBuilder(true);
        builder.addGround(20.0);
        builder.pushOffset(1.5, -0.5);
        builder.placeWithOffset(0.0, -0.17, () -> {
            builder.addMediumAngledCinderBlockGroup(2);
            builder.pushOffset(0.0, 0.53);
            builder.addSmallAngledCinderBlockGroup(2, Math.toRadians(90.0));
            builder.pushOffset(0.0, 0.35);
            builder.addMediumAngledCinderBlockGroup(2);
            builder.popOffset(2);
        });
        builder.pushOffset(0.4, 0.0);
        builder.placeWithOffset(0.0, -0.17, () -> {
            builder.addMediumCinderBlockGroup(6);
            builder.pushOffset(-0.1, 0.05, 0.15);
            builder.addMediumAngledCinderBlockGroup(2, Math.toRadians(-90.0));
            builder.pushOffset(0.13, 0.45);
            builder.placeWithOffset(0.05, 0.0, () -> builder.addSmallAngledCinderBlockGroup(2, Math.toRadians(90.0)));
            builder.pushOffset(-0.03, 0.3);
            builder.addMediumCinderBlockGroup(2);
            builder.popOffset(3);
        });
        builder.pushOffset(0.4, 0.0);
        builder.addPalletStackReferencedAtNegativeXY(3);
        builder.pushOffset(1.0, 0.0);
        builder.addMediumCinderBlockGroup(5);
        builder.pushOffset(0.0, 0.0, 0.15);
        builder.addMediumCinderBlockGroup(5);
        builder.popOffset();
        builder.pushOffset(0.4, 0.0);
        builder.addMediumCinderBlockGroup(5);
        builder.pushOffset(0.4, 0.0);
        builder.popAllRemainingOffsets();
        builder.setRegionIds(greenId);
        return builder.getPlanarRegionsList();
    }

    private static PlanarRegionsList generate(GenerationInterface generationInterface, boolean createGroundPlane) {
        Random random = new Random(8349829898174L);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        if (createGroundPlane) {
            generator.setId(greenId);
            generator.addRectangle(groundSize, groundSize);
        }
        generationInterface.generate(random, generator);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createUpDownTwoHighWithFlatBetween() {
        Random random = new Random(8349829898174L);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setId(greenId);
        generator.addRectangle(groundSize, groundSize);
        generator.translate(1.0, -superGridSize / 2.0, 0.0);
        BehaviorPlanarRegionEnvironments.addTopFlatRegionOld(generator);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.rotate(Math.PI, Axis3D.Z);
        generator.translate(2.0, -1.2, 0.0);
        BehaviorPlanarRegionEnvironments.addTopFlatRegionOld(generator);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createUpDownFourHighWithFlatCenter() {
        Random random = new Random(8349829898174L);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setId(greenId);
        generator.addRectangle(groundSize, groundSize);
        generator.rotate(0.7853981633974483, Axis3D.Z);
        double xSize = 0.5;
        double ySize = xSize + 2.0;
        generator.translate(xSize * superGridSize, -ySize * superGridSize, 0.0);
        BehaviorPlanarRegionEnvironments.addHighCorner(random, generator);
        generator.translate(-xSize * superGridSize, ySize * superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(xSize * superGridSize, -ySize * superGridSize, 0.0);
        BehaviorPlanarRegionEnvironments.addHighCorner(random, generator);
        generator.translate(-xSize * superGridSize, ySize * superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(xSize * superGridSize, -ySize * superGridSize, 0.0);
        BehaviorPlanarRegionEnvironments.addHighCorner(random, generator);
        generator.translate(-xSize * superGridSize, ySize * superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(xSize * superGridSize, -ySize * superGridSize, 0.0);
        BehaviorPlanarRegionEnvironments.addHighCorner(random, generator);
        generator.translate(-xSize * superGridSize, ySize * superGridSize, 0.0);
        return generator.getPlanarRegionsList();
    }

    private static void addHighCorner(Random random, PlanarRegionsListGenerator generator) {
        BehaviorPlanarRegionEnvironments.addTopFlatRegionOld(generator);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(0.0, -superGridSize, 0.0);
        generator.translate(3.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(3.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.translate(3.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateCorner(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
    }

    private static void addXFormationSlopes(Random random, PlanarRegionsListGenerator generator) {
        generator.translate(0.0, -superGridSize, 0.0);
        BehaviorPlanarRegionEnvironments.generateCorner(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(3.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateCorner(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(3.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateCorner(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(3.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateCorner(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, 0.0, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
    }

    private static void addPlusFormationSlopes(Random random, PlanarRegionsListGenerator generator) {
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        BehaviorPlanarRegionEnvironments.generateAngledCinderBlockSteps(random, generator, cinderSquareSurfaceSize, cinderThickness);
        generator.translate(2.0 * superGridSize, -superGridSize, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Z);
    }

    private static void addTopFlatRegionOld(PlanarRegionsListGenerator generator) {
        BehaviorPlanarRegionEnvironments.offsetGrid(generator, superGridSize, 0.0, topRegionHeight, () -> generator.addCubeReferencedAtBottomNegativeXYCorner(superGridSize, superGridSize, cinderThickness));
    }

    private static void addTopFlatRegion(PlanarRegionsListGenerator generator) {
        generator.addCubeReferencedAtBottomNegativeXYCorner(superGridSize, superGridSize, cinderThickness);
    }

    private static void generateAngledCinderBlockSteps(Random random, PlanarRegionsListGenerator generator) {
        PlanarRegionsListExamples.generateCinderBlockSlope((PlanarRegionsListGenerator)generator, (Random)random, (double)cinderSquareSurfaceSize, (double)cinderThickness, (int)3, (int)3, (double)0.1, (double)0.0, (double)0.0, (double)Math.toRadians(13.0), (double)0.0);
    }

    private static void generateFlatCinderBlockSteps(PlanarRegionsListGenerator generator) {
        PlanarRegionsListExamples.generateFlatCinderBlockSteps((PlanarRegionsListGenerator)generator, (double)cinderSquareSurfaceSize, (double)cinderThickness, (int)3, (int)3, (double)0.15);
    }

    private static void generateAngledCinderBlockSteps(Random random, PlanarRegionsListGenerator generator, double cinderSquareSurfaceSize, double cinderThickness) {
        PlanarRegionsListExamples.generateCinderBlockSlope((PlanarRegionsListGenerator)generator, (Random)random, (double)cinderSquareSurfaceSize, (double)cinderThickness, (int)3, (int)3, (double)0.1, (double)0.0, (double)0.0, (double)Math.toRadians(13.0), (double)0.0);
    }

    private static void generateCorner(Random random, PlanarRegionsListGenerator generator, double cinderSquareSurfaceSize, double cinderThickness) {
        PlanarRegionsListExamples.generateCinderBlockCornerSlope((PlanarRegionsListGenerator)generator, (Random)random, (double)cinderSquareSurfaceSize, (double)cinderThickness, (int)3, (int)3, (double)0.1, (double)0.0, (double)0.0, (double)Math.toRadians(0.0), (double)0.0);
    }

    private static void offsetGrid(PlanarRegionsListGenerator generator, double x, double y, Runnable runnable) {
        BehaviorPlanarRegionEnvironments.offsetGrid(generator, x, y, 0.0, runnable);
    }

    private static void offsetGrid(PlanarRegionsListGenerator generator, double x, double y, double z, Runnable runnable) {
        generator.translate(x * superGridSize, y * superGridSize, z * superGridSize);
        runnable.run();
        generator.translate(-x * superGridSize, -y * superGridSize, -z * superGridSize);
    }

    private static void rotate(PlanarRegionsListGenerator generator, double yaw, Runnable runnable) {
        generator.rotate(yaw, Axis3D.Z);
        runnable.run();
        generator.rotate(-yaw, Axis3D.Z);
    }

    public static void main(String[] args) {
        PlanarRegionsList roughUpAndDownStairsWithFlatTop = BehaviorPlanarRegionEnvironments.createRoughUpAndDownStepsWithFlatTop();
        PlanarRegionFileTools.exportPlanarRegionData((Path)Paths.get(System.getProperty("user.home") + File.separator + "PlanarRegions" + File.separator, new String[0]), (PlanarRegionsList)roughUpAndDownStairsWithFlatTop);
    }

    public static PlanarRegionsList realDataFromAtlasSLAMDataset20190710() {
        PlanarRegionsList map = PlanarRegionsList.flatGround((double)10.0);
        PlanarRegionSLAMParameters parameters = new PlanarRegionSLAMParameters();
        map = PlanarRegionSLAM.slam((PlanarRegionsList)map, (PlanarRegionsList)BehaviorPlanarRegionEnvironments.loadDataSet("20190710_174025_PlanarRegion"), (PlanarRegionSLAMParameters)parameters).getMergedMap();
        map = PlanarRegionSLAM.slam((PlanarRegionsList)map, (PlanarRegionsList)BehaviorPlanarRegionEnvironments.loadDataSet("IntentionallyDrifted"), (PlanarRegionSLAMParameters)parameters).getMergedMap();
        map = PlanarRegionSLAM.slam((PlanarRegionsList)map, (PlanarRegionsList)BehaviorPlanarRegionEnvironments.loadDataSet("20190710_174422_PlanarRegion"), (PlanarRegionSLAMParameters)parameters).getMergedMap();
        return map;
    }

    private static PlanarRegionsList loadDataSet(String dataSetName) {
        return PlanarRegionFileTools.importPlanarRegionData((ClassLoader)ClassLoader.getSystemClassLoader(), (String)("us/ihmc/pathPlanning/dataSets/20190710_SLAM_PlanarRegionFittingExamples/" + dataSetName));
    }

    static interface GenerationInterface {
        public void generate(Random var1, PlanarRegionsListGenerator var2);
    }
}

