/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.factory;

import java.util.List;
import us.ihmc.avatar.factory.DisposableRobotController;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierScheduler;
import us.ihmc.robotics.time.ThreadTimer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BarrierScheduledRobotController
implements DisposableRobotController {
    private final YoRegistry registry;
    private final BarrierScheduler<HumanoidRobotContextData> barrierScheduler;
    private final HumanoidRobotContextData masterContext;
    private final ThreadTimer timer;

    public BarrierScheduledRobotController(String name, List<HumanoidRobotControlTask> tasks, HumanoidRobotContextData masterContext, BarrierScheduler.TaskOverrunBehavior overrunBehavior, double schedulerDt) {
        this.masterContext = masterContext;
        this.barrierScheduler = new BarrierScheduler(tasks, (Object)masterContext, overrunBehavior);
        this.registry = new YoRegistry(name);
        this.timer = new ThreadTimer("Scheduler", schedulerDt, this.registry);
    }

    public void initialize() {
        this.masterContext.setControllerRan(false);
        this.masterContext.setEstimatorRan(false);
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public void doControl() {
        this.timer.start();
        this.masterContext.setSchedulerTick(this.timer.getTickCount());
        this.barrierScheduler.run();
        this.timer.stop();
    }

    @Override
    public void dispose() {
        this.barrierScheduler.shutdown();
    }
}

