/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.GuiInitialSetup;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.NullGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.dataExporter.TorqueSpeedDataExporter;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class DRCGuiInitialSetup
implements GuiInitialSetup {
    private static final boolean SHOW_ONLY_WRENCH_VISUALIZER = false;
    private static final boolean SHOW_EXPORT_TORQUE_AND_SPEED = true;
    private static final boolean SHOW_OVERHEAD_VIEW = true;
    public static final boolean MAKE_SLIDER_BOARD = false;
    private final SimulationConstructionSetParameters simulationConstructionSetParameters;
    private boolean hasGraphics3DAdapterBeenSet = false;
    private Graphics3DAdapter graphics3DAdapter = null;
    private boolean is3dGraphicsShown = true;
    private final boolean groundProfileVisible;
    private final boolean drawPlaneAtZ0;
    private boolean showOverheadView = true;

    public DRCGuiInitialSetup(boolean groundProfileVisible, boolean drawPlaneAtZeroHeight, SimulationConstructionSetParameters simulationConstructionSetParameters) {
        this.groundProfileVisible = groundProfileVisible;
        this.drawPlaneAtZ0 = drawPlaneAtZeroHeight;
        this.simulationConstructionSetParameters = simulationConstructionSetParameters;
    }

    public DRCGuiInitialSetup(boolean groundProfileVisible, boolean drawPlaneAtZeroHeight) {
        this(groundProfileVisible, drawPlaneAtZeroHeight, true);
    }

    public DRCGuiInitialSetup(boolean groundProfileVisible, boolean drawPlaneAtZeroHeight, boolean showGUI) {
        this(groundProfileVisible, drawPlaneAtZeroHeight, new SimulationConstructionSetParameters(showGUI));
    }

    @Override
    public SimulationConstructionSetParameters getSimulationConstructionSetParameters() {
        return this.simulationConstructionSetParameters;
    }

    @Override
    public void initializeGUI(SimulationConstructionSet scs, Robot robot) {
        throw new RuntimeException("Should not be here. This function is a relict of the GuiInitialSetup interface.");
    }

    public void initializeGUI(SimulationConstructionSet scs, Robot robot, DRCRobotModel robotModel) {
        CameraConfiguration behindPelvis = new CameraConfiguration("BehindPelvis");
        behindPelvis.setCameraTracking(false, true, true, false);
        behindPelvis.setCameraDolly(false, true, true, false);
        behindPelvis.setCameraFix(0.0, 0.0, 1.0);
        behindPelvis.setCameraPosition(-2.5, 0.0, 1.0);
        behindPelvis.setCameraTrackingVars("q_x", "q_y", "q_z");
        scs.setupCamera(behindPelvis);
        HumanoidRobotSensorInformation sensorInformation = robotModel.getSensorInformation();
        AvatarRobotCameraParameters[] cameraInfo = sensorInformation.getCameraParameters();
        if (cameraInfo != null) {
            for (int i = 0; i < cameraInfo.length; ++i) {
                CameraConfiguration camera = new CameraConfiguration(cameraInfo[i].getSensorNameInSdf());
                camera.setCameraMount(cameraInfo[i].getSensorNameInSdf());
                scs.setupCamera(camera);
            }
        }
        scs.setGroundVisible(this.groundProfileVisible);
        if (this.drawPlaneAtZ0) {
            Graphics3DObject planeAtZ0 = new Graphics3DObject();
            FlatGroundProfile heightMap = new FlatGroundProfile();
            planeAtZ0.addHeightMap((HeightMap)heightMap, 100, 100, null);
            scs.addStaticLinkGraphics(planeAtZ0);
        }
        if (!this.is3dGraphicsShown) {
            scs.hideViewport();
        }
        JButton exportTorqueAndSpeedButton = new JButton("Export Torque And Speed");
        TorqueSpeedDataExporter dataExporter = new TorqueSpeedDataExporter(scs, robot);
        dataExporter.setRootDirectory("D:/DataAndVideos/");
        exportTorqueAndSpeedButton.addActionListener((ActionListener)dataExporter);
        scs.addButton((AbstractButton)exportTorqueAndSpeedButton);
    }

    @Override
    public boolean isGuiShown() {
        return this.simulationConstructionSetParameters.getCreateGUI();
    }

    public boolean getShowWindow() {
        return this.simulationConstructionSetParameters.getShowWindows();
    }

    public void setCreateGUI(boolean createGUI) {
        this.simulationConstructionSetParameters.setCreateGUI(createGUI);
    }

    public void setShowWindow(boolean showWindow) {
        this.simulationConstructionSetParameters.setShowSplashScreen(showWindow);
        this.simulationConstructionSetParameters.setShowWindows(showWindow);
    }

    public void setGraphics3DAdapter(Graphics3DAdapter graphics3DAdapter) {
        if (this.hasGraphics3DAdapterBeenSet) {
            throw new IllegalOperationException("The graphics adapter has already been set.");
        }
        this.hasGraphics3DAdapterBeenSet = true;
        this.graphics3DAdapter = graphics3DAdapter;
    }

    @Override
    public Graphics3DAdapter getGraphics3DAdapter() {
        if (!this.hasGraphics3DAdapterBeenSet) {
            this.hasGraphics3DAdapterBeenSet = true;
            this.graphics3DAdapter = this.simulationConstructionSetParameters.getCreateGUI() && this.is3dGraphicsShown ? new JMEGraphics3DAdapter() : (this.simulationConstructionSetParameters.getCreateGUI() ? new NullGraphics3DAdapter() : null);
        }
        return this.graphics3DAdapter;
    }

    public void setIs3dGraphicsShown(boolean is3dGraphicsShown) {
        this.is3dGraphicsShown = is3dGraphicsShown;
    }

    public boolean isShowOverheadView() {
        return this.showOverheadView;
    }

    public void setShowOverheadView(boolean showOverheadView) {
        this.showOverheadView = showOverheadView;
    }
}

