/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.simulationconstructionset.Robot;

public interface DRCRobotInitialSetup<T extends Robot> {
    public void initializeRobot(T var1, HumanoidJointNameMap var2);

    default public List<Double> getInitialJointAngles() {
        LogTools.warn((String)"Please implement getInitialJointAngles");
        return null;
    }

    default public Pose3DReadOnly getInitialPelvisPose() {
        LogTools.warn((String)"Please implement getInitialPelvisPose");
        return null;
    }

    default public void initializeFullRobotModel(FullHumanoidRobotModel fullRobotModel) {
        Pose3DReadOnly initialPelvisPose;
        OneDoFJointBasics[] allJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        List<Double> initialJointAngles = this.getInitialJointAngles();
        if (initialJointAngles != null) {
            for (int i = 0; i < initialJointAngles.size(); ++i) {
                allJointsExcludingHands[i].setQ(initialJointAngles.get(i).doubleValue());
                allJointsExcludingHands[i].setQd(0.0);
            }
        }
        if ((initialPelvisPose = this.getInitialPelvisPose()) != null) {
            fullRobotModel.getRootJoint().getJointPose().set(initialPelvisPose);
        }
        fullRobotModel.getRootJoint().setJointVelocity(0, (DMatrix)new DMatrixRMaj(6, 1));
        fullRobotModel.getRootJoint().getPredecessor().updateFramesRecursively();
    }

    public void setInitialYaw(double var1);

    public double getInitialYaw();

    public void setInitialGroundHeight(double var1);

    public double getInitialGroundHeight();

    public void setOffset(Vector3D var1);

    public void getOffset(Vector3D var1);

    @Deprecated
    default public boolean supportsReset() {
        return false;
    }
}

