/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import java.util.HashMap;
import java.util.Map;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;

public class HumanoidRobotMutableInitialSetup
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    public final Point3D rootJointPosition = new Point3D();
    public final Quaternion rootJointOrientation = new Quaternion();
    public final Map<String, Double> jointPositions = new HashMap<String, Double>();
    public final HumanoidJointNameMap jointMap;

    public HumanoidRobotMutableInitialSetup(HumanoidJointNameMap jointMap) {
        this.jointMap = jointMap;
    }

    @Override
    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        robot.getRootJoint().setPosition((Tuple3DReadOnly)this.rootJointPosition);
        robot.getRootJoint().setOrientation((Orientation3DReadOnly)this.rootJointOrientation);
        for (Map.Entry<String, Double> entry : this.jointPositions.entrySet()) {
            robot.getOneDegreeOfFreedomJoint(entry.getKey()).setQ(entry.getValue().doubleValue());
        }
        robot.update();
    }

    protected void setJoint(RobotSide robotSide, LegJointName legJointName, double q) {
        this.jointPositions.put(this.jointMap.getLegJointName(robotSide, legJointName), q);
    }

    protected void setJoint(RobotSide robotSide, ArmJointName armJointName, double q) {
        this.jointPositions.put(this.jointMap.getArmJointName(robotSide, armJointName), q);
    }

    protected void setJoint(SpineJointName spineJointName, double q) {
        this.jointPositions.put(this.jointMap.getSpineJointName(spineJointName), q);
    }

    protected void setJoint(NeckJointName neckJointName, double q) {
        this.jointPositions.put(this.jointMap.getNeckJointName(neckJointName), q);
    }

    @Override
    public void setInitialYaw(double yaw) {
    }

    @Override
    public double getInitialYaw() {
        return 0.0;
    }

    @Override
    public void setInitialGroundHeight(double groundHeight) {
    }

    @Override
    public double getInitialGroundHeight() {
        return 0.0;
    }

    @Override
    public void setOffset(Vector3D additionalOffset) {
    }

    @Override
    public void getOffset(Vector3D offsetToPack) {
    }

    public double getJointPosition(String jointName) {
        return this.jointPositions.get(jointName);
    }

    public Map<String, Double> getJointPositions() {
        return this.jointPositions;
    }

    public Point3D getRootJointPosition() {
        return this.rootJointPosition;
    }

    public Quaternion getRootJointOrientation() {
        return this.rootJointOrientation;
    }
}

