/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import controller_msgs.msg.dds.RobotConfigurationData;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.idl.IDLSequence;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;

public class RobotConfigurationDataInitialSetup
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    private final RobotConfigurationData robotConfigurationData;
    private final OneDoFJointBasics[] allJointsExcludingHands;

    public RobotConfigurationDataInitialSetup(RobotConfigurationData robotConfigurationData, FullHumanoidRobotModel fullHumanoidRobotModel) {
        this.robotConfigurationData = robotConfigurationData;
        this.allJointsExcludingHands = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullHumanoidRobotModel);
    }

    @Override
    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        robot.getRootJoint().setPosition((Tuple3DReadOnly)this.robotConfigurationData.getRootTranslation());
        robot.getRootJoint().setQuaternion((QuaternionReadOnly)this.robotConfigurationData.getRootOrientation());
        IDLSequence.Float jointAngles = this.robotConfigurationData.getJointAngles();
        IDLSequence.Float jointVelocities = this.robotConfigurationData.getJointVelocities();
        for (int i = 0; i < this.allJointsExcludingHands.length; ++i) {
            String jointName = this.allJointsExcludingHands[i].getName();
            OneDegreeOfFreedomJoint joint = robot.getOneDegreeOfFreedomJoint(jointName);
            joint.setQ((double)jointAngles.get(i));
            joint.setQd((double)jointVelocities.get(i));
        }
    }

    @Override
    public void setInitialYaw(double yaw) {
    }

    @Override
    public double getInitialYaw() {
        return this.robotConfigurationData.getRootOrientation().getYaw();
    }

    @Override
    public void setInitialGroundHeight(double groundHeight) {
    }

    @Override
    public double getInitialGroundHeight() {
        return this.robotConfigurationData.getRootTranslation().getZ();
    }

    @Override
    public void setOffset(Vector3D additionalOffset) {
    }

    @Override
    public void getOffset(Vector3D offsetToPack) {
        offsetToPack.set(this.robotConfigurationData.getRootTranslation());
    }
}

