/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.initialSetup;

import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.GroundContactPoint;

public class SquaredUpDRCRobotInitialSetup
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    private double groundZ;
    private final RigidBodyTransform rootToWorld = new RigidBodyTransform();
    private final Vector3D offset = new Vector3D();

    public SquaredUpDRCRobotInitialSetup() {
        this(0.0);
    }

    public SquaredUpDRCRobotInitialSetup(double groundZ) {
        this.groundZ = groundZ;
    }

    @Override
    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        this.setArmJointPositions((FloatingRootJointRobot)robot);
        this.setLegJointPositions((FloatingRootJointRobot)robot);
        this.setPositionInWorld(robot);
    }

    protected void setPositionInWorld(HumanoidFloatingRootJointRobot robot) {
        robot.update();
        robot.getRootJointToWorldTransform(this.rootToWorld);
        this.offset.set((Tuple3DReadOnly)this.rootToWorld.getTranslation());
        Vector3D positionInWorld = new Vector3D();
        positionInWorld.set((Tuple3DReadOnly)this.rootToWorld.getTranslation());
        GroundContactPoint gc1 = (GroundContactPoint)robot.getFootGroundContactPoints(RobotSide.LEFT).get(0);
        double pelvisToFoot = positionInWorld.getZ() - gc1.getPositionCopy().getZ();
        this.offset.setZ(this.groundZ + pelvisToFoot);
        robot.setPositionInWorld((Tuple3DReadOnly)this.offset);
    }

    protected void setArmJointPositions(FloatingRootJointRobot robot) {
    }

    protected void setLegJointPositions(FloatingRootJointRobot robot) {
    }

    @Override
    public void getOffset(Vector3D offsetToPack) {
        offsetToPack.set(this.offset);
    }

    @Override
    public void setOffset(Vector3D offset) {
        this.offset.set(offset);
    }

    @Override
    public void setInitialYaw(double yaw) {
    }

    @Override
    public void setInitialGroundHeight(double groundHeight) {
        this.groundZ = groundHeight;
    }

    @Override
    public double getInitialYaw() {
        return 0.0;
    }

    @Override
    public double getInitialGroundHeight() {
        return this.groundZ;
    }
}

