/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.PlanarRegionsListMessage;
import controller_msgs.msg.dds.REAStateRequestMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingControllerFailureStatusMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import us.ihmc.avatar.joystickBasedJavaFXController.ButtonState;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotKickMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotPunchMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.JoystickStepParametersProperty;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorJavaFXTopics;
import us.ihmc.avatar.joystickBasedJavaFXController.XBoxOneJavaFXController;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.ContinuousStepGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.communication.packets.PlanarRegionMessageConverter;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.footstepPlanning.graphSearch.collision.BoundingBoxCollisionDetector;
import us.ihmc.footstepPlanning.polygonSnapping.PlanarRegionsListPolygonSnapper;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStep;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStepParameters;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javafx.JavaFXRobotVisualizer;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class StepGeneratorJavaFXController {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory((String)"FootstepPublisher"));
    private final SideDependentList<Color> footColors = new SideDependentList((Object)Color.CRIMSON, (Object)Color.YELLOWGREEN);
    private final ContinuousStepGenerator continuousStepGenerator = new ContinuousStepGenerator();
    private final DoubleProperty turningVelocityProperty = new SimpleDoubleProperty((Object)this, "turningVelocityProperty", 0.0);
    private final DoubleProperty forwardVelocityProperty = new SimpleDoubleProperty((Object)this, "forwardVelocityProperty", 0.0);
    private final DoubleProperty lateralVelocityProperty = new SimpleDoubleProperty((Object)this, "lateralVelocityProperty", 0.0);
    private final AnimationTimer animationTimer = new AnimationTimer(){

        public void handle(long now) {
            StepGeneratorJavaFXController.this.update(now);
        }
    };
    private final AtomicReference<List<Node>> footstepsToVisualizeReference = new AtomicReference<Object>(null);
    private final Group rootNode = new Group();
    private final AtomicReference<FootstepDataListMessage> footstepsToSendReference = new AtomicReference<Object>(null);
    private final AtomicReference<JoystickStepParametersProperty.JoystickStepParameters> stepParametersReference;
    private final AtomicReference<Double> trajectoryDuration;
    private final AtomicBoolean isWalking = new AtomicBoolean(false);
    private final AtomicBoolean hasSuccessfullyStoppedWalking = new AtomicBoolean(false);
    private final JavaFXRobotVisualizer javaFXRobotVisualizer;
    private final AtomicBoolean isLeftFootInSupport = new AtomicBoolean(false);
    private final AtomicBoolean isRightFootInSupport = new AtomicBoolean(false);
    private final SideDependentList<AtomicBoolean> isFootInSupport = new SideDependentList((Object)this.isLeftFootInSupport, (Object)this.isRightFootInSupport);
    private final BooleanProvider isInDoubleSupport = () -> this.isLeftFootInSupport.get() && this.isRightFootInSupport.get();
    private final DoubleProvider stepTime;
    private final BoundingBoxCollisionDetector collisionDetector;
    private final SteppingParameters steppingParameters;
    private final SnapAndWiggleSingleStepParameters snapAndWiggleParameters = new SnapAndWiggleSingleStepParameters();
    private SecondaryControlOption activeSecondaryControlOption = SecondaryControlOption.KICK;
    private final HumanoidRobotKickMessenger kickMessenger;
    private final HumanoidRobotPunchMessenger punchMessenger;
    private final IHMCROS2Publisher<FootstepDataListMessage> footstepPublisher;
    private final IHMCROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;
    private final IHMCROS2Publisher<REAStateRequestMessage> reaStateRequestPublisher;
    private final AtomicReference<PlanarRegionsListMessage> planarRegionsListMessage = new AtomicReference<Object>(null);
    private final AtomicReference<PlanarRegionsList> planarRegionsList = new AtomicReference<Object>(null);
    private final SnapAndWiggleSingleStep snapAndWiggleSingleStep;
    private final SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons;
    private final ConvexPolygon2D footPolygonToWiggle = new ConvexPolygon2D();
    private boolean supportFootPosesInitialized = false;
    private final SideDependentList<FramePose3D> lastSupportFootPoses = new SideDependentList(null, null);
    private final ConcurrentLinkedQueue<Runnable> queuedTasksToProcess = new ConcurrentLinkedQueue();
    private final AtomicReference<Boolean> walkingRequest = new AtomicReference<Object>(null);
    private final ConvexPolygon2D footPolygon = new ConvexPolygon2D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final PlanarRegion tempRegion = new PlanarRegion();

    public StepGeneratorJavaFXController(String robotName, JavaFXMessager messager, WalkingControllerParameters walkingControllerParameters, ROS2Node ros2Node, JavaFXRobotVisualizer javaFXRobotVisualizer, HumanoidRobotKickMessenger kickMessenger, HumanoidRobotPunchMessenger punchMessenger, RobotLowLevelMessenger lowLevelMessenger, SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons) {
        this.javaFXRobotVisualizer = javaFXRobotVisualizer;
        this.kickMessenger = kickMessenger;
        this.punchMessenger = punchMessenger;
        this.footPolygons = footPolygons;
        this.continuousStepGenerator.setNumberOfFootstepsToPlan(10);
        this.continuousStepGenerator.setDesiredTurningVelocityProvider(() -> this.turningVelocityProperty.get());
        this.continuousStepGenerator.setDesiredVelocityProvider(() -> new Vector2D(this.forwardVelocityProperty.get(), this.lateralVelocityProperty.get()));
        this.continuousStepGenerator.configureWith(walkingControllerParameters);
        this.continuousStepGenerator.setFootstepAdjustment(this::adjustFootstep);
        this.continuousStepGenerator.setFootstepMessenger(this::prepareFootsteps);
        this.continuousStepGenerator.setFootPoseProvider(robotSide -> (FramePose3D)this.lastSupportFootPoses.get((Enum)robotSide));
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isStepSnappable);
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isSafeDistanceFromObstacle);
        this.continuousStepGenerator.addFootstepValidityIndicator(this::isSafeStepHeight);
        this.snapAndWiggleParameters.setFootLength(walkingControllerParameters.getSteppingParameters().getFootLength());
        this.snapAndWiggleSingleStep = new SnapAndWiggleSingleStep(this.snapAndWiggleParameters);
        this.steppingParameters = walkingControllerParameters.getSteppingParameters();
        this.stepParametersReference = messager.createInput(StepGeneratorJavaFXTopics.SteppingParameters, (Object)new JoystickStepParametersProperty.JoystickStepParameters(walkingControllerParameters));
        ROS2Topic controllerOutputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ROS2Topic controllerInputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)controllerOutputTopic, s -> {
            RobotMotionStatus newStatus = RobotMotionStatus.fromByte((byte)((RobotConfigurationData)s.takeNextData()).getRobotMotionStatus());
            if (this.hasSuccessfullyStoppedWalking.get() || this.isWalking.get()) {
                return;
            }
            if (newStatus == null) {
                return;
            }
            if (newStatus == RobotMotionStatus.STANDING) {
                this.hasSuccessfullyStoppedWalking.set(true);
            }
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, FootstepStatusMessage.class, (ROS2Topic)controllerOutputTopic, s -> {
            FootstepStatusMessage footstepStatus = (FootstepStatusMessage)s.takeNextData();
            this.queuedTasksToProcess.add(() -> {
                this.continuousStepGenerator.consumeFootstepStatus(footstepStatus);
                if (footstepStatus.getFootstepStatus() == FootstepStatus.COMPLETED.toByte()) {
                    this.lastSupportFootPoses.put((Enum)RobotSide.fromByte((byte)footstepStatus.getRobotSide()), (Object)new FramePose3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)footstepStatus.getActualFootPositionInWorld(), (Orientation3DReadOnly)footstepStatus.getActualFootOrientationInWorld()));
                }
            });
        });
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, PlanarRegionsListMessage.class, (ROS2Topic)REACommunicationProperties.outputTopic, s -> this.planarRegionsListMessage.set((PlanarRegionsListMessage)s.takeNextData()));
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PauseWalkingMessage.class, (ROS2Topic)controllerInputTopic);
        this.footstepPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, FootstepDataListMessage.class, (ROS2Topic)controllerInputTopic);
        this.reaStateRequestPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, REAStateRequestMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic);
        this.trajectoryDuration = messager.createInput(StepGeneratorJavaFXTopics.WalkingTrajectoryDuration, (Object)1.0);
        this.stepTime = () -> this.stepParametersReference.get().getSwingDuration() + this.stepParametersReference.get().getTransferDuration();
        this.setupKickAction(messager);
        this.setupPunchAction(messager);
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonLeftBumperState, state -> {
            if (state == ButtonState.PRESSED) {
                this.sendArmHomeConfiguration(RobotSide.values);
            }
        });
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonRightBumperState, state -> {
            if (state == ButtonState.PRESSED) {
                this.walkingRequest.set(true);
            } else if (state == ButtonState.RELEASED) {
                this.walkingRequest.set(false);
            }
        });
        messager.registerJavaFXSyncedTopicListener(XBoxOneJavaFXController.LeftStickYAxis, this::updateForwardVelocity);
        messager.registerJavaFXSyncedTopicListener(XBoxOneJavaFXController.LeftStickXAxis, this::updateLateralVelocity);
        messager.registerJavaFXSyncedTopicListener(XBoxOneJavaFXController.RightStickXAxis, this::updateTurningVelocity);
        messager.registerTopicListener(XBoxOneJavaFXController.DPadLeftState, state -> this.sendREAResumeRequest());
        messager.registerTopicListener(XBoxOneJavaFXController.DPadDownState, state -> this.sendREAClearRequest());
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, WalkingControllerFailureStatusMessage.class, (ROS2Topic)controllerOutputTopic, s -> this.walkingRequest.set(false));
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonSelectState, state -> this.walkingRequest.set(false));
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonSelectState, state -> lowLevelMessenger.sendFreezeRequest());
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonStartState, state -> this.walkingRequest.set(false));
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonStartState, state -> lowLevelMessenger.sendStandRequest());
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, CapturabilityBasedStatus.class, (ROS2Topic)controllerOutputTopic, s -> {
            CapturabilityBasedStatus status = (CapturabilityBasedStatus)s.takeNextData();
            this.queuedTasksToProcess.add(() -> {
                this.isLeftFootInSupport.set(!status.getLeftFootSupportPolygon3d().isEmpty());
                this.isRightFootInSupport.set(!status.getRightFootSupportPolygon3d().isEmpty());
            });
        });
        double collisionBoxDepth = 0.65;
        double collisionBoxWidth = 1.15;
        double collisionBoxHeight = 1.0;
        this.collisionDetector = new BoundingBoxCollisionDetector();
        this.collisionDetector.setBoxDimensions(collisionBoxDepth, collisionBoxWidth, collisionBoxHeight);
    }

    public void update(long now) {
        try {
            Boolean newWalkingRequest;
            while (!this.queuedTasksToProcess.isEmpty()) {
                this.queuedTasksToProcess.poll().run();
            }
            if (!this.supportFootPosesInitialized && this.javaFXRobotVisualizer.isRobotConfigurationInitialized()) {
                if (this.isLeftFootInSupport.get() && this.isRightFootInSupport.get()) {
                    for (RobotSide robotSide : RobotSide.values) {
                        this.lastSupportFootPoses.put((Enum)robotSide, (Object)new FramePose3D((ReferenceFrame)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrame((Enum)robotSide)));
                    }
                    this.supportFootPosesInitialized = true;
                } else {
                    for (RobotSide robotSide : RobotSide.values) {
                        if (((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get()) continue;
                        LogTools.warn((String)(robotSide.getPascalCaseName() + " foot is not in support, cannot initialize foot poses."));
                    }
                }
            }
            if (!this.supportFootPosesInitialized) {
                return;
            }
            for (RobotSide robotSide : RobotSide.values) {
                MovingReferenceFrame soleFrame;
                double currentHeight;
                if (!((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get() || !((currentHeight = (soleFrame = this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrame((Enum)robotSide)).getTransformToWorldFrame().getTranslationZ()) < ((FramePose3D)this.lastSupportFootPoses.get((Enum)robotSide)).getZ())) continue;
                this.lastSupportFootPoses.put((Enum)robotSide, (Object)new FramePose3D((ReferenceFrame)soleFrame));
            }
            PlanarRegionsListMessage latestMessage = this.planarRegionsListMessage.getAndSet(null);
            if (latestMessage != null) {
                PlanarRegionsList planarRegionsList = PlanarRegionMessageConverter.convertToPlanarRegionsList((PlanarRegionsListMessage)latestMessage);
                this.snapAndWiggleSingleStep.setPlanarRegions(planarRegionsList);
                this.collisionDetector.setPlanarRegionsList(new PlanarRegionsList(planarRegionsList.getPlanarRegionsAsList().stream().filter(region -> region.getConvexHull().getArea() >= this.snapAndWiggleParameters.getMinPlanarRegionArea()).collect(Collectors.toList())));
                this.planarRegionsList.set(planarRegionsList);
            }
            if ((newWalkingRequest = (Boolean)this.walkingRequest.getAndSet(null)) != null) {
                if (newWalkingRequest.booleanValue()) {
                    this.startWalking(true);
                } else {
                    this.stopWalking(true);
                }
            }
            JoystickStepParametersProperty.JoystickStepParameters stepParameters = this.stepParametersReference.get();
            this.continuousStepGenerator.setFootstepTiming(stepParameters.getSwingDuration(), stepParameters.getTransferDuration());
            this.continuousStepGenerator.setStepTurningLimits(stepParameters.getTurnMaxAngleInward(), stepParameters.getTurnMaxAngleOutward());
            this.continuousStepGenerator.setStepWidths(stepParameters.getDefaultStepWidth(), stepParameters.getMinStepWidth(), stepParameters.getMaxStepWidth());
            this.continuousStepGenerator.setMaxStepLength(stepParameters.getMaxStepLength());
            this.continuousStepGenerator.update(Double.NaN);
            List footstepsToVisualize = this.footstepsToVisualizeReference.getAndSet(null);
            ObservableList children = this.rootNode.getChildren();
            if (!this.continuousStepGenerator.isWalking()) {
                children.clear();
            } else if (footstepsToVisualize != null) {
                children.clear();
                children.addAll((Collection)footstepsToVisualize);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LogTools.error((String)"Caught exception, stopping animation timer.");
            this.stop();
        }
    }

    private FramePose3DReadOnly adjustFootstep(FramePose2DReadOnly footstepPose, RobotSide footSide) {
        FramePose3D adjustedBasedOnStanceFoot = new FramePose3D();
        adjustedBasedOnStanceFoot.getPosition().set((FrameTuple2DReadOnly)footstepPose.getPosition());
        adjustedBasedOnStanceFoot.setZ(this.continuousStepGenerator.getCurrentSupportFootPose().getZ());
        adjustedBasedOnStanceFoot.getOrientation().set(footstepPose.getOrientation());
        if (this.planarRegionsList.get() != null) {
            FramePose3D wiggledPose = new FramePose3D((FramePose3DReadOnly)adjustedBasedOnStanceFoot);
            this.footPolygonToWiggle.set((Vertex2DSupplier)this.footPolygons.get((Enum)footSide));
            try {
                this.snapAndWiggleSingleStep.snapAndWiggle(wiggledPose, (ConvexPolygon2DReadOnly)this.footPolygonToWiggle, this.forwardVelocityProperty.get() > 0.0);
                if (wiggledPose.containsNaN()) {
                    return adjustedBasedOnStanceFoot;
                }
            }
            catch (SnapAndWiggleSingleStep.SnappingFailedException snappingFailedException) {
                // empty catch block
            }
            return wiggledPose;
        }
        return adjustedBasedOnStanceFoot;
    }

    public void setActiveSecondaryControlOption(SecondaryControlOption activeSecondaryControlOption) {
        this.activeSecondaryControlOption = activeSecondaryControlOption;
    }

    private void setupPunchAction(JavaFXMessager messager) {
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonXState, state -> this.processPunch(RobotSide.LEFT, (ButtonState)((Object)state)));
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonYState, state -> this.processPunch(RobotSide.RIGHT, (ButtonState)((Object)state)));
    }

    private void setupKickAction(JavaFXMessager messager) {
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonXState, state -> this.processToggleFlamingoMode(RobotSide.LEFT, (ButtonState)((Object)state)));
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonBState, state -> this.processToggleFlamingoMode(RobotSide.RIGHT, (ButtonState)((Object)state)));
        messager.registerTopicListener(XBoxOneJavaFXController.ButtonYState, state -> this.processKick((ButtonState)((Object)state)));
    }

    private void updateForwardVelocity(double alpha) {
        double minMaxVelocity = this.stepParametersReference.get().getMaxStepLength() / this.stepTime.getValue();
        this.forwardVelocityProperty.set(minMaxVelocity * MathTools.clamp((double)alpha, (double)1.0));
    }

    private void updateLateralVelocity(double alpha) {
        double minMaxVelocity = this.stepParametersReference.get().getMaxStepWidth() / this.stepTime.getValue();
        this.lateralVelocityProperty.set(minMaxVelocity * MathTools.clamp((double)alpha, (double)1.0));
    }

    private void updateTurningVelocity(double alpha) {
        double minMaxVelocity = (this.stepParametersReference.get().getTurnMaxAngleOutward() - this.stepParametersReference.get().getTurnMaxAngleInward()) / this.stepTime.getValue();
        if (this.forwardVelocityProperty.get() < -1.0E-10) {
            alpha = -alpha;
        }
        this.turningVelocityProperty.set(minMaxVelocity * MathTools.clamp((double)alpha, (double)1.0));
    }

    private void startWalking(boolean confirm) {
        if (confirm) {
            this.isWalking.set(true);
            this.continuousStepGenerator.startWalking();
            this.hasSuccessfullyStoppedWalking.set(false);
        }
    }

    private void stopWalking(boolean confirm) {
        if (confirm) {
            this.isWalking.set(false);
            this.footstepsToSendReference.set(null);
            this.continuousStepGenerator.stopWalking();
            this.sendPauseMessage();
        }
    }

    private void sendPauseMessage() {
        PauseWalkingMessage pauseWalkingMessage = new PauseWalkingMessage();
        pauseWalkingMessage.setPause(true);
        this.pauseWalkingPublisher.publish((Object)pauseWalkingMessage);
    }

    private void prepareFootsteps(FootstepDataListMessage footstepDataListMessage) {
        ArrayList<Node> footstepNode = new ArrayList<Node>();
        for (int i = 0; i < footstepDataListMessage.getFootstepDataList().size(); ++i) {
            FootstepDataMessage footstepDataMessage = (FootstepDataMessage)footstepDataListMessage.getFootstepDataList().get(i);
            footstepDataMessage.setSwingHeight(this.stepParametersReference.get().getSwingHeight());
            footstepNode.add(this.createFootstep(footstepDataMessage));
        }
        this.footstepsToVisualizeReference.set(footstepNode);
        this.footstepsToSendReference.set(new FootstepDataListMessage(footstepDataListMessage));
    }

    private void sendFootsteps() {
        FootstepDataListMessage footstepsToSend = this.footstepsToSendReference.getAndSet(null);
        if (footstepsToSend != null && this.isWalking.get()) {
            this.footstepPublisher.publish((Object)footstepsToSend);
        }
        if (!this.isWalking.get() && !this.hasSuccessfullyStoppedWalking.get()) {
            this.sendPauseMessage();
        }
    }

    private void sendREAClearRequest() {
        REAStateRequestMessage clearRequest = new REAStateRequestMessage();
        clearRequest.setRequestClear(true);
        this.reaStateRequestPublisher.publish((Object)clearRequest);
    }

    private void sendREAResumeRequest() {
        REAStateRequestMessage resumeRequest = new REAStateRequestMessage();
        resumeRequest.setRequestResume(true);
        this.reaStateRequestPublisher.publish((Object)resumeRequest);
    }

    private Node createFootstep(FootstepDataMessage footstepDataMessage) {
        RobotSide footSide = RobotSide.fromByte((byte)footstepDataMessage.getRobotSide());
        return this.createFootstep((Point3DReadOnly)footstepDataMessage.getLocation(), (QuaternionReadOnly)footstepDataMessage.getOrientation(), (Color)this.footColors.get((Enum)footSide), (ConvexPolygon2DReadOnly)this.footPolygons.get((Enum)footSide));
    }

    private Node createFootstep(Point3DReadOnly position, QuaternionReadOnly orientation, Color footColor, ConvexPolygon2DReadOnly footPolygon) {
        MeshDataHolder polygon = MeshDataGenerator.ExtrudedPolygon((ConvexPolygon2DReadOnly)footPolygon, (double)0.025);
        polygon = MeshDataHolder.rotate((MeshDataHolder)polygon, (Orientation3DReadOnly)orientation);
        polygon = MeshDataHolder.translate((MeshDataHolder)polygon, (Tuple3DReadOnly)position);
        TriangleMesh mesh = JavaFXMeshDataInterpreter.interpretMeshData((MeshDataHolder)polygon, (boolean)true);
        MeshView meshView = new MeshView((Mesh)mesh);
        meshView.setMaterial((Material)new PhongMaterial(footColor));
        return meshView;
    }

    private boolean isSafeStepHeight(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        double heightChange = touchdownPose.getZ() - stancePose.getZ();
        return heightChange < this.steppingParameters.getMaxStepUp() && heightChange > -this.steppingParameters.getMaxStepDown();
    }

    private boolean isSafeDistanceFromObstacle(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.planarRegionsList.get() == null) {
            return true;
        }
        double halfStanceWidth = 0.5 * this.steppingParameters.getInPlaceWidth();
        double heightOffset = this.steppingParameters.getMaxStepUp();
        double soleYaw = touchdownPose.getYaw();
        double lateralOffset = swingSide.negateIfLeftSide(halfStanceWidth);
        double offsetX = -lateralOffset * Math.sin(soleYaw);
        double offsetY = lateralOffset * Math.cos(soleYaw);
        this.collisionDetector.setBoxPose(touchdownPose.getX() + offsetX, touchdownPose.getY() + offsetY, touchdownPose.getZ() + heightOffset, soleYaw);
        return !this.collisionDetector.checkForCollision().isCollisionDetected();
    }

    private boolean isStepSnappable(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        if (this.planarRegionsList.get() == null) {
            return true;
        }
        this.tempTransform.getTranslation().set(touchdownPose.getPosition().getX(), touchdownPose.getPosition().getY(), 0.0);
        this.tempTransform.getRotation().setToYawOrientation(touchdownPose.getYaw());
        this.footPolygon.set((Vertex2DSupplier)this.footPolygons.get((Enum)swingSide));
        this.footPolygon.applyTransform((Transform)this.tempTransform, false);
        PlanarRegionsList planarRegionsList = this.planarRegionsList.get();
        return PlanarRegionsListPolygonSnapper.snapPolygonToPlanarRegionsList((ConvexPolygon2DReadOnly)this.footPolygon, (PlanarRegionsList)planarRegionsList, (double)Double.POSITIVE_INFINITY, (PlanarRegion)this.tempRegion) != null;
    }

    private void processToggleFlamingoMode(RobotSide robotSide, ButtonState state) {
        if (this.activeSecondaryControlOption != SecondaryControlOption.KICK) {
            return;
        }
        if (state != ButtonState.PRESSED) {
            return;
        }
        if (this.isInDoubleSupport.getValue()) {
            this.flamingoHomeStance(robotSide);
        } else if (!((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get()) {
            this.putFootDown(robotSide);
        }
    }

    private void processKick(ButtonState state) {
        RobotSide kickSide;
        if (this.activeSecondaryControlOption != SecondaryControlOption.KICK) {
            return;
        }
        if (this.isInDoubleSupport.getValue()) {
            return;
        }
        RobotSide robotSide = kickSide = this.isRightFootInSupport.get() ? RobotSide.LEFT : RobotSide.RIGHT;
        if (state == ButtonState.PRESSED) {
            this.kick(kickSide);
        } else if (state == ButtonState.RELEASED) {
            this.flamingoHomeStance(kickSide);
        }
    }

    private void processPunch(RobotSide robotSide, ButtonState state) {
        if (this.activeSecondaryControlOption != SecondaryControlOption.PUNCH) {
            return;
        }
        if (state == ButtonState.PRESSED) {
            this.sendArmStraightConfiguration(robotSide);
        } else {
            this.sendArmHomeConfiguration(robotSide);
        }
    }

    private void sendArmHomeConfiguration(RobotSide ... robotSides) {
        this.punchMessenger.sendArmHomeConfiguration(this.trajectoryDuration.get(), robotSides);
    }

    private void sendArmStraightConfiguration(RobotSide robotSide) {
        this.punchMessenger.sendArmStraightConfiguration(this.trajectoryDuration.get(), robotSide);
    }

    private void flamingoHomeStance(RobotSide robotSide) {
        this.kickMessenger.sendFlamingoHomeStance(robotSide, this.trajectoryDuration.get(), this.stepParametersReference.get().getDefaultStepWidth(), (SegmentDependentList<RobotSide, ? extends ReferenceFrame>)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrames());
    }

    private void putFootDown(RobotSide robotSide) {
        if (((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get()) {
            return;
        }
        this.kickMessenger.sendPutFootDown(robotSide, this.trajectoryDuration.get(), this.stepParametersReference.get().getDefaultStepWidth(), (SegmentDependentList<RobotSide, ? extends ReferenceFrame>)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrames());
    }

    private void kick(RobotSide robotSide) {
        if (((AtomicBoolean)this.isFootInSupport.get((Enum)robotSide)).get()) {
            return;
        }
        this.kickMessenger.sendKick(robotSide, this.trajectoryDuration.get(), this.stepParametersReference.get().getDefaultStepWidth(), (SegmentDependentList<RobotSide, ? extends ReferenceFrame>)this.javaFXRobotVisualizer.getFullRobotModel().getSoleFrames());
    }

    public void start() {
        this.animationTimer.start();
        this.executorService.scheduleAtFixedRate(this::sendFootsteps, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.animationTimer.stop();
        this.executorService.shutdownNow();
        PauseWalkingMessage pauseWalkingMessage = new PauseWalkingMessage();
        pauseWalkingMessage.setPause(true);
        this.pauseWalkingPublisher.publish((Object)pauseWalkingMessage);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public static enum SecondaryControlOption {
        KICK,
        PUNCH,
        NONE;

    }
}

