/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import us.ihmc.avatar.joystickBasedJavaFXController.JoystickStepParametersProperty;
import us.ihmc.avatar.joystickBasedJavaFXController.ListViewTools;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorJavaFXController;
import us.ihmc.avatar.joystickBasedJavaFXController.StepGeneratorJavaFXTopics;
import us.ihmc.avatar.joystickBasedJavaFXController.UserProfileManager;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.javaFXToolkit.StringConverterTools;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.MessageBidirectionalBinding;
import us.ihmc.log.LogTools;

public class StepGeneratorParametersPaneController {
    @FXML
    private TextField newProfileTextField;
    @FXML
    private ListView<String> profileListView;
    @FXML
    private Slider trajectoryDurationSlider;
    @FXML
    private Slider swingHeightSlider;
    @FXML
    private Slider swingDurationSlider;
    @FXML
    private Slider transferDurationSlider;
    @FXML
    private Spinner<Double> maxStepLengthSpinner;
    @FXML
    private Spinner<Double> defaultStepWidthSpinner;
    @FXML
    private Spinner<Double> minStepWidthSpinner;
    @FXML
    private Spinner<Double> maxStepWidthSpinner;
    @FXML
    private Spinner<Double> turnStepWidth;
    @FXML
    private Spinner<Double> turnMaxAngleInwardSpinner;
    @FXML
    private Spinner<Double> turnMaxAngleOutwardSpinner;
    @FXML
    private ImageView controlLayoutImageView;
    private final Image kickImageLayout = new Image(this.getClass().getResourceAsStream("XBoxOneControllerStepMapping_kick.png"));
    private final Image punchImageLayout = new Image(this.getClass().getResourceAsStream("XBoxOneControllerStepMapping_punch.png"));
    private final Image noneImageLayout = new Image(this.getClass().getResourceAsStream("XBoxOneControllerStepMapping_noSecondaryOption.png"));
    private final JoystickStepParametersProperty.JoystickStepParameters defaultParameters = new JoystickStepParametersProperty.JoystickStepParameters();
    private final JoystickStepParametersProperty stepParametersProperty = new JoystickStepParametersProperty(this, "stepParameters");
    private UserProfileManager<JoystickStepParametersProperty.JoystickStepParameters> userProfileManager;

    public void initialize(JavaFXMessager messager, WalkingControllerParameters walkingControllerParameters, String workingDirectoryPath) throws IOException {
        this.defaultParameters.set(walkingControllerParameters);
        this.defaultParameters.setSwingHeight(0.025);
        JoystickStepParametersProperty.JoystickStepParameters initialParameters = new JoystickStepParametersProperty.JoystickStepParameters(this.defaultParameters);
        this.userProfileManager = new UserProfileManager<JoystickStepParametersProperty.JoystickStepParameters>(workingDirectoryPath, initialParameters, JoystickStepParametersProperty.JoystickStepParameters::parseFromPropertyMap, JoystickStepParametersProperty.JoystickStepParameters::exportToPropertyMap);
        this.profileListView.setItems(FXCollections.observableArrayList(this.userProfileManager.getUserProfileNames()));
        this.profileListView.setCellFactory(ListViewTools.cellFactoryForDragAndDropReorder(Function.identity()));
        MenuItem deleteMenuItem = new MenuItem("Delete");
        deleteMenuItem.setOnAction(e -> this.deleteSelectedProfile());
        this.profileListView.setCellFactory(ListViewTools.cellFactoryForMouseRightClickContextMenu(this.profileListView.getCellFactory(), deleteMenuItem));
        this.profileListView.getSelectionModel().selectedItemProperty().addListener((observable, oldProfileName, newProfileName) -> {
            JoystickStepParametersProperty.JoystickStepParameters currentParameters = (JoystickStepParametersProperty.JoystickStepParameters)this.stepParametersProperty.get();
            this.userProfileManager.saveProfile((String)oldProfileName, currentParameters);
            JoystickStepParametersProperty.JoystickStepParameters newParameters = this.userProfileManager.loadProfile((String)newProfileName);
            this.stepParametersProperty.setValue(newParameters);
        });
        if (!this.profileListView.getItems().isEmpty()) {
            this.profileListView.getSelectionModel().select(0);
            initialParameters.set(this.userProfileManager.loadProfile((String)this.profileListView.getItems().get(0)));
        }
        this.newProfileTextField.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addProfile();
            }
        });
        this.stepParametersProperty.set(initialParameters);
        this.swingHeightSlider.setLabelFormatter(StringConverterTools.metersToRoundedCentimeters());
        this.maxStepLengthSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, initialParameters.getMaxStepLength(), 0.05));
        this.defaultStepWidthSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, initialParameters.getDefaultStepWidth(), 0.05));
        this.minStepWidthSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, initialParameters.getMinStepWidth(), 0.025));
        this.maxStepWidthSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, initialParameters.getMaxStepWidth(), 0.05));
        this.turnStepWidth.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 1.0, initialParameters.getTurnStepWidth(), 0.05));
        this.turnMaxAngleInwardSpinner.setValueFactory((SpinnerValueFactory)StepGeneratorParametersPaneController.newAngleSpinnerValueFactory(-0.7853981633974483, 1.5707963267948966, initialParameters.getTurnMaxAngleInward(), Math.toRadians(5.0)));
        this.turnMaxAngleOutwardSpinner.setValueFactory((SpinnerValueFactory)StepGeneratorParametersPaneController.newAngleSpinnerValueFactory(0.0, 1.5707963267948966, initialParameters.getTurnMaxAngleOutward(), Math.toRadians(5.0)));
        this.stepParametersProperty.bindBidirectionalSwingHeight((Property<? extends Number>)this.swingHeightSlider.valueProperty());
        this.stepParametersProperty.bindBidirectionalSwingDuration((Property<? extends Number>)this.swingDurationSlider.valueProperty());
        this.stepParametersProperty.bindBidirectionalTransferDuration((Property<? extends Number>)this.transferDurationSlider.valueProperty());
        this.stepParametersProperty.bindBidirectionalMaxStepLength((Property<? extends Number>)this.maxStepLengthSpinner.getValueFactory().valueProperty());
        this.stepParametersProperty.bindBidirectionalDefaultStepWidth((Property<? extends Number>)this.defaultStepWidthSpinner.getValueFactory().valueProperty());
        this.stepParametersProperty.bindBidirectionalMinStepWidth((Property<? extends Number>)this.minStepWidthSpinner.getValueFactory().valueProperty());
        this.stepParametersProperty.bindBidirectionalMaxStepWidth((Property<? extends Number>)this.maxStepWidthSpinner.getValueFactory().valueProperty());
        this.stepParametersProperty.bindBidirectionalTurnStepWidth((Property<? extends Number>)this.turnStepWidth.getValueFactory().valueProperty());
        this.stepParametersProperty.bindBidirectionalTurnMaxAngleInward((Property<? extends Number>)this.turnMaxAngleInwardSpinner.getValueFactory().valueProperty());
        this.stepParametersProperty.bindBidirectionalTurnMaxAngleOutward((Property<? extends Number>)this.turnMaxAngleOutwardSpinner.getValueFactory().valueProperty());
        messager.bindBidirectional(StepGeneratorJavaFXTopics.SteppingParameters, (Property)this.stepParametersProperty, true);
        messager.bindBidirectional(StepGeneratorJavaFXTopics.WalkingTrajectoryDuration, (Property)this.trajectoryDurationSlider.valueProperty(), this.createConverter(), true);
    }

    @FXML
    private void addProfile() {
        String newUserProfileName = (String)this.newProfileTextField.textProperty().get();
        if (newUserProfileName.isEmpty()) {
            return;
        }
        this.profileListView.getItems().add((Object)newUserProfileName);
        this.profileListView.getSelectionModel().select((Object)newUserProfileName);
        this.newProfileTextField.clear();
    }

    private void deleteSelectedProfile() {
        String profileToDelete = (String)this.profileListView.getSelectionModel().getSelectedItem();
        this.profileListView.getItems().remove((Object)profileToDelete);
    }

    public void close() {
        this.userProfileManager.saveProfile((String)this.profileListView.getSelectionModel().getSelectedItem(), (JoystickStepParametersProperty.JoystickStepParameters)this.stepParametersProperty.get());
        this.userProfileManager.close((List<String>)this.profileListView.getItems());
    }

    public void updateImageLayout(StepGeneratorJavaFXController.SecondaryControlOption option) {
        switch (option) {
            case KICK: {
                this.controlLayoutImageView.setImage(this.kickImageLayout);
                break;
            }
            case PUNCH: {
                this.controlLayoutImageView.setImage(this.punchImageLayout);
                break;
            }
            case NONE: {
                this.controlLayoutImageView.setImage(this.noneImageLayout);
            }
            default: {
                LogTools.error((String)("Unhandled option: " + (Object)((Object)option)));
            }
        }
    }

    private MessageBidirectionalBinding.PropertyToMessageTypeConverter<Double, Number> createConverter() {
        return new MessageBidirectionalBinding.PropertyToMessageTypeConverter<Double, Number>(){

            public Double convert(Number propertyValue) {
                return propertyValue.doubleValue();
            }

            public Number interpret(Double messageContent) {
                return messageContent;
            }
        };
    }

    public static SpinnerValueFactory.DoubleSpinnerValueFactory newAngleSpinnerValueFactory(double min, double max, double initialValue, double angleToStepBy) {
        SpinnerValueFactory.DoubleSpinnerValueFactory doubleSpinnerValueFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, angleToStepBy);
        doubleSpinnerValueFactory.setConverter(StringConverterTools.radiansToRoundedDegrees());
        return doubleSpinnerValueFactory;
    }
}

