/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.joystickBasedJavaFXController;

import java.util.concurrent.atomic.AtomicBoolean;
import net.java.games.input.Event;
import us.ihmc.avatar.joystickBasedJavaFXController.ButtonState;
import us.ihmc.commons.MathTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.tools.inputDevices.joystick.Joystick;
import us.ihmc.tools.inputDevices.joystick.JoystickCustomizationFilter;
import us.ihmc.tools.inputDevices.joystick.JoystickModel;
import us.ihmc.tools.inputDevices.joystick.exceptions.JoystickNotFoundException;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;
import us.ihmc.tools.inputDevices.joystick.mapping.XBoxOneMapping;

public class XBoxOneJavaFXController {
    private static final MessagerAPIFactory apiFactory = new MessagerAPIFactory();
    private static final MessagerAPIFactory.Category Root = apiFactory.createRootCategory(apiFactory.createCategoryTheme("XBoxOneController"));
    private static final MessagerAPIFactory.CategoryTheme Button = apiFactory.createCategoryTheme("Button");
    private static final MessagerAPIFactory.CategoryTheme A = apiFactory.createCategoryTheme("A");
    private static final MessagerAPIFactory.CategoryTheme B = apiFactory.createCategoryTheme("B");
    private static final MessagerAPIFactory.CategoryTheme X = apiFactory.createCategoryTheme("X");
    private static final MessagerAPIFactory.CategoryTheme Y = apiFactory.createCategoryTheme("Y");
    private static final MessagerAPIFactory.CategoryTheme LeftBumper = apiFactory.createCategoryTheme("LeftBumper");
    private static final MessagerAPIFactory.CategoryTheme RightBumper = apiFactory.createCategoryTheme("RightBumper");
    private static final MessagerAPIFactory.CategoryTheme Select = apiFactory.createCategoryTheme("Select");
    private static final MessagerAPIFactory.CategoryTheme Start = apiFactory.createCategoryTheme("Start");
    private static final MessagerAPIFactory.CategoryTheme XBox = apiFactory.createCategoryTheme("XBox");
    private static final MessagerAPIFactory.CategoryTheme LeftTrigger = apiFactory.createCategoryTheme("LeftTrigger");
    private static final MessagerAPIFactory.CategoryTheme RightTrigger = apiFactory.createCategoryTheme("RightTrigger");
    private static final MessagerAPIFactory.CategoryTheme LeftStick = apiFactory.createCategoryTheme("LeftStick");
    private static final MessagerAPIFactory.CategoryTheme RightStick = apiFactory.createCategoryTheme("RightStick");
    private static final MessagerAPIFactory.CategoryTheme DirectionalPad = apiFactory.createCategoryTheme("DirectionalPad");
    private static final MessagerAPIFactory.CategoryTheme Up = apiFactory.createCategoryTheme("Up");
    private static final MessagerAPIFactory.CategoryTheme Down = apiFactory.createCategoryTheme("Down");
    private static final MessagerAPIFactory.CategoryTheme Left = apiFactory.createCategoryTheme("Left");
    private static final MessagerAPIFactory.CategoryTheme Right = apiFactory.createCategoryTheme("Right");
    private static final MessagerAPIFactory.TypedTopicTheme<ButtonState> State = apiFactory.createTypedTopicTheme("State");
    private static final MessagerAPIFactory.TypedTopicTheme<Double> Axis = apiFactory.createTypedTopicTheme("Axis");
    private static final MessagerAPIFactory.TypedTopicTheme<Boolean> Reconnect = apiFactory.createTypedTopicTheme("Reconnect");
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonAState = Root.child(Button).child(A).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonBState = Root.child(Button).child(B).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonXState = Root.child(Button).child(X).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonYState = Root.child(Button).child(Y).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonLeftBumperState = Root.child(Button).child(LeftBumper).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonRightBumperState = Root.child(Button).child(RightBumper).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonSelectState = Root.child(Button).child(Select).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonStartState = Root.child(Button).child(Start).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonXBoxState = Root.child(Button).child(XBox).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonLeftStickState = Root.child(Button).child(LeftStick).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> ButtonRightStickState = Root.child(Button).child(RightStick).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> DPadUpState = Root.child(Button).child(DirectionalPad).child(Up).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> DPadDownState = Root.child(Button).child(DirectionalPad).child(Down).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> DPadLeftState = Root.child(Button).child(DirectionalPad).child(Left).topic(State);
    public static final MessagerAPIFactory.Topic<ButtonState> DPadRightState = Root.child(Button).child(DirectionalPad).child(Right).topic(State);
    public static final MessagerAPIFactory.Topic<Double> LeftStickXAxis = Root.child(LeftStick).child(X).topic(Axis);
    public static final MessagerAPIFactory.Topic<Double> LeftStickYAxis = Root.child(LeftStick).child(Y).topic(Axis);
    public static final MessagerAPIFactory.Topic<Double> RightStickXAxis = Root.child(RightStick).child(X).topic(Axis);
    public static final MessagerAPIFactory.Topic<Double> RightStickYAxis = Root.child(RightStick).child(Y).topic(Axis);
    public static final MessagerAPIFactory.Topic<Double> LeftTriggerAxis = Root.child(LeftTrigger).topic(Axis);
    public static final MessagerAPIFactory.Topic<Double> RightTriggerAxis = Root.child(RightTrigger).topic(Axis);
    public static final MessagerAPIFactory.Topic<Boolean> XBoxControllerReconnect = Root.topic(Reconnect);
    public static final MessagerAPIFactory.MessagerAPI XBoxOneControllerAPI = apiFactory.getAPIAndCloseFactory();
    private final Messager messager;
    private Joystick joystick;
    private MessagerAPIFactory.Topic<ButtonState> lastDPadPressed = null;
    private AtomicBoolean joystickConnected = new AtomicBoolean(false);
    private Thread reconnectThread = null;

    public XBoxOneJavaFXController(Messager messager) throws JoystickNotFoundException {
        this.messager = messager;
        messager.registerTopicListener(XBoxControllerReconnect, value -> this.reconnectJoystick());
        this.scheduleReconnectJoystick();
    }

    public void scheduleReconnectJoystick() {
        if (this.reconnectThread != null) {
            if (this.reconnectThread.isAlive()) {
                return;
            }
            this.reconnectThread = null;
        }
        Runnable reconnectTask = () -> {
            while (!this.joystickConnected.get()) {
                this.reconnectJoystick();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LogTools.info((String)"Reconnect has been interrupted");
                    return;
                }
            }
        };
        this.reconnectThread = new Thread(reconnectTask, this.getClass().getSimpleName() + "-reconnect");
        this.reconnectThread.setDaemon(true);
        this.reconnectThread.start();
    }

    public void reconnectJoystick() {
        if (this.joystick != null) {
            this.joystick.clearEventListeners();
            this.joystick.shutdown();
            this.joystick = null;
        }
        Joystick.rescanControllers();
        try {
            this.connectJoystick();
        }
        catch (JoystickNotFoundException e) {
            LogTools.warn((String)"Could not reconnect joystick.");
        }
    }

    private boolean connectJoystick() throws JoystickNotFoundException {
        if (!Joystick.isAJoystickConnectedToSystem()) {
            LogTools.warn((String)"No joystick found.");
            return false;
        }
        try {
            this.joystick = new Joystick(JoystickModel.XBOX_ONE_S, 0);
        }
        catch (JoystickNotFoundException e) {
            this.joystick = new Joystick(JoystickModel.XBOX_ONE, 0);
        }
        this.joystick.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)XBoxOneMapping.LEFT_STICK_Y, true, 0.1));
        this.joystick.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)XBoxOneMapping.LEFT_STICK_X, true, 0.1));
        this.joystick.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)XBoxOneMapping.RIGHT_STICK_Y, true, 0.1));
        this.joystick.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)XBoxOneMapping.RIGHT_STICK_X, true, 0.1));
        this.joystick.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)XBoxOneMapping.LEFT_TRIGGER, true, 0.1, 3));
        this.joystick.setCustomizationFilter(new JoystickCustomizationFilter((JoystickMapping)XBoxOneMapping.RIGHT_TRIGGER, true, 0.1, 3));
        this.joystick.addJoystickStatusListener(connected -> {
            if (!connected) {
                this.joystickConnected.set(false);
                this.scheduleReconnectJoystick();
            }
        });
        this.joystick.addJoystickEventListener(this::consumeEvent);
        this.joystickConnected.set(true);
        return true;
    }

    private void consumeEvent(Event event) {
        switch (XBoxOneMapping.getMapping((Event)event)) {
            case A: {
                this.messager.submitMessage(ButtonAState, (Object)this.toState(event));
                break;
            }
            case B: {
                this.messager.submitMessage(ButtonBState, (Object)this.toState(event));
                break;
            }
            case X: {
                this.messager.submitMessage(ButtonXState, (Object)this.toState(event));
                break;
            }
            case Y: {
                this.messager.submitMessage(ButtonYState, (Object)this.toState(event));
                break;
            }
            case START: {
                this.messager.submitMessage(ButtonStartState, (Object)this.toState(event));
                break;
            }
            case SELECT: {
                this.messager.submitMessage(ButtonSelectState, (Object)this.toState(event));
                break;
            }
            case XBOX_BUTTON: {
                this.messager.submitMessage(ButtonXBoxState, (Object)this.toState(event));
                break;
            }
            case LEFT_STICK_BUTTON: {
                this.messager.submitMessage(ButtonLeftStickState, (Object)this.toState(event));
                break;
            }
            case RIGHT_STICK_BUTTON: {
                this.messager.submitMessage(ButtonRightStickState, (Object)this.toState(event));
                break;
            }
            case LEFT_BUMPER: {
                this.messager.submitMessage(ButtonLeftBumperState, (Object)this.toState(event));
                break;
            }
            case RIGHT_BUMPER: {
                this.messager.submitMessage(ButtonRightBumperState, (Object)this.toState(event));
                break;
            }
            case LEFT_STICK_X: {
                this.messager.submitMessage(LeftStickXAxis, (Object)event.getValue());
                break;
            }
            case LEFT_STICK_Y: {
                this.messager.submitMessage(LeftStickYAxis, (Object)event.getValue());
                break;
            }
            case RIGHT_STICK_X: {
                this.messager.submitMessage(RightStickXAxis, (Object)event.getValue());
                break;
            }
            case RIGHT_STICK_Y: {
                this.messager.submitMessage(RightStickYAxis, (Object)event.getValue());
                break;
            }
            case LEFT_TRIGGER: {
                this.messager.submitMessage(LeftTriggerAxis, (Object)event.getValue());
                break;
            }
            case RIGHT_TRIGGER: {
                this.messager.submitMessage(RightTriggerAxis, (Object)event.getValue());
                break;
            }
            case DPAD: {
                if (MathTools.epsilonEquals((double)0.0, (double)event.getValue(), (double)1.0E-6)) {
                    if (this.lastDPadPressed == null) break;
                    this.messager.submitMessage(this.lastDPadPressed, (Object)ButtonState.RELEASED);
                    break;
                }
                MessagerAPIFactory.Topic<ButtonState> stateTopic = null;
                if (MathTools.epsilonEquals((double)0.25, (double)event.getValue(), (double)1.0E-6)) {
                    stateTopic = DPadUpState;
                } else if (MathTools.epsilonEquals((double)0.5, (double)event.getValue(), (double)1.0E-6)) {
                    stateTopic = DPadRightState;
                } else if (MathTools.epsilonEquals((double)0.75, (double)event.getValue(), (double)1.0E-6)) {
                    stateTopic = DPadDownState;
                } else if (MathTools.epsilonEquals((double)1.0, (double)event.getValue(), (double)1.0E-6)) {
                    stateTopic = DPadLeftState;
                }
                if (stateTopic == null) break;
                this.messager.submitMessage(stateTopic, (Object)ButtonState.PRESSED);
                break;
            }
            case DPAD_UP: {
                this.messager.submitMessage(DPadUpState, (Object)this.toState(event));
                break;
            }
            case DPAD_DOWN: {
                this.messager.submitMessage(DPadDownState, (Object)this.toState(event));
                break;
            }
            case DPAD_LEFT: {
                this.messager.submitMessage(DPadLeftState, (Object)this.toState(event));
                break;
            }
            case DPAD_RIGHT: {
                this.messager.submitMessage(DPadRightState, (Object)this.toState(event));
                break;
            }
        }
    }

    private ButtonState toState(Event event) {
        if (event.getComponent().getPollData() > 0.5f) {
            return ButtonState.PRESSED;
        }
        return ButtonState.RELEASED;
    }

    public void stop() {
        if (this.joystick != null) {
            this.joystick.shutdown();
        }
        if (this.reconnectThread != null) {
            this.reconnectThread.interrupt();
        }
        this.reconnectThread = null;
    }
}

