/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.jumpingSimulation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.ControllerFailureListener;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.sensors.FootSwitchFactory;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.sensorProcessors.SensorOutputMapReadOnly;
import us.ihmc.sensorProcessing.simulatedSensors.SDFPerfectSimulatedSensorReader;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationToolkit.outputWriters.PerfectSimulatedOutputWriter;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.stateEstimation.humanoid.kinematicsBasedStateEstimation.KinematicsBasedStateEstimatorFactory;
import us.ihmc.wholeBodyController.DRCControllerThread;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingSimulationController
implements RobotController {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final JumpingControllerState controller;
    private final FullHumanoidRobotModel fullRobotModel;
    private final HumanoidFloatingRootJointRobot humanoidRobotModel;
    private final JumpingControllerToolbox controllerToolbox;
    private final YoDouble time;
    private final SDFPerfectSimulatedSensorReader sensorReader;
    private final PerfectSimulatedOutputWriter outputWriter;
    private boolean initialized = false;

    public JumpingSimulationController(CommandInputManager commandInputManager, DRCRobotModel robotModel, FullHumanoidRobotModel fullRobotModel, HumanoidFloatingRootJointRobot humanoidRobotModel, YoGraphicsListRegistry yoGraphicsListRegistry, double gravityZ, InputStream parameterFile) {
        this.fullRobotModel = fullRobotModel;
        this.humanoidRobotModel = humanoidRobotModel;
        this.time = humanoidRobotModel.getYoTime();
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        SegmentDependentList footContactPoints = contactPointParameters.getFootContactPoints();
        SegmentDependentList toeContactPoints = contactPointParameters.getControllerToeContactPoints();
        SegmentDependentList toeContactLines = contactPointParameters.getControllerToeContactLines();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(footContactPoints);
        contactableBodiesFactory.setToeContactParameters(toeContactPoints, toeContactLines);
        ForceSensorDataHolder forceSensorDataHolder = new ForceSensorDataHolder(Arrays.asList(this.fullRobotModel.getForceSensorDefinitions()));
        ArrayList forceSensors = new ArrayList();
        ArrayList imuMounts = new ArrayList();
        humanoidRobotModel.getForceSensors(forceSensors);
        humanoidRobotModel.getIMUMounts(imuMounts);
        this.sensorReader = new SDFPerfectSimulatedSensorReader((FloatingRootJointRobot)humanoidRobotModel, (FullRobotModel)this.fullRobotModel, forceSensorDataHolder, null);
        if (this.fullRobotModel.getIMUDefinitions() != null) {
            block0: for (IMUDefinition iMUDefinition : this.fullRobotModel.getIMUDefinitions()) {
                for (IMUMount imuMount : imuMounts) {
                    if (!iMUDefinition.getName().equals(imuMount.getName())) continue;
                    this.sensorReader.addIMUSensor(iMUDefinition, imuMount);
                    continue block0;
                }
            }
        }
        if (this.fullRobotModel.getForceSensorDefinitions() != null) {
            block2: for (IMUDefinition iMUDefinition : this.fullRobotModel.getForceSensorDefinitions()) {
                for (WrenchCalculatorInterface forceSensor : forceSensors) {
                    if (!iMUDefinition.getSensorName().equals(forceSensor.getName())) continue;
                    this.sensorReader.addForceTorqueSensorPort((ForceSensorDefinition)iMUDefinition, forceSensor);
                    continue block2;
                }
            }
        }
        KinematicsBasedStateEstimatorFactory estimatorFactory = new KinematicsBasedStateEstimatorFactory();
        estimatorFactory.setEstimatorFullRobotModel(this.fullRobotModel);
        estimatorFactory.setSensorInformation(robotModel.getSensorInformation());
        estimatorFactory.setSensorOutputMapReadOnly((SensorOutputMapReadOnly)this.sensorReader);
        estimatorFactory.setGravity(Double.valueOf(gravityZ));
        estimatorFactory.setStateEstimatorParameters(robotModel.getStateEstimatorParameters());
        estimatorFactory.setContactableBodiesFactory(contactableBodiesFactory);
        estimatorFactory.setEstimatorForceSensorDataHolder((ForceSensorDataHolderReadOnly)forceSensorDataHolder);
        estimatorFactory.setCenterOfPressureDataHolderFromController(new CenterOfPressureDataHolder(this.fullRobotModel));
        estimatorFactory.setRobotMotionStatusFromController(new RobotMotionStatusHolder());
        HumanoidReferenceFrames referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)referenceFrames);
        contactableBodiesFactory.setFootContactPoints(footContactPoints);
        contactableBodiesFactory.setToeContactParameters(toeContactPoints, toeContactLines);
        SideDependentList feet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        double d = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)this.fullRobotModel.getElevator());
        double totalRobotWeight = d * gravityZ;
        SideDependentList<FootSwitchInterface> footSwitches = this.createFootSwitches((SideDependentList<? extends ContactablePlaneBody>)feet, (ForceSensorDataHolderReadOnly)forceSensorDataHolder, robotModel.getWalkingControllerParameters(), totalRobotWeight, (SideDependentList<String>)robotModel.getSensorInformation().getFeetForceSensorNames(), yoGraphicsListRegistry, this.registry);
        JointBasics[] jointsToIgnore = DRCControllerThread.createListOfJointsToIgnore((FullHumanoidRobotModel)this.fullRobotModel, (WholeBodyControllerParameters)robotModel, (HumanoidRobotSensorInformation)robotModel.getSensorInformation());
        this.controllerToolbox = new JumpingControllerToolbox(this.fullRobotModel, (CommonHumanoidReferenceFrames)referenceFrames, robotModel.getWalkingControllerParameters(), footSwitches, humanoidRobotModel.getYoTime(), gravityZ, robotModel.getWalkingControllerParameters().getOmega0(), feet, robotModel.getControllerDT(), new ArrayList(), yoGraphicsListRegistry, jointsToIgnore);
        this.registry.addChild(this.controllerToolbox.getYoVariableRegistry());
        JumpingCoPTrajectoryParameters jumpingCoPTrajectoryParameters = new JumpingCoPTrajectoryParameters(this.registry);
        JumpingParameters jumpingParameters = new JumpingParameters(this.registry);
        JumpingControlManagerFactory managerFactory = new JumpingControlManagerFactory(this.registry);
        managerFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        managerFactory.setCoPTrajectoryParameters(robotModel.getCoPTrajectoryParameters());
        managerFactory.setWalkingControllerParameters(robotModel.getWalkingControllerParameters());
        managerFactory.setJumpingCoPTrajectoryParameters(jumpingCoPTrajectoryParameters);
        managerFactory.setJumpingParameters(jumpingParameters);
        this.controller = new JumpingControllerState(commandInputManager, managerFactory, this.controllerToolbox, robotModel.getHighLevelControllerParameters(), robotModel.getWalkingControllerParameters(), jumpingCoPTrajectoryParameters, jumpingParameters);
        this.registry.addChild(this.controller.getYoRegistry());
        this.outputWriter = new PerfectSimulatedOutputWriter((FloatingRootJointRobot)humanoidRobotModel, (FullRobotModel)this.fullRobotModel, this.controller.getOutputForLowLevelController());
        ParameterLoaderHelper.loadParameters((Object)this, (InputStream)parameterFile, (YoRegistry)this.registry);
    }

    private SideDependentList<FootSwitchInterface> createFootSwitches(SideDependentList<? extends ContactablePlaneBody> bipedFeet, ForceSensorDataHolderReadOnly forceSensorDataHolder, WalkingControllerParameters walkingControllerParameters, double totalRobotWeight, SideDependentList<String> footSensorNames, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        SideDependentList footSwitches = new SideDependentList();
        FootSwitchFactory footSwitchFactory = walkingControllerParameters.getFootSwitchFactory();
        for (RobotSide robotSide : RobotSide.values) {
            String footName = ((ContactablePlaneBody)bipedFeet.get((Enum)robotSide)).getName();
            ForceSensorDataReadOnly footForceSensor = forceSensorDataHolder.getByName((String)footSensorNames.get((Enum)robotSide));
            FootSwitchInterface footSwitch = footSwitchFactory.newFootSwitch(footName, (ContactablePlaneBody)bipedFeet.get((Enum)robotSide), Collections.singleton(bipedFeet.get((Enum)robotSide.getOppositeSide())), footForceSensor, totalRobotWeight, yoGraphicsListRegistry, registry);
            footSwitches.put((Enum)robotSide, (Object)footSwitch);
        }
        return footSwitches;
    }

    public void attachControllerFailureListener(ControllerFailureListener controllerFailureListener) {
        this.controllerToolbox.attachControllerFailureListener(controllerFailureListener);
    }

    public void initialize() {
        this.sensorReader.initialize();
        this.controller.initialize();
        this.outputWriter.initialize();
        this.initialized = true;
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public void doControl() {
        if (!this.initialized) {
            this.initialize();
        }
        this.sensorReader.read();
        this.controller.doAction(this.time.getDoubleValue());
        this.outputWriter.write();
    }
}

