/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.jumpingSimulation;

import java.util.ArrayList;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.avatar.jumpingSimulation.JumpingSimulationController;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationToolkit.controllers.CoMPushController;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.tools.SimulationOverheadPlotterFactory;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;

public class JumpingSimulationFactory {
    private final DRCRobotModel robotModel;
    private final DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> initialSetup;
    private final CommandInputManager commandInputManager;
    private static final double gravityZ = 9.81;

    public JumpingSimulationFactory(DRCRobotModel robotModel, DRCRobotInitialSetup initialSetup) {
        this.robotModel = robotModel;
        this.initialSetup = initialSetup;
        ArrayList<Class<JumpingGoal>> availableCommands = new ArrayList<Class<JumpingGoal>>();
        availableCommands.add(JumpingGoal.class);
        this.commandInputManager = new CommandInputManager(availableCommands);
    }

    public SimulationConstructionSet createSimulation(String parameterResourceName) {
        HumanoidFloatingRootJointRobot humanoidRobot = this.robotModel.createHumanoidFloatingRootJointRobot(false);
        FullHumanoidRobotModel fullHumanoidRobotModel = this.robotModel.createFullRobotModel();
        YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
        JumpingSimulationController simulationController = new JumpingSimulationController(this.commandInputManager, this.robotModel, fullHumanoidRobotModel, humanoidRobot, graphicsListRegistry, 9.81, this.getClass().getResourceAsStream(parameterResourceName));
        int controlTicksPerSimulate = (int)(this.robotModel.getControllerDT() / this.robotModel.getSimulateDT());
        humanoidRobot.setController((RobotController)simulationController, controlTicksPerSimulate);
        FlatGroundProfile groundProfile = new FlatGroundProfile();
        DRCSCSInitialSetup scsInitialSetup = new DRCSCSInitialSetup((GroundProfile3D)groundProfile, this.robotModel.getSimulateDT());
        scsInitialSetup.setInitializeEstimatorToActual(true);
        scsInitialSetup.setDrawGroundProfile(true);
        scsInitialSetup.setRunMultiThreaded(false);
        scsInitialSetup.initializeRobot((Robot)humanoidRobot, this.robotModel, null);
        this.initialSetup.initializeRobot(humanoidRobot, this.robotModel.getJointMap());
        this.initialSetup.initializeFullRobotModel(fullHumanoidRobotModel);
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)humanoidRobot);
        scsInitialSetup.initializeSimulation(scs);
        scs.addYoGraphicsListRegistry(graphicsListRegistry);
        scs.setDT(this.robotModel.getSimulateDT(), 1);
        SimulationOverheadPlotterFactory plotterFactory = scs.createSimulationOverheadPlotterFactory();
        plotterFactory.setShowOnStart(true);
        plotterFactory.setVariableNameToTrack("centerOfMass");
        plotterFactory.addYoGraphicsListRegistries(graphicsListRegistry);
        plotterFactory.createOverheadPlotter();
        CoMPushController pushRobotController = new CoMPushController((FloatingRootJointRobot)humanoidRobot, fullHumanoidRobotModel);
        scs.addYoGraphic(pushRobotController.getForceVisualizer());
        pushRobotController.setPushDuration(4.0);
        pushRobotController.setPushForceDirection((Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0));
        pushRobotController.setPushTorqueDirection((Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0));
        pushRobotController.setPushTorqueMagnitude(50.0);
        pushRobotController.addPushButtonToSCS(scs);
        return scs;
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }
}

