/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.kinematicsSimulation;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingStatusMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationContactStateHolder;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.avatar.logging.IntraprocessYoVariableLogger;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxHelper;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModule;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisHeightControlState;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.ControllerNetworkSubscriber;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WalkingHighLevelHumanoidController;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.SettableFootSwitch;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.MessageUnpackingTools;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.FrameMessageCommandConverter;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.communication.packets.walking.WalkingStatus;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.wholeBodyController.DRCControllerThread;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class HumanoidKinematicsSimulation {
    private static final double GRAVITY_Z = 9.81;
    private static final double LIDAR_SPINDLE_SPEED = 2.5;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final HumanoidKinematicsSimulationParameters kinematicsSimulationParameters;
    private final PausablePeriodicThread controlThread;
    private final ROS2Node ros2Node;
    private final RealtimeROS2Node realtimeROS2Node;
    private final IHMCROS2Publisher<RobotConfigurationData> robotConfigurationDataPublisher;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private double yoVariableServerTime = 0.0;
    private final Stopwatch monotonicTimer = new Stopwatch();
    private final YoDouble yoTime;
    private final FullHumanoidRobotModel fullRobotModel;
    private final CommonHumanoidReferenceFrames referenceFrames;
    private final SideDependentList<SettableFootSwitch> footSwitches = new SideDependentList();
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WholeBodyControllerCore controllerCore;
    private final LinearMomentumRateControlModule linearMomentumRateControlModule;
    private final HighLevelControlManagerFactory managerFactory;
    private final WalkingHighLevelHumanoidController walkingController;
    private final CommandInputManager walkingInputManager = new CommandInputManager("walking_preview_internal", ControllerAPIDefinition.getControllerSupportedCommands());
    private final StatusMessageOutputManager walkingOutputManager = new StatusMessageOutputManager(ControllerAPIDefinition.getControllerSupportedStatusMessages());
    private final MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator();
    private AtomicReference<WalkingStatus> latestWalkingStatus = new AtomicReference();
    private SideDependentList<HumanoidKinematicsSimulationContactStateHolder> contactStateHolders = new SideDependentList();
    private InverseDynamicsCommandList inverseDynamicsContactHolderCommandList = new InverseDynamicsCommandList();
    private YoVariableServer yoVariableServer = null;
    private IntraprocessYoVariableLogger intraprocessYoVariableLogger;

    public static HumanoidKinematicsSimulation create(DRCRobotModel robotModel, HumanoidKinematicsSimulationParameters kinematicsSimulationParameters) {
        return new HumanoidKinematicsSimulation(robotModel, kinematicsSimulationParameters);
    }

    public HumanoidKinematicsSimulation(DRCRobotModel robotModel, HumanoidKinematicsSimulationParameters kinematicsSimulationParameters) {
        this.kinematicsSimulationParameters = kinematicsSimulationParameters;
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)kinematicsSimulationParameters.getPubSubImplementation(), (String)"kinematics_ihmc_controller");
        this.robotConfigurationDataPublisher = new IHMCROS2Publisher((ROS2NodeInterface)this.ros2Node, RobotConfigurationData.class, ROS2Tools.HUMANOID_CONTROLLER.withRobot(robotModel.getSimpleRobotName()).withOutput());
        String robotName = robotModel.getSimpleRobotName();
        this.fullRobotModel = robotModel.createFullRobotModel();
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel);
        this.yoTime = new YoDouble("timeInPreview", this.registry);
        YoRegistry drcControllerThreadRegistry = new YoRegistry("DRCControllerThread");
        YoRegistry drcMomentumBasedControllerRegistry = new YoRegistry("DRCMomentumBasedController");
        YoRegistry humanoidHighLevelControllerManagerRegistry = new YoRegistry("HumanoidHighLevelControllerManager");
        YoRegistry managerParentRegistry = new YoRegistry("HighLevelHumanoidControllerFactory");
        YoRegistry walkingParentRegistry = new YoRegistry("WalkingControllerState");
        this.registry.addChild(drcControllerThreadRegistry);
        drcControllerThreadRegistry.addChild(drcMomentumBasedControllerRegistry);
        drcMomentumBasedControllerRegistry.addChild(humanoidHighLevelControllerManagerRegistry);
        humanoidHighLevelControllerManagerRegistry.addChild(walkingParentRegistry);
        humanoidHighLevelControllerManagerRegistry.addChild(managerParentRegistry);
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)contactPointParameters.getAdditionalContactRigidBodyNames().get(i), (String)contactPointParameters.getAdditionalContactNames().get(i), (RigidBodyTransform)contactPointParameters.getAdditionalContactTransforms().get(i));
        }
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.referenceFrames);
        SideDependentList feet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        ArrayList allContactableBodies = new ArrayList(contactableBodiesFactory.createAdditionalContactPoints());
        allContactableBodies.addAll(feet.values());
        contactableBodiesFactory.disposeFactory();
        double totalRobotWeight = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)this.fullRobotModel.getElevator());
        for (RobotSide robotSide : RobotSide.values) {
            SettableFootSwitch footSwitch = new SettableFootSwitch((ContactablePlaneBody)feet.get((Enum)robotSide), totalRobotWeight, 2, this.registry);
            footSwitch.setFootContactState(true);
            this.footSwitches.put((Enum)robotSide, (Object)footSwitch);
        }
        JointBasics[] jointsToIgnore = DRCControllerThread.createListOfJointsToIgnore((FullHumanoidRobotModel)this.fullRobotModel, (WholeBodyControllerParameters)robotModel, (HumanoidRobotSensorInformation)robotModel.getSensorInformation());
        this.controllerToolbox = new HighLevelHumanoidControllerToolbox(this.fullRobotModel, this.referenceFrames, this.footSwitches, null, this.yoTime, 9.81, robotModel.getWalkingControllerParameters().getOmega0(), feet, kinematicsSimulationParameters.getDt(), Collections.emptyList(), allContactableBodies, this.yoGraphicsListRegistry, jointsToIgnore);
        humanoidHighLevelControllerManagerRegistry.addChild(this.controllerToolbox.getYoVariableRegistry());
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = robotModel.getCoPTrajectoryParameters();
        WalkingMessageHandler walkingMessageHandler = new WalkingMessageHandler(walkingControllerParameters.getDefaultTransferTime(), walkingControllerParameters.getDefaultSwingTime(), walkingControllerParameters.getDefaultInitialTransferTime(), walkingControllerParameters.getDefaultFinalTransferTime(), this.controllerToolbox.getContactableFeet(), this.walkingOutputManager, this.yoTime, this.yoGraphicsListRegistry, this.controllerToolbox.getYoVariableRegistry());
        this.controllerToolbox.setWalkingMessageHandler(walkingMessageHandler);
        DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup = robotModel.getDefaultRobotInitialSetup(kinematicsSimulationParameters.getInitialGroundHeight(), kinematicsSimulationParameters.getInitialRobotYaw(), kinematicsSimulationParameters.getInitialRobotX(), kinematicsSimulationParameters.getInitialRobotY());
        KinematicsToolboxHelper.setRobotStateFromRawData(robotInitialSetup.getInitialPelvisPose(), robotInitialSetup.getInitialJointAngles(), this.fullRobotModel.getRootJoint(), FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel));
        this.managerFactory = new HighLevelControlManagerFactory(managerParentRegistry);
        this.managerFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        this.managerFactory.setCopTrajectoryParameters(copTrajectoryParameters);
        this.managerFactory.setWalkingControllerParameters(walkingControllerParameters);
        this.walkingController = new WalkingHighLevelHumanoidController(this.walkingInputManager, this.walkingOutputManager, this.managerFactory, walkingControllerParameters, this.controllerToolbox);
        walkingParentRegistry.addChild(this.walkingController.getYoVariableRegistry());
        this.realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)kinematicsSimulationParameters.getPubSubImplementation(), (String)"kinematics_ihmc_controller_rt");
        ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        ROS2Topic outputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ControllerNetworkSubscriber controllerNetworkSubscriber = new ControllerNetworkSubscriber(inputTopic, this.walkingInputManager, outputTopic, this.walkingOutputManager, this.realtimeROS2Node);
        controllerNetworkSubscriber.addMessageFilter(message -> {
            if (message instanceof FootstepDataListMessage) {
                FootstepDataListMessage footstepDataListMessage = (FootstepDataListMessage)message;
                footstepDataListMessage.setOffsetFootstepsHeightWithExecutionError(false);
            }
            return true;
        });
        this.walkingInputManager.registerConversionHelper((CommandConversionInterface)new FrameMessageCommandConverter(this.controllerToolbox.getReferenceFrameHashCodeResolver()));
        controllerNetworkSubscriber.registerSubcriberWithMessageUnpacker(WholeBodyTrajectoryMessage.class, 9, MessageUnpackingTools.createWholeBodyTrajectoryMessageUnpacker());
        controllerNetworkSubscriber.addMessageCollectors(ControllerAPIDefinition.createDefaultMessageIDExtractor(), 3);
        controllerNetworkSubscriber.addMessageValidator(ControllerAPIDefinition.createDefaultMessageValidation());
        this.realtimeROS2Node.spin();
        WholeBodyControlCoreToolbox controlCoreToolbox = new WholeBodyControlCoreToolbox(kinematicsSimulationParameters.getDt(), 9.81, this.fullRobotModel.getRootJoint(), this.controllerToolbox.getControlledJoints(), this.controllerToolbox.getCenterOfMassFrame(), (ControllerCoreOptimizationSettings)walkingControllerParameters.getMomentumOptimizationSettings(), this.yoGraphicsListRegistry, this.registry);
        controlCoreToolbox.setJointPrivilegedConfigurationParameters(walkingControllerParameters.getJointPrivilegedConfigurationParameters());
        controlCoreToolbox.setFeedbackControllerSettings(walkingControllerParameters.getFeedbackControllerSettings());
        controlCoreToolbox.setupForInverseDynamicsSolver(this.controllerToolbox.getContactablePlaneBodies());
        this.controllerCore = new WholeBodyControllerCore(controlCoreToolbox, this.managerFactory.createFeedbackControlTemplate(), new JointDesiredOutputList((OneDoFJointReadOnly[])this.controllerToolbox.getControlledOneDoFJoints()), walkingParentRegistry);
        this.walkingController.setControllerCoreOutput(this.controllerCore.getOutputForHighLevelController());
        this.linearMomentumRateControlModule = new LinearMomentumRateControlModule(this.referenceFrames, this.controllerToolbox.getContactableFeet(), this.fullRobotModel.getElevator(), walkingControllerParameters, 9.81, this.controllerToolbox.getControlDT(), walkingParentRegistry, this.yoGraphicsListRegistry);
        ParameterLoaderHelper.loadParameters((Object)this, (WholeBodyControllerParameters)robotModel, (YoRegistry)drcControllerThreadRegistry);
        YoVariable defaultHeight = this.registry.findVariable(PelvisHeightControlState.class.getSimpleName(), PelvisHeightControlState.class.getSimpleName() + "DefaultHeight");
        if (Double.isNaN(defaultHeight.getValueAsDouble())) {
            throw new RuntimeException("Need to load a default height.");
        }
        if (kinematicsSimulationParameters.getLogToFile()) {
            this.intraprocessYoVariableLogger = new IntraprocessYoVariableLogger(this.getClass().getSimpleName(), robotModel.getLogModelProvider(), this.registry, this.fullRobotModel.getElevator(), this.yoGraphicsListRegistry, 100000, 0.01);
            this.intraprocessYoVariableLogger.start();
        }
        if (kinematicsSimulationParameters.getCreateYoVariableServer()) {
            this.yoVariableServer = new YoVariableServer(this.getClass().getSimpleName(), robotModel.getLogModelProvider(), new DataServerSettings(false), 0.01);
            this.yoVariableServer.setMainRegistry(this.registry, this.fullRobotModel.getElevator(), this.yoGraphicsListRegistry);
            this.yoVariableServer.start();
        }
        this.walkingOutputManager.attachStatusMessageListener(FootstepStatusMessage.class, this::processFootstepStatus);
        this.walkingOutputManager.attachStatusMessageListener(WalkingStatusMessage.class, this::processWalkingStatus);
        this.initialize();
        this.monotonicTimer.start();
        this.controlThread = new PausablePeriodicThread(this.getClass().getSimpleName(), kinematicsSimulationParameters.getUpdatePeriod(), 5, this::controllerTick);
        this.controlThread.start();
    }

    public void initialize() {
        this.zeroMotion();
        this.referenceFrames.updateFrames();
        this.controllerCore.initialize();
        this.walkingController.initialize();
        this.walkingController.requestImmediateTransitionToStandingAndHoldCurrent();
        for (RobotSide robotSide : RobotSide.values) {
            this.contactStateHolders.put((Enum)robotSide, (Object)HumanoidKinematicsSimulationContactStateHolder.holdAtCurrent((PlaneContactState)this.controllerToolbox.getFootContactStates().get((Enum)robotSide)));
        }
    }

    private void controllerTick() {
        this.doControl();
        RobotConfigurationData robotConfigurationData = HumanoidKinematicsSimulation.extractRobotConfigurationData(this.fullRobotModel);
        robotConfigurationData.setMonotonicTime(Conversions.secondsToNanoseconds((double)this.monotonicTimer.totalElapsed()));
        this.robotConfigurationDataPublisher.publish((Object)robotConfigurationData);
    }

    public void doControl() {
        this.yoTime.add(this.kinematicsSimulationParameters.getDt());
        this.fullRobotModel.updateFrames();
        this.referenceFrames.updateFrames();
        this.controllerToolbox.update();
        this.inverseDynamicsContactHolderCommandList.clear();
        for (RobotSide side : this.contactStateHolders.sides()) {
            ((HumanoidKinematicsSimulationContactStateHolder)this.contactStateHolders.get((Enum)side)).doControl();
            this.inverseDynamicsContactHolderCommandList.addCommand(((HumanoidKinematicsSimulationContactStateHolder)this.contactStateHolders.get((Enum)side)).getOutput());
        }
        if (this.contactStateHolders.sides().length == 1 && this.managerFactory.getOrCreateBalanceManager().isICPPlanDone()) {
            ((SettableFootSwitch)this.footSwitches.get((Enum)this.contactStateHolders.sides()[0].getOppositeSide())).setFootContactState(true);
        }
        this.walkingController.doAction();
        this.linearMomentumRateControlModule.setInputFromWalkingStateMachine(this.walkingController.getLinearMomentumRateControlModuleInput());
        if (!this.linearMomentumRateControlModule.computeControllerCoreCommands()) {
            this.controllerToolbox.reportControllerFailureToListeners(new FrameVector2D());
        }
        this.walkingController.setLinearMomentumRateControlModuleOutput(this.linearMomentumRateControlModule.getOutputForWalkingStateMachine());
        ControllerCoreCommand controllerCoreCommand = this.walkingController.getControllerCoreCommand();
        controllerCoreCommand.addInverseDynamicsCommand((InverseDynamicsCommand)this.linearMomentumRateControlModule.getMomentumRateCommand());
        controllerCoreCommand.addInverseDynamicsCommand((InverseDynamicsCommand)this.inverseDynamicsContactHolderCommandList);
        this.controllerCore.submitControllerCoreCommand((ControllerCoreCommandInterface)controllerCoreCommand);
        this.controllerCore.compute();
        this.linearMomentumRateControlModule.setInputFromControllerCore(this.controllerCore.getControllerCoreOutput());
        this.linearMomentumRateControlModule.computeAchievedCMP();
        this.fullRobotModel.getRootJoint().setJointAcceleration(0, (DMatrix)this.controllerCore.getOutputForRootJoint().getDesiredAcceleration());
        JointDesiredOutputListReadOnly jointDesiredOutputList = this.controllerCore.getOutputForLowLevelController();
        for (OneDoFJointBasics joint : this.controllerToolbox.getControlledOneDoFJoints()) {
            JointDesiredOutputReadOnly jointDesiredOutput = jointDesiredOutputList.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            joint.setQdd(jointDesiredOutput.getDesiredAcceleration());
        }
        this.integrator.setIntegrationDT(this.kinematicsSimulationParameters.getDt());
        this.integrator.doubleIntegrateFromAcceleration(Arrays.asList(this.controllerToolbox.getControlledJoints()));
        JointBasics hokuyoJoint = this.fullRobotModel.getLidarJoint("head_hokuyo_sensor");
        if (hokuyoJoint instanceof RevoluteJoint) {
            RevoluteJoint revoluteHokuyoJoint = (RevoluteJoint)hokuyoJoint;
            revoluteHokuyoJoint.setQ(revoluteHokuyoJoint.getQ() + 2.5 * this.kinematicsSimulationParameters.getUpdatePeriod());
        }
        this.yoVariableServerTime += Conversions.millisecondsToSeconds((double)1.0);
        if (this.kinematicsSimulationParameters.getLogToFile()) {
            this.intraprocessYoVariableLogger.update(Conversions.secondsToNanoseconds((double)this.yoVariableServerTime));
        }
        if (this.kinematicsSimulationParameters.getCreateYoVariableServer()) {
            this.yoVariableServer.update(Conversions.secondsToNanoseconds((double)this.yoVariableServerTime));
        }
    }

    private void zeroMotion() {
        for (JointBasics joint : this.fullRobotModel.getElevator().childrenSubtreeIterable()) {
            joint.setJointAccelerationToZero();
            joint.setJointTwistToZero();
        }
    }

    public static RobotConfigurationData extractRobotConfigurationData(FullHumanoidRobotModel fullRobotModel) {
        fullRobotModel.updateFrames();
        OneDoFJointBasics[] joints = FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)fullRobotModel);
        RobotConfigurationData robotConfigurationData = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])joints, (ForceSensorDefinition[])fullRobotModel.getForceSensorDefinitions(), (IMUDefinition[])fullRobotModel.getIMUDefinitions());
        RobotConfigurationDataFactory.packJointState((RobotConfigurationData)robotConfigurationData, Arrays.stream(joints).collect(Collectors.toList()));
        robotConfigurationData.getRootTranslation().set((Tuple3DReadOnly)fullRobotModel.getRootJoint().getJointPose().getPosition());
        robotConfigurationData.getRootOrientation().set((QuaternionReadOnly)fullRobotModel.getRootJoint().getJointPose().getOrientation());
        while (robotConfigurationData.getForceSensorData().size() < fullRobotModel.getForceSensorDefinitions().length) {
            robotConfigurationData.getForceSensorData().add();
        }
        return robotConfigurationData;
    }

    private void processFootstepStatus(FootstepStatusMessage statusMessage) {
        RobotSide side = RobotSide.fromByte((byte)statusMessage.getRobotSide());
        FootstepStatus status = FootstepStatus.fromByte((byte)statusMessage.getFootstepStatus());
        FramePose3D desiredFootstep = new FramePose3D(worldFrame, (Tuple3DReadOnly)statusMessage.getDesiredFootPositionInWorld(), (Orientation3DReadOnly)statusMessage.getDesiredFootOrientationInWorld());
        switch (status) {
            case STARTED: {
                this.contactStateHolders.remove((Object)side);
                ((SettableFootSwitch)this.footSwitches.get((Enum)side)).setFootContactState(false);
                break;
            }
            case COMPLETED: {
                this.contactStateHolders.put((Enum)side, (Object)new HumanoidKinematicsSimulationContactStateHolder((PlaneContactState)this.controllerToolbox.getFootContactStates().get((Enum)side), (FramePose3DReadOnly)desiredFootstep));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected status: " + status);
            }
        }
    }

    private void processWalkingStatus(WalkingStatusMessage status) {
        this.latestWalkingStatus.set(WalkingStatus.fromByte((byte)status.getWalkingStatus()));
    }

    public void destroy() {
        LogTools.info((String)"Shutting down...");
        this.controlThread.destroy();
        this.ros2Node.destroy();
        this.realtimeROS2Node.destroy();
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
        }
    }
}

