/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.kinematicsSimulation;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class HumanoidKinematicsSimulationContactStateHolder {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final PlaneContactState contactStateToHold;
    private final MovingReferenceFrame currentPlaneFrame;
    private final ReferenceFrame desiredPlaneFrame;
    private final double kp = 500.0;
    private final double zeta = 1.0;
    private final double kd = GainCalculator.computeDerivativeGain((double)500.0, (double)1.0);
    private final double weight = 50.0;
    private final InverseDynamicsCommandList commandList = new InverseDynamicsCommandList();

    public static HumanoidKinematicsSimulationContactStateHolder holdAtCurrent(PlaneContactState contactStateToHold) {
        FramePose3D desiredPose = new FramePose3D(contactStateToHold.getPlaneFrame());
        desiredPose.changeFrame(worldFrame);
        return new HumanoidKinematicsSimulationContactStateHolder(contactStateToHold, (FramePose3DReadOnly)desiredPose);
    }

    public HumanoidKinematicsSimulationContactStateHolder(PlaneContactState contactStateToHold, FramePose3DReadOnly desiredPlaneFramePose) {
        this.contactStateToHold = contactStateToHold;
        this.currentPlaneFrame = (MovingReferenceFrame)contactStateToHold.getPlaneFrame();
        desiredPlaneFramePose.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.desiredPlaneFrame = new PoseReferenceFrame("desiredPlaneFrame", desiredPlaneFramePose);
    }

    public void doControl() {
        this.commandList.clear();
        for (FramePoint3D currentContactPoint : this.contactStateToHold.getContactFramePointsInContactCopy()) {
            currentContactPoint.changeFrame((ReferenceFrame)this.currentPlaneFrame);
            FramePoint3D desiredContactPoint = new FramePoint3D(this.desiredPlaneFrame, (Tuple3DReadOnly)currentContactPoint);
            PoseReferenceFrame controlFrame = new PoseReferenceFrame("atContactPoint", (ReferenceFrame)this.currentPlaneFrame);
            controlFrame.setPositionAndUpdate((FramePoint3DReadOnly)currentContactPoint);
            FrameVector3D currentLinearVelocity = new FrameVector3D();
            this.currentPlaneFrame.getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)currentContactPoint, (FrameVector3DBasics)currentLinearVelocity);
            currentContactPoint.changeFrame(worldFrame);
            desiredContactPoint.changeFrame(worldFrame);
            currentLinearVelocity.changeFrame(worldFrame);
            FrameVector3D desiredLinearAcceleration = new FrameVector3D();
            desiredLinearAcceleration.sub((FrameTuple3DReadOnly)desiredContactPoint, (FrameTuple3DReadOnly)currentContactPoint);
            desiredLinearAcceleration.scale(500.0);
            desiredLinearAcceleration.scaleAdd(-this.kd, (FrameTuple3DReadOnly)currentLinearVelocity, (FrameTuple3DReadOnly)desiredLinearAcceleration);
            desiredLinearAcceleration.changeFrame((ReferenceFrame)controlFrame);
            SpatialAccelerationCommand command = new SpatialAccelerationCommand();
            RigidBodyBasics contactingBody = this.contactStateToHold.getRigidBody();
            command.set(MultiBodySystemTools.getRootBody((RigidBodyBasics)contactingBody), contactingBody);
            command.setLinearAcceleration((ReferenceFrame)controlFrame, (FrameVector3DReadOnly)desiredLinearAcceleration);
            command.setWeight(0.0, 50.0);
            command.setSelectionMatrixForLinearControl();
            this.commandList.addCommand((InverseDynamicsCommand)command);
        }
    }

    public InverseDynamicsCommand<?> getOutput() {
        return this.commandList;
    }
}

