/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.logProcessor.LogDataProcessorFunction;
import us.ihmc.avatar.logProcessor.LogDataProcessorHelper;
import us.ihmc.avatar.logProcessor.LogDataProcessorWrapper;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.PlotterInterface;
import us.ihmc.plotting.Plotter;
import us.ihmc.robotDataVisualizer.logger.LogVisualizer;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;

public abstract class DRCLogProcessor {
    private final LogVisualizer logVisualizer;
    private final Plotter plotter;
    private final LogDataProcessorWrapper logDataProcessorWrapper;
    private final FloatingRootJointRobot sdfRobot;
    protected final SimulationConstructionSet scs;
    protected final DRCRobotModel drcRobotModel = this.createDRCRobotModel();

    public DRCLogProcessor() throws IOException {
        this.logVisualizer = new LogVisualizer();
        this.scs = this.logVisualizer.getSimulationConstructionSet();
        this.plotter = this.logVisualizer.getPlotter();
        int numberOfTicksBeforeUpdatingGraphs = 500;
        this.scs.setFastSimulate(true, numberOfTicksBeforeUpdatingGraphs);
        this.logDataProcessorWrapper = new LogDataProcessorWrapper(this.scs);
        this.sdfRobot = this.logVisualizer.getSDFRobot();
        this.scs.addButton((AbstractButton)new UpdateLogDataProcessorButton(this.logDataProcessorWrapper));
    }

    public LogDataProcessorHelper createLogDataProcessorHelper() {
        return new LogDataProcessorHelper(this.drcRobotModel, this.scs, this.sdfRobot);
    }

    public abstract DRCRobotModel createDRCRobotModel();

    public final void setLogDataProcessor(LogDataProcessorFunction logDataProcessor) {
        YoGraphicsListRegistry yoGraphicsListRegistry = logDataProcessor.getYoGraphicsListRegistry();
        if (yoGraphicsListRegistry != null) {
            yoGraphicsListRegistry.addArtifactListsToPlotter((PlotterInterface)this.plotter);
            this.scs.addYoGraphicsListRegistry(yoGraphicsListRegistry);
        }
        this.logDataProcessorWrapper.addLogDataProcessor(logDataProcessor);
    }

    public final void startLogger() {
        this.logVisualizer.run();
    }

    private class UpdateLogDataProcessorButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -112620995090732618L;
        private final YoBufferProcessor dataProcessingFunction;

        public UpdateLogDataProcessorButton(YoBufferProcessor dataProcessingFunction) {
            super("Rerun log data processors");
            this.addActionListener(this);
            this.dataProcessingFunction = dataProcessingFunction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DRCLogProcessor.this.scs.applyDataProcessingFunction(this.dataProcessingFunction);
        }
    }
}

