/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logProcessor;

import java.util.LinkedHashMap;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.sensorProcessors.SensorProcessing;
import us.ihmc.sensorProcessing.simulatedSensors.StateEstimatorSensorDefinitions;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class LogDataRawSensorMap {
    private final String sensorProcessingName = SensorProcessing.class.getSimpleName();
    private final StateEstimatorSensorDefinitions stateEstimatorSensorDefinitions;
    private final YoLong timestamp;
    private final YoLong visionSensorTimestamp;
    private final LinkedHashMap<String, YoDouble> rawJointPositionMap = new LinkedHashMap();
    private final LinkedHashMap<String, YoDouble> rawJointVelocityMap = new LinkedHashMap();
    private final LinkedHashMap<String, YoDouble> rawJointTauMap = new LinkedHashMap();
    private final LinkedHashMap<String, YoFrameQuaternion> rawIMUOrientationMap = new LinkedHashMap();
    private final LinkedHashMap<String, YoFrameVector3D> rawIMUAngularVelocityMap = new LinkedHashMap();
    private final LinkedHashMap<String, YoFrameVector3D> rawIMULinearAccelerationMap = new LinkedHashMap();

    public LogDataRawSensorMap(FullRobotModel fullRobotModel, YoVariableHolder yoVariableHolder) {
        this.stateEstimatorSensorDefinitions = this.buildStateEstimatorSensorDefinitions(fullRobotModel);
        this.timestamp = (YoLong)yoVariableHolder.findVariable(this.sensorProcessingName, "timestamp");
        this.visionSensorTimestamp = (YoLong)yoVariableHolder.findVariable(this.sensorProcessingName, "visionSensorTimestamp");
        for (OneDoFJointBasics joint : this.stateEstimatorSensorDefinitions.getJointSensorDefinitions()) {
            String jointName = joint.getName();
            YoDouble rawJointPosition = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_q_" + jointName);
            this.rawJointPositionMap.put(jointName, rawJointPosition);
            YoDouble rawJointVelocity = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_qd_" + jointName);
            this.rawJointVelocityMap.put(jointName, rawJointVelocity);
            YoDouble rawJointTau = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_tau_" + jointName);
            this.rawJointTauMap.put(jointName, rawJointTau);
        }
        for (IMUDefinition imuDefinition : this.stateEstimatorSensorDefinitions.getIMUSensorDefinitions()) {
            String imuName = imuDefinition.getName();
            YoDouble qx = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_q_Qx" + imuName);
            YoDouble qy = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_q_Qy" + imuName);
            YoDouble qz = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_q_Qz" + imuName);
            YoDouble qs = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, "raw_q_Qs" + imuName);
            if (qx != null && qy != null && qz != null && qs != null) {
                YoFrameQuaternion rawOrientation = new YoFrameQuaternion(qx, qy, qz, qs, null);
                this.rawIMUOrientationMap.put(imuName, rawOrientation);
            }
            YoDouble qd_wx = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, YoGeometryNameTools.createXName((String)"raw_qd_w", (String)imuName));
            YoDouble qd_wy = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, YoGeometryNameTools.createYName((String)"raw_qd_w", (String)imuName));
            YoDouble qd_wz = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, YoGeometryNameTools.createZName((String)"raw_qd_w", (String)imuName));
            if (qd_wx != null && qd_wy != null && qd_wz != null) {
                YoFrameVector3D rawAngularVelocity = new YoFrameVector3D(qd_wx, qd_wy, qd_wz, null);
                this.rawIMUAngularVelocityMap.put(imuName, rawAngularVelocity);
            }
            YoDouble qdd_x = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, YoGeometryNameTools.createXName((String)"raw_qdd_", (String)imuName));
            YoDouble qdd_y = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, YoGeometryNameTools.createYName((String)"raw_qdd_", (String)imuName));
            YoDouble qdd_z = (YoDouble)yoVariableHolder.findVariable(this.sensorProcessingName, YoGeometryNameTools.createZName((String)"raw_qdd_", (String)imuName));
            if (qdd_x == null || qdd_y == null || qdd_z == null) continue;
            YoFrameVector3D rawLinearAcceleration = new YoFrameVector3D(qdd_x, qdd_y, qdd_z, null);
            this.rawIMULinearAccelerationMap.put(imuName, rawLinearAcceleration);
        }
    }

    private StateEstimatorSensorDefinitions buildStateEstimatorSensorDefinitions(FullRobotModel fullRobotModel) {
        FloatingJointBasics rootJoint = fullRobotModel.getRootJoint();
        IMUDefinition[] imuDefinitions = fullRobotModel.getIMUDefinitions();
        ForceSensorDefinition[] forceSensorDefinitions = fullRobotModel.getForceSensorDefinitions();
        StateEstimatorSensorDefinitions stateEstimatorSensorDefinitions = new StateEstimatorSensorDefinitions();
        for (JointBasics joint : rootJoint.subtreeIterable()) {
            if (!(joint instanceof OneDoFJointBasics)) continue;
            OneDoFJointBasics oneDoFJoint = (OneDoFJointBasics)joint;
            stateEstimatorSensorDefinitions.addJointSensorDefinition(oneDoFJoint);
        }
        for (IMUDefinition iMUDefinition : imuDefinitions) {
            stateEstimatorSensorDefinitions.addIMUSensorDefinition(iMUDefinition);
        }
        for (IMUDefinition iMUDefinition : forceSensorDefinitions) {
            stateEstimatorSensorDefinitions.addForceSensorDefinition((ForceSensorDefinition)iMUDefinition);
        }
        return stateEstimatorSensorDefinitions;
    }

    public long getTimestamp() {
        return this.timestamp.getLongValue();
    }

    public long getVisionSensorTimestamp() {
        return this.visionSensorTimestamp.getLongValue();
    }

    public StateEstimatorSensorDefinitions getStateEstimatorSensorDefinitions() {
        return this.stateEstimatorSensorDefinitions;
    }

    public double getRawJointPosition(String jointName) {
        return this.rawJointPositionMap.get(jointName).getDoubleValue();
    }

    public double getRawJointVelocity(String jointName) {
        return this.rawJointVelocityMap.get(jointName).getDoubleValue();
    }

    public double getRawJointTau(String jointName) {
        return this.rawJointTauMap.get(jointName).getDoubleValue();
    }

    public void getRawIMUOrientation(String imuName, Quaternion orientationToPack) {
        orientationToPack.set((QuaternionReadOnly)this.rawIMUOrientationMap.get(imuName));
    }

    public void getRawIMUAngularVelocity(String imuName, Vector3D angularVelocityToPack) {
        angularVelocityToPack.set((Tuple3DReadOnly)this.rawIMUAngularVelocityMap.get(imuName));
    }

    public void getRawIMULinearAcceleration(String imuName, Vector3D linearAccelerationToPack) {
        linearAccelerationToPack.set((Tuple3DReadOnly)this.rawIMULinearAccelerationMap.get(imuName));
    }
}

