/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionsListBuffer {
    private int buffer_length;
    private HashMap<Integer, Container> indexBuffer;
    private TreeSet<Container> timeBuffer;
    private long firstEverTime = Long.MAX_VALUE;
    private int index = 0;
    private static final Comparator<Container> customCompare = (o1, o2) -> {
        long compare = o1.getTime() - o2.getTime();
        if (compare > 0L) {
            return 1;
        }
        if (compare == 0L) {
            return 0;
        }
        return -1;
    };

    public void loadFromLog(File planarRegionListLog) throws IOException {
        this.indexBuffer = new HashMap();
        this.timeBuffer = new TreeSet<Container>(customCompare);
        Scanner in = new Scanner(planarRegionListLog);
        in.useDelimiter("##\n");
        in.next();
        int index = 0;
        while (in.hasNext()) {
            in.nextLine();
            long time = Long.parseLong(in.nextLine());
            File temp = File.createTempFile("prll", ".tmp");
            temp.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(temp);){
                IOUtils.copy((Reader)new StringReader(in.next()), (OutputStream)out);
            }
            PlanarRegionsList list = PlanarRegionFileTools.importPlanarRegionData((File)temp);
            Container container = new Container(index, time, list);
            this.indexBuffer.put(index, container);
            this.timeBuffer.add(container);
            this.firstEverTime = this.getStartTime();
            ++index;
        }
        if (this.buffer_length < this.indexBuffer.size()) {
            this.buffer_length = this.indexBuffer.size();
        }
        if (this.buffer_length <= 0) {
            LogTools.warn((String)"Loaded empty log into PlanarRegionsListBuffer");
        }
    }

    public PlanarRegionsListBuffer(File planarRegionListLog) throws IOException {
        this.loadFromLog(planarRegionListLog);
        this.buffer_length = this.indexBuffer.size();
    }

    public PlanarRegionsListBuffer() {
        this(Integer.MAX_VALUE);
    }

    public PlanarRegionsListBuffer(int buffer_length) {
        this.buffer_length = buffer_length;
        this.indexBuffer = new HashMap();
        this.timeBuffer = new TreeSet<Container>(customCompare);
    }

    public void expandBuffer(long additionalSize) {
        if (additionalSize <= 0L) {
            return;
        }
        this.buffer_length = (int)((long)this.buffer_length + additionalSize);
    }

    public void putAndTick(long time, PlanarRegionsList list) {
        Container container = new Container(this.index, time, list);
        this.indexBuffer.put(this.index, container);
        this.timeBuffer.add(container);
        if (this.index > this.buffer_length) {
            this.indexBuffer.remove(this.index - this.buffer_length);
            this.timeBuffer.remove(this.timeBuffer.first());
        }
        if (time < this.firstEverTime) {
            this.firstEverTime = time;
        }
        ++this.index;
    }

    public PlanarRegionsList get(int index) {
        Container container = this.indexBuffer.get(index);
        return container == null ? null : container.getList();
    }

    private Container getNearTimeInternal(long time) {
        Container value;
        Container lookup = new Container(-1, time, null);
        Container lower = this.timeBuffer.lower(lookup);
        Container higher = this.timeBuffer.higher(lookup);
        if (lower == null) {
            if (higher == null) {
                return null;
            }
            value = higher;
        } else {
            value = higher == null ? lower : (Math.abs(lower.getTime() - time) > Math.abs(higher.getTime() - time) ? higher : lower);
        }
        return value;
    }

    public PlanarRegionsList getNearTime(long time) {
        Container c = this.getNearTimeInternal(time);
        return c != null ? c.getList() : null;
    }

    public long getNextTime(long currentTime) {
        if (this.indexBuffer.size() < 1) {
            return -1L;
        }
        Container container = this.indexBuffer.get(this.getNearTimeInternal(currentTime + 1L).index + 1);
        return container == null ? Long.MAX_VALUE : container.getTime();
    }

    public long getPreviousTime(long currentTime) {
        if (this.indexBuffer.size() < 1) {
            return -1L;
        }
        Container container = this.indexBuffer.get(this.getNearTimeInternal(currentTime - 1L).index - 1);
        return container == null ? 0L : container.getTime();
    }

    public long getCurrentIndex() {
        return this.index;
    }

    public int getBufferLength() {
        return this.buffer_length;
    }

    public long getFirstEverTime() {
        return this.firstEverTime;
    }

    public long getStartTime() {
        if (this.timeBuffer.size() == 0) {
            return -1L;
        }
        return this.timeBuffer.first().getTime();
    }

    public long getEndTime() {
        if (this.timeBuffer.size() == 0) {
            return -1L;
        }
        return this.timeBuffer.last().getTime();
    }

    private static class Container {
        private PlanarRegionsList list;
        private long time;
        private int index;

        Container(int index, long time, PlanarRegionsList list) {
            this.list = list;
            this.index = index;
            this.time = time;
        }

        public PlanarRegionsList getList() {
            return this.list;
        }

        public long getTime() {
            return this.time;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

