/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.multiContact;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controller_msgs.msg.dds.KinematicsToolboxOutputStatus;
import controller_msgs.msg.dds.KinematicsToolboxOutputStatusPubSubType;
import controller_msgs.msg.dds.KinematicsToolboxPrivilegedConfigurationMessage;
import controller_msgs.msg.dds.KinematicsToolboxPrivilegedConfigurationMessagePubSubType;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.RobotConfigurationDataPubSubType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import us.ihmc.avatar.multiContact.CenterOfMassMotionControlAnchorDescription;
import us.ihmc.avatar.multiContact.OneDoFMotionControlAnchorDescription;
import us.ihmc.avatar.multiContact.SixDoFMotionControlAnchorDescription;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.pubsub.TopicDataType;

public class KinematicsToolboxSnapshotDescription {
    public static final String CONFIGURATION_JSON = KinematicsToolboxSnapshotDescription.class.getSimpleName();
    public static final String CONTROLLER_CONFIGURATION_JSON = "controllerConfiguration";
    public static final String IK_SOLUTION_JSON = "ikSolution";
    public static final String IK_PRIVILEGED_CONFIGURATION_JSON = "ikPrivilegedConfiguration";
    public static final String COM_ANCHOR_JSON = "centerOfMassAnchor";
    public static final String SIX_DOF_ANCHORS_JSON = "sixDoFAnchors";
    public static final String ONE_DOF_ANCHORS_JSON = "oneDoFAnchors";
    private static final ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
    private static final JSONSerializer<RobotConfigurationData> rcdSerializer = new JSONSerializer((TopicDataType)new RobotConfigurationDataPubSubType());
    private static final JSONSerializer<KinematicsToolboxOutputStatus> ktosSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxOutputStatusPubSubType());
    private static final JSONSerializer<KinematicsToolboxPrivilegedConfigurationMessage> ktpcmSerializer = new JSONSerializer((TopicDataType)new KinematicsToolboxPrivilegedConfigurationMessagePubSubType());
    public RobotConfigurationData controllerConfiguration;
    public KinematicsToolboxOutputStatus ikSolution;
    public KinematicsToolboxPrivilegedConfigurationMessage ikPrivilegedConfiguration;
    public CenterOfMassMotionControlAnchorDescription centerOfMassAnchor;
    public List<SixDoFMotionControlAnchorDescription> sixDoFAnchors;
    public List<OneDoFMotionControlAnchorDescription> oneDoFAnchors;

    public KinematicsToolboxSnapshotDescription() {
    }

    public KinematicsToolboxSnapshotDescription(KinematicsToolboxSnapshotDescription other) {
        this.controllerConfiguration = new RobotConfigurationData(other.controllerConfiguration);
        this.ikSolution = new KinematicsToolboxOutputStatus(other.ikSolution);
        this.ikPrivilegedConfiguration = new KinematicsToolboxPrivilegedConfigurationMessage(other.ikPrivilegedConfiguration);
        this.sixDoFAnchors = other.sixDoFAnchors.stream().map(SixDoFMotionControlAnchorDescription::new).collect(Collectors.toList());
        this.oneDoFAnchors = other.oneDoFAnchors.stream().map(OneDoFMotionControlAnchorDescription::new).collect(Collectors.toList());
        this.centerOfMassAnchor = other.centerOfMassAnchor == null ? new CenterOfMassMotionControlAnchorDescription() : new CenterOfMassMotionControlAnchorDescription(other.centerOfMassAnchor);
    }

    public static KinematicsToolboxSnapshotDescription fromJSON(JsonNode node) {
        JsonNode configurationNode = node.get(CONFIGURATION_JSON);
        try {
            KinematicsToolboxSnapshotDescription description = new KinematicsToolboxSnapshotDescription();
            description.setControllerConfiguration((RobotConfigurationData)rcdSerializer.deserialize(configurationNode.get(CONTROLLER_CONFIGURATION_JSON).toString()));
            description.setIkSolution((KinematicsToolboxOutputStatus)ktosSerializer.deserialize(configurationNode.get(IK_SOLUTION_JSON).toString()));
            description.setIkPrivilegedConfiguration((KinematicsToolboxPrivilegedConfigurationMessage)ktpcmSerializer.deserialize(configurationNode.get(IK_PRIVILEGED_CONFIGURATION_JSON).toString()));
            description.setCenterOfMassAnchor(CenterOfMassMotionControlAnchorDescription.fromJSON(configurationNode.get(COM_ANCHOR_JSON)));
            JsonNode sixDoFAnchorsNode = configurationNode.get(SIX_DOF_ANCHORS_JSON);
            ArrayList<SixDoFMotionControlAnchorDescription> sixDoFAnchors = new ArrayList<SixDoFMotionControlAnchorDescription>();
            for (int i = 0; i < sixDoFAnchorsNode.size(); ++i) {
                sixDoFAnchors.add(SixDoFMotionControlAnchorDescription.fromJSON(sixDoFAnchorsNode.get(i)));
            }
            description.setSixDoFAnchors(sixDoFAnchors);
            JsonNode oneDoFAnchorsNode = configurationNode.get(ONE_DOF_ANCHORS_JSON);
            ArrayList<OneDoFMotionControlAnchorDescription> oneDoFAnchors = new ArrayList<OneDoFMotionControlAnchorDescription>();
            for (int i = 0; i < oneDoFAnchorsNode.size(); ++i) {
                oneDoFAnchors.add(OneDoFMotionControlAnchorDescription.fromJSON(oneDoFAnchorsNode.get(i)));
            }
            description.setOneDoFAnchors(oneDoFAnchors);
            return description;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode toJSON(ObjectMapper objectMapper) {
        Objects.requireNonNull(this.controllerConfiguration);
        Objects.requireNonNull(this.ikSolution);
        Objects.requireNonNull(this.ikPrivilegedConfiguration);
        Objects.requireNonNull(this.sixDoFAnchors);
        Objects.requireNonNull(this.oneDoFAnchors);
        try {
            ObjectNode root = objectMapper.createObjectNode();
            ObjectNode configurationJSON = root.putObject(CONFIGURATION_JSON);
            configurationJSON.set(CONTROLLER_CONFIGURATION_JSON, KinematicsToolboxSnapshotDescription.messageToJSON(rcdSerializer, this.controllerConfiguration));
            configurationJSON.set(IK_SOLUTION_JSON, KinematicsToolboxSnapshotDescription.messageToJSON(ktosSerializer, this.ikSolution));
            configurationJSON.set(IK_PRIVILEGED_CONFIGURATION_JSON, KinematicsToolboxSnapshotDescription.messageToJSON(ktpcmSerializer, this.ikPrivilegedConfiguration));
            if (this.centerOfMassAnchor != null) {
                configurationJSON.set(COM_ANCHOR_JSON, this.centerOfMassAnchor.toJSON(objectMapper));
            }
            ArrayNode arraySixDoFAnchorNode = configurationJSON.arrayNode(this.sixDoFAnchors.size());
            this.sixDoFAnchors.forEach(anchor -> arraySixDoFAnchorNode.add(anchor.toJSON(objectMapper)));
            configurationJSON.set(SIX_DOF_ANCHORS_JSON, (JsonNode)arraySixDoFAnchorNode);
            ArrayNode arrayOneDoFAnchorNode = configurationJSON.arrayNode(this.oneDoFAnchors.size());
            this.oneDoFAnchors.forEach(anchor -> arrayOneDoFAnchorNode.add(anchor.toJSON(objectMapper)));
            configurationJSON.set(ONE_DOF_ANCHORS_JSON, (JsonNode)arrayOneDoFAnchorNode);
            return root;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> JsonNode messageToJSON(JSONSerializer<T> serializer, T message) throws IOException {
        return objectMapper.readTree(serializer.serializeToString(message));
    }

    public RobotConfigurationData getControllerConfiguration() {
        return this.controllerConfiguration;
    }

    public KinematicsToolboxOutputStatus getIkSolution() {
        return this.ikSolution;
    }

    public KinematicsToolboxPrivilegedConfigurationMessage getIkPrivilegedConfiguration() {
        return this.ikPrivilegedConfiguration;
    }

    public CenterOfMassMotionControlAnchorDescription getCenterOfMassAnchor() {
        return this.centerOfMassAnchor;
    }

    public List<SixDoFMotionControlAnchorDescription> getSixDoFAnchors() {
        return this.sixDoFAnchors;
    }

    public List<OneDoFMotionControlAnchorDescription> getOneDoFAnchors() {
        return this.oneDoFAnchors;
    }

    public void setControllerConfiguration(RobotConfigurationData controllerConfiguration) {
        this.controllerConfiguration = controllerConfiguration;
    }

    public void setIkSolution(KinematicsToolboxOutputStatus ikSolution) {
        this.ikSolution = ikSolution;
    }

    public void setIkPrivilegedConfiguration(KinematicsToolboxPrivilegedConfigurationMessage ikPrivilegedConfiguration) {
        this.ikPrivilegedConfiguration = ikPrivilegedConfiguration;
    }

    public void setCenterOfMassAnchor(CenterOfMassMotionControlAnchorDescription centerOfMassAnchor) {
        this.centerOfMassAnchor = centerOfMassAnchor;
    }

    public void setSixDoFAnchors(List<SixDoFMotionControlAnchorDescription> sixDoFAnchors) {
        this.sixDoFAnchors = sixDoFAnchors;
    }

    public void setOneDoFAnchors(List<OneDoFMotionControlAnchorDescription> oneDoFAnchors) {
        this.oneDoFAnchors = oneDoFAnchors;
    }

    public void applyTransform(Transform transform) {
        this.controllerConfiguration.getRootTranslation().applyTransform(transform);
        this.controllerConfiguration.getRootOrientation().applyTransform(transform);
        this.ikSolution.getDesiredRootTranslation().applyTransform(transform);
        this.ikSolution.getDesiredRootOrientation().applyTransform(transform);
        this.ikPrivilegedConfiguration.getPrivilegedRootJointPosition().applyTransform(transform);
        this.ikPrivilegedConfiguration.getPrivilegedRootJointOrientation().applyTransform(transform);
        if (this.centerOfMassAnchor != null) {
            this.centerOfMassAnchor.applyTransform(transform);
        }
        this.sixDoFAnchors.forEach(anchor -> anchor.applyTransform(transform));
    }

    public String toString() {
        return String.format("[%s=%s,\n\t%s=%s,\n\t%s=%s,\n\t%s=%s,\n\t%s=%s\n]", CONTROLLER_CONFIGURATION_JSON, this.controllerConfiguration, IK_SOLUTION_JSON, this.ikSolution, IK_PRIVILEGED_CONFIGURATION_JSON, this.ikPrivilegedConfiguration, SIX_DOF_ANCHORS_JSON, this.sixDoFAnchors, ONE_DOF_ANCHORS_JSON, this.oneDoFAnchors);
    }
}

